/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.content.fragments;

import chylex.hee.gui.GuiEnderCompendium;
import chylex.hee.gui.helpers.GuiItemRenderHelper;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.compendium.content.KnowledgeFragment;
import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.objects.IKnowledgeObjectInstance;
import chylex.hee.mechanics.compendium.util.KnowledgeUtils;
import chylex.hee.system.J8;
import chylex.hee.system.logging.Log;
import chylex.hee.system.util.RecipeUnifier;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import org.lwjgl.opengl.GL11;

public class KnowledgeFragmentCrafting
extends KnowledgeFragment {
    public static final ItemStack lockedItem = new ItemStack(ItemList.special_effects, 1, 18);
    private ItemStack findOutput;
    private ItemStack[] findIngredients;
    private ItemStack[] ingredients;
    private ItemStack output;
    private Status status;

    private static RecipeUnifier.Recipe findRecipe(ItemStack outputToFind, final @Nullable ItemStack[] matchIngredients) {
        List list = CraftingManager.func_77594_a().func_77592_b();
        for (int a = list.size() - 1; a >= 0; --a) {
            IRecipe recipe = (IRecipe)list.get(a);
            if (!ItemStack.func_77989_b((ItemStack)outputToFind, (ItemStack)recipe.func_77571_b())) continue;
            RecipeUnifier.Recipe unified = new RecipeUnifier().unify(recipe);
            final ItemStack[] ingredients = unified.getIngredientArray();
            if (matchIngredients == null) {
                return unified;
            }
            if (matchIngredients.length != ingredients.length || !J8.allMatch(ingredients.length, new Predicate<Integer>(){

                public boolean apply(Integer index) {
                    return ingredients[index].func_77973_b() == matchIngredients[index].func_77973_b() && ingredients[index].func_77960_j() == matchIngredients[index].func_77960_j();
                }
            })) continue;
            return unified;
        }
        return null;
    }

    public KnowledgeFragmentCrafting(int globalID) {
        super(globalID);
    }

    public KnowledgeFragmentCrafting setRecipe(ItemStack outputToFind) {
        return this.setRecipe(outputToFind, null);
    }

    public KnowledgeFragmentCrafting setRecipe(ItemStack outputToFind, @Nullable ItemStack[] matchIngredients) {
        this.findOutput = outputToFind;
        this.findIngredients = matchIngredients;
        RecipeUnifier.Recipe recipe = KnowledgeFragmentCrafting.findRecipe(outputToFind, matchIngredients);
        if (recipe != null) {
            this.ingredients = recipe.getIngredientArray();
            this.output = recipe.getOutput();
            this.status = Status.UNVERIFIED;
        } else {
            Log.warn("Could not find ItemStack $0 when registering recipe from registry.", outputToFind.toString());
        }
        return this;
    }

    private void verifyRecipe() {
        if (this.status != Status.UNVERIFIED) {
            return;
        }
        final RecipeUnifier.Recipe recipe = KnowledgeFragmentCrafting.findRecipe(this.findOutput, this.findIngredients);
        if (recipe == null) {
            this.status = Status.REMOVED;
            this.output = null;
            this.ingredients = null;
            return;
        }
        if (ItemStack.func_77989_b((ItemStack)recipe.getOutput(), (ItemStack)this.output) && this.ingredients != null && this.ingredients.length == recipe.getIngredientArray().length && J8.allMatch(this.ingredients.length, new Predicate<Integer>(){

            public boolean apply(Integer index) {
                return ItemStack.func_77989_b((ItemStack)KnowledgeFragmentCrafting.this.ingredients[index], (ItemStack)recipe.getIngredientArray()[index]);
            }
        })) {
            this.status = Status.FINE;
            return;
        }
        this.ingredients = recipe.getIngredientArray();
        this.output = recipe.getOutput();
        this.status = Status.CHANGED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getHeight(GuiEnderCompendium gui, boolean isUnlocked) {
        return 58;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onClick(GuiEnderCompendium gui, int x, int y, int mouseX, int mouseY, int buttonId, boolean isUnlocked) {
        if (this.ingredients == null || this.output == null || !isUnlocked || buttonId != 0) {
            return false;
        }
        KnowledgeObject<? extends IKnowledgeObjectInstance<?>> obj = null;
        int a = 0;
        int cnt = 0;
        int xx = x;
        int yy = y;
        while (a < this.ingredients.length) {
            if (this.ingredients[a] != null && KnowledgeFragmentCrafting.checkRect(mouseX, mouseY, xx + 1, yy + 1, 17, 17)) {
                obj = KnowledgeUtils.tryGetFromItemStack(this.ingredients[a]);
                break;
            }
            if (++cnt >= 3) {
                yy += 19;
                xx -= 57;
                cnt = 0;
            }
            ++a;
            xx += 19;
        }
        if (obj == null && KnowledgeFragmentCrafting.checkRect(mouseX, mouseY, x + 95, y + 20, 17, 17)) {
            obj = KnowledgeUtils.tryGetFromItemStack(this.output);
        }
        if (obj != null) {
            gui.showObject(obj);
            gui.moveToCurrentObject(true);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRender(GuiEnderCompendium gui, int x, int y, int mouseX, int mouseY, boolean isUnlocked) {
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.field_146297_k.func_110434_K().func_110577_a(GuiEnderCompendium.texFragments);
        gui.func_73729_b(x, y, 0, 0, 88, 58);
        this.verifyRecipe();
        if (this.status != Status.FINE) {
            gui.field_146297_k.field_71466_p.func_78276_b("?", x + 107, y + 8, -16777216);
            if (KnowledgeFragmentCrafting.checkRect(mouseX, mouseY, x + 106, y + 7, 6, 9)) {
                GuiItemRenderHelper.setupTooltip(mouseX, mouseY, I18n.func_135052_a((String)(this.status == Status.CHANGED ? "compendium.crafting.changed" : "compendium.crafting.removed"), (Object[])new Object[0]));
            }
        }
        if (this.ingredients == null || this.output == null) {
            return;
        }
        int a = 0;
        int cnt = 0;
        int xx = x;
        int yy = y;
        while (a < (isUnlocked ? this.ingredients.length : 9)) {
            ItemStack is = isUnlocked ? this.ingredients[a] : lockedItem;
            if (is != null) {
                GuiItemRenderHelper.renderItemIntoGUI(gui.field_146297_k.func_110434_K(), is, xx + 2, yy + 2);
                if (isUnlocked && KnowledgeFragmentCrafting.checkRect(mouseX, mouseY, xx + 1, yy + 1, 17, 17)) {
                    GuiItemRenderHelper.setupTooltip(mouseX, mouseY, Joiner.on((char)'\n').join(KnowledgeUtils.getCompendiumTooltip(is, (EntityPlayer)gui.field_146297_k.field_71439_g)));
                }
            }
            if (++cnt >= 3) {
                yy += 19;
                xx -= 57;
                cnt = 0;
            }
            ++a;
            xx += 19;
        }
        GuiItemRenderHelper.renderItemIntoGUI(gui.field_146297_k.func_110434_K(), this.output, x + 96, y + 21);
        if (isUnlocked && KnowledgeFragmentCrafting.checkRect(mouseX, mouseY, x + 95, y + 20, 17, 17)) {
            GuiItemRenderHelper.setupTooltip(mouseX, mouseY, Joiner.on((char)'\n').join(KnowledgeUtils.getCompendiumTooltip(this.output, (EntityPlayer)gui.field_146297_k.field_71439_g)));
        }
    }

    private static final boolean checkRect(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= x && mouseY >= y && mouseX <= x + w && mouseY <= y + h;
    }

    private static enum Status {
        UNVERIFIED,
        FINE,
        CHANGED,
        REMOVED;

    }
}

