/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.item;

import chylex.hee.entity.boss.EntityBossEnderDemon;
import chylex.hee.entity.boss.EntityMiniBossEnderEye;
import chylex.hee.entity.boss.EntityMiniBossFireFiend;
import chylex.hee.entity.mob.EntityMobAngryEnderman;
import chylex.hee.entity.mob.EntityMobBabyEnderman;
import chylex.hee.entity.mob.EntityMobEnderGuardian;
import chylex.hee.entity.mob.EntityMobEndermage;
import chylex.hee.entity.mob.EntityMobFireGolem;
import chylex.hee.entity.mob.EntityMobHauntedMiner;
import chylex.hee.entity.mob.EntityMobHomelandEnderman;
import chylex.hee.entity.mob.EntityMobInfestedBat;
import chylex.hee.entity.mob.EntityMobLouse;
import chylex.hee.entity.mob.EntityMobParalyzedEnderman;
import chylex.hee.entity.mob.EntityMobScorchingLens;
import chylex.hee.entity.mob.EntityMobVampiricBat;
import chylex.hee.system.util.BlockPosM;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemSpawnEggs
extends ItemMonsterPlacer {
    private static final EggData[] eggTypes = new EggData[]{new EggData("angryEnderman", EntityMobAngryEnderman.class, new int[]{22, 22, 22}, new int[]{87, 45, 45}), new EggData("babyEnderman", EntityMobBabyEnderman.class, new int[]{22, 22, 22}, new int[]{91, 67, 124}), new EggData("enderGuardian", EntityMobEnderGuardian.class, new int[]{22, 22, 22}, new int[]{68, 45, 87}), new EggData("vampireBat", EntityMobVampiricBat.class, new int[]{76, 62, 48}, new int[]{70, 35, 71}), new EggData("infestedBat", EntityMobInfestedBat.class, new int[]{76, 62, 48}, new int[]{129, 48, 39}), new EggData("fireGolem", EntityMobFireGolem.class, new int[]{68, 16, 0}, new int[]{210, 142, 50}), new EggData("scorchingLens", EntityMobScorchingLens.class, new int[]{255, 112, 0}, new int[]{253, 9, 8}), new EggData("enderEye", EntityMiniBossEnderEye.class, new int[]{22, 22, 22}, new int[]{255, 255, 255}), new EggData("fireFiend", EntityMiniBossFireFiend.class, new int[]{68, 16, 0}, new int[]{33, 0, 0}), new EggData("enderDemon", EntityBossEnderDemon.class, new int[]{22, 22, 22}, new int[]{86, 21, 111}), new EggData("brainlessEnderman", EntityMobParalyzedEnderman.class, new int[]{22, 22, 22}, new int[]{190, 190, 190}), new EggData("louse", EntityMobLouse.class, new int[]{45, 45, 45}, new int[]{80, 0, 140}), new EggData("hauntedMiner", EntityMobHauntedMiner.class, new int[]{48, 23, 23}, new int[]{170, 72, 37}), new EggData("homelandEnderman", EntityMobHomelandEnderman.class, new int[]{22, 22, 22}, new int[]{199, 44, 44}), new EggData("endermage", EntityMobEndermage.class, new int[]{22, 22, 22}, new int[]{217, 210, 84})};

    private static EggData getEggData(ItemStack is) {
        int damage = is.func_77960_j();
        return damage >= 0 && damage < eggTypes.length ? eggTypes[damage] : null;
    }

    public static int getDamageForMob(Class<? extends EntityLiving> mobClass) {
        for (int damage = 0; damage < eggTypes.length; ++damage) {
            if (ItemSpawnEggs.eggTypes[damage].entityClass != mobClass) continue;
            return damage;
        }
        return -1;
    }

    public static Class<? extends EntityLiving> getMobFromDamage(int damage) {
        return damage >= 0 && damage < eggTypes.length ? ItemSpawnEggs.eggTypes[damage].entityClass : null;
    }

    public static String getMobName(Class<?> mobClass) {
        for (EggData eggData : eggTypes) {
            if (eggData.entityClass != mobClass) continue;
            return StatCollector.func_74838_a((String)("entity." + eggData.entityName + ".name"));
        }
        return "Unknown Mob";
    }

    public ItemSpawnEggs() {
        this.func_77627_a(true);
    }

    public String func_77653_i(ItemStack is) {
        String s = StatCollector.func_74838_a((String)(this.func_77658_a() + ".name")).trim();
        EggData egg = ItemSpawnEggs.getEggData(is);
        if (egg != null) {
            s = s + " " + StatCollector.func_74838_a((String)("entity." + egg.entityName + ".name"));
        }
        return s;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        Block block = BlockPosM.tmp(x, y, z).getBlock((IBlockAccess)world);
        x += Facing.field_71586_b[side];
        y += Facing.field_71587_c[side];
        z += Facing.field_71585_d[side];
        EggData egg = ItemSpawnEggs.getEggData(is);
        if (egg != null) {
            egg.spawnMob(world, (double)x + 0.5, (double)y + (side == 1 && block != null && block.func_149645_b() == 11 ? 0.5 : 0.0), (double)z + 0.5, is);
            if (!player.field_71075_bZ.field_75098_d) {
                --is.field_77994_a;
            }
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return is;
        }
        MovingObjectPosition mop = this.func_77621_a(world, player, true);
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            EggData egg;
            int x = mop.field_72311_b;
            int y = mop.field_72312_c;
            int z = mop.field_72309_d;
            if (!world.func_72962_a(player, x, y, z) || !player.func_82247_a(x, y, z, mop.field_72310_e, is)) {
                return is;
            }
            if (BlockPosM.tmp(x, y, z).getMaterial((IBlockAccess)world) == Material.field_151586_h && (egg = ItemSpawnEggs.getEggData(is)) != null) {
                egg.spawnMob(world, x, y, z, is);
                if (!player.field_71075_bZ.field_75098_d) {
                    --is.field_77994_a;
                }
            }
        }
        return is;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack is, int pass) {
        EggData egg = ItemSpawnEggs.getEggData(is);
        return egg != null ? (pass == 0 ? egg.primaryColor : egg.secondaryColor) : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int a = 0; a < eggTypes.length; ++a) {
            list.add(new ItemStack(item, 1, a));
        }
    }

    static class EggData {
        final String entityName;
        final Class<? extends EntityLiving> entityClass;
        final int primaryColor;
        final int secondaryColor;

        EggData(String entityName, Class<? extends EntityLiving> entityClass, int[] rgbPrimaryColor, int[] rgbSecondaryColor) {
            this.entityName = entityName;
            this.entityClass = entityClass;
            this.primaryColor = rgbPrimaryColor[0] << 16 | rgbPrimaryColor[1] << 8 | rgbPrimaryColor[2];
            this.secondaryColor = rgbSecondaryColor[0] << 16 | rgbSecondaryColor[1] << 8 | rgbSecondaryColor[2];
        }

        public EntityLiving spawnMob(World world, double x, double y, double z, ItemStack is) {
            EntityLiving e = null;
            try {
                e = this.entityClass.getConstructor(World.class).newInstance(world);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodError | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                ex.printStackTrace();
                return null;
            }
            if (e == null) {
                return null;
            }
            e.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(field_77697_d.nextFloat() * 360.0f)), 0.0f);
            e.field_70759_as = e.field_70177_z;
            e.field_70761_aq = e.field_70177_z;
            e.func_110161_a((IEntityLivingData)null);
            world.func_72838_d((Entity)e);
            e.func_70642_aH();
            if (is.func_82837_s()) {
                e.func_94058_c(is.func_82833_r());
            }
            return e;
        }
    }
}

