/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

public class EssentiaOutputHatch
extends TileThaumcraft
implements IAspectContainer,
IEssentiaTransport {
    public static final int CAPACITY = 256;
    protected AspectList mAspects = new AspectList();

    public void clear() {
        this.mAspects.aspects.clear();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.mAspects.aspects.clear();
        NBTTagList tlist = nbttagcompound.func_150295_c("Aspects", 10);
        for (int j = 0; j < tlist.func_74745_c(); ++j) {
            NBTTagCompound rs = tlist.func_150305_b(j);
            if (!rs.func_74764_b("key")) continue;
            this.mAspects.add(Aspect.getAspect((String)rs.func_74779_i("key")), rs.func_74762_e("amount"));
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        Aspect[] aspectA = this.mAspects.getAspects();
        NBTTagList nbtTagList = new NBTTagList();
        for (Aspect aspect : aspectA) {
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.func_74778_a("key", aspect.getTag());
            f.func_74768_a("amount", this.mAspects.getAmount(aspect));
            nbtTagList.func_74742_a((NBTBase)f);
        }
        nbttagcompound.func_74782_a("Aspects", (NBTBase)nbtTagList);
    }

    private int remainingCapacity() {
        return 256 - this.getEssentiaAmount(null);
    }

    public AspectList getAspects() {
        return this.mAspects;
    }

    public void setAspects(AspectList aspectList) {
        for (Map.Entry entry : aspectList.aspects.entrySet()) {
            this.addEssentia((Aspect)entry.getKey(), (Integer)entry.getValue(), null);
        }
    }

    public boolean doesContainerAccept(Aspect var1) {
        return true;
    }

    public int addToContainer(Aspect aspect, int amount) {
        int remaining = 0;
        if (amount > this.remainingCapacity()) {
            remaining = amount - this.remainingCapacity();
            this.mAspects.add(aspect, this.remainingCapacity());
        } else {
            this.mAspects.add(aspect, amount);
        }
        this.func_70296_d();
        return remaining;
    }

    public boolean takeFromContainer(Aspect aspect, int amount) {
        if (this.mAspects != null && this.mAspects.getAmount(aspect) >= amount) {
            this.mAspects.remove(aspect, amount);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean takeFromContainer(AspectList aspects) {
        return true;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int amount) {
        return this.mAspects.getAmount(aspect) >= amount;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        for (Map.Entry entry : aspectList.aspects.entrySet()) {
            if (this.mAspects.getAmount((Aspect)entry.getKey()) >= (Integer)entry.getValue()) continue;
            return false;
        }
        return true;
    }

    public int containerContains(Aspect aspect) {
        return this.mAspects.getAmount(aspect);
    }

    public boolean isConnectable(ForgeDirection var1) {
        return true;
    }

    public boolean canInputFrom(ForgeDirection var1) {
        return false;
    }

    public boolean canOutputTo(ForgeDirection var1) {
        return true;
    }

    public void setSuction(Aspect var1, int var2) {
    }

    public Aspect getSuctionType(ForgeDirection var1) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection var1) {
        return 0;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection var3) {
        return this.takeFromContainer(aspect, amount) ? amount : 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection direction) {
        return amount - this.addToContainer(aspect, amount);
    }

    public Aspect getEssentiaType(ForgeDirection var1) {
        return this.mAspects.size() > 0 ? this.mAspects.getAspects()[0] : null;
    }

    public int getEssentiaAmount(ForgeDirection var1) {
        return this.mAspects.visSize();
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean renderExtendedTube() {
        return true;
    }
}

