/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.oxygen;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IOxygenNetwork;
import micdoodle8.mods.galacticraft.api.transmission.grid.PathfinderChecker;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkConnection;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.transmission.tile.IOxygenReceiver;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class OxygenNetwork
implements IOxygenNetwork {
    public Map<TileEntity, ForgeDirection> oxygenTiles;
    private final Set<ITransmitter> pipes = new HashSet<ITransmitter>();

    @Override
    public float produce(float totalOxygen, TileEntity ... ignoreTiles) {
        float totalOxygenRequest;
        float remainingUsableOxygen = totalOxygen;
        if (this.oxygenTiles == null || this.oxygenTiles.isEmpty()) {
            this.refreshOxygenTiles();
        }
        if (!this.oxygenTiles.isEmpty() && (totalOxygenRequest = this.getRequest(ignoreTiles)) > 0.0f) {
            List<TileEntity> ignoreTilesList = Arrays.asList(ignoreTiles);
            for (TileEntity tileEntity : new HashSet<TileEntity>(this.oxygenTiles.keySet())) {
                IOxygenReceiver oxygenTile;
                if (ignoreTilesList.contains(tileEntity) || !(tileEntity instanceof IOxygenReceiver) || !(oxygenTile = (IOxygenReceiver)tileEntity).shouldPullOxygen()) continue;
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    float oxygenToSend;
                    ITransmitter transmitter;
                    TileEntity tile;
                    if (!oxygenTile.canConnect(direction, NetworkType.OXYGEN) || !((tile = new BlockVec3(tileEntity).getTileEntityOnSide(tileEntity.func_145831_w(), direction)) instanceof ITransmitter) || !this.pipes.contains(transmitter = (ITransmitter)tile) || !((oxygenToSend = Math.min(remainingUsableOxygen, totalOxygen * (oxygenTile.getOxygenRequest(direction) / totalOxygenRequest))) > 0.0f)) continue;
                    remainingUsableOxygen -= oxygenTile.receiveOxygen(direction, oxygenToSend, true);
                }
            }
        }
        return remainingUsableOxygen;
    }

    @Override
    public float getRequest(TileEntity ... ignoreTiles) {
        ArrayList<Float> requests = new ArrayList<Float>();
        if (this.oxygenTiles == null || this.oxygenTiles.isEmpty()) {
            this.refreshOxygenTiles();
        }
        List<TileEntity> ignoreTilesList = Arrays.asList(ignoreTiles);
        for (TileEntity tileEntity : new HashSet<TileEntity>(this.oxygenTiles.keySet())) {
            if (ignoreTilesList.contains(tileEntity) || !(tileEntity instanceof IOxygenReceiver)) continue;
            IOxygenReceiver oxygenTile = (IOxygenReceiver)tileEntity;
            if (tileEntity.func_145837_r() || !oxygenTile.shouldPullOxygen() || tileEntity.func_145831_w().func_147438_o(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e) != tileEntity) continue;
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                ITransmitter transmitter;
                TileEntity tile;
                if (!oxygenTile.canConnect(direction, NetworkType.OXYGEN) || !((tile = new BlockVec3(tileEntity).getTileEntityOnSide(tileEntity.func_145831_w(), direction)) instanceof ITransmitter) || !this.pipes.contains(transmitter = (ITransmitter)tile)) continue;
                requests.add(Float.valueOf(((IOxygenReceiver)tileEntity).getOxygenRequest(direction)));
            }
        }
        float total = 0.0f;
        for (Float f : requests) {
            total += f.floatValue();
        }
        return total;
    }

    @Override
    public void refresh() {
        if (this.oxygenTiles != null) {
            this.oxygenTiles.clear();
        }
        try {
            Iterator<ITransmitter> it = this.pipes.iterator();
            while (it.hasNext()) {
                ITransmitter transmitter = it.next();
                if (transmitter == null) {
                    it.remove();
                    continue;
                }
                transmitter.onNetworkChanged();
                if (((TileEntity)transmitter).func_145837_r() || ((TileEntity)transmitter).func_145831_w() == null) {
                    it.remove();
                    continue;
                }
                transmitter.setNetwork(this);
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to refresh oxygen pipe network.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public void refreshOxygenTiles() {
        if (this.oxygenTiles == null) {
            this.oxygenTiles = new HashMap<TileEntity, ForgeDirection>();
        } else {
            this.oxygenTiles.clear();
        }
        try {
            Iterator<ITransmitter> it = this.pipes.iterator();
            while (it.hasNext()) {
                ITransmitter transmitter = it.next();
                if (transmitter == null || ((TileEntity)transmitter).func_145837_r() || ((TileEntity)transmitter).func_145831_w() == null) {
                    it.remove();
                    continue;
                }
                int i = 0;
                for (TileEntity acceptor : transmitter.getAdjacentConnections()) {
                    if (!(acceptor instanceof ITransmitter) && acceptor instanceof IConnector) {
                        this.oxygenTiles.put(acceptor, ForgeDirection.getOrientation((int)i));
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to refresh oxygen pipe network.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public Set<ITransmitter> getTransmitters() {
        return this.pipes;
    }

    @Override
    public IOxygenNetwork merge(IOxygenNetwork network) {
        if (network != null && network != this) {
            OxygenNetwork newNetwork = new OxygenNetwork();
            newNetwork.pipes.addAll(this.pipes);
            newNetwork.pipes.addAll(network.getTransmitters());
            newNetwork.refresh();
            return newNetwork;
        }
        return this;
    }

    @Override
    public void split(ITransmitter splitPoint) {
        if (splitPoint instanceof TileEntity) {
            TileEntity[] connectedBlocks;
            this.pipes.remove(splitPoint);
            for (TileEntity connectedBlockA : connectedBlocks = splitPoint.getAdjacentConnections()) {
                if (!(connectedBlockA instanceof INetworkConnection)) continue;
                for (TileEntity connectedBlockB : connectedBlocks) {
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof INetworkConnection)) continue;
                    PathfinderChecker finder = new PathfinderChecker(((TileEntity)splitPoint).func_145831_w(), (INetworkConnection)connectedBlockB, NetworkType.OXYGEN, splitPoint);
                    finder.init(new BlockVec3(connectedBlockA));
                    if (finder.results.size() > 0) {
                        for (BlockVec3 node : finder.closedSet) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).func_145831_w());
                            if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                            ((INetworkProvider)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    OxygenNetwork newNetwork = new OxygenNetwork();
                    for (BlockVec3 node : finder.closedSet) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).func_145831_w());
                        if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                        newNetwork.getTransmitters().add((ITransmitter)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    public String toString() {
        return "OxygenNetwork[" + this.hashCode() + "|Pipes:" + this.pipes.size() + "|Acceptors:" + (this.oxygenTiles == null ? 0 : this.oxygenTiles.size()) + "]";
    }
}

