/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.gthandler.accelerator;

import com.dreammaster.main.MainRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_WorldAccelerator
extends GT_MetaTileEntity_TieredMachineBlock {
    private static final ClassValue<String> simpleNameCache = new ClassValue<String>(){

        @Override
        protected String computeValue(Class<?> type) {
            return type.getSimpleName();
        }
    };
    private static final HashSet<Class<? extends TileEntity>> _mBlacklistedTiles = new HashSet();
    private int _mRadiusTierOverride = -1;
    private int _mSpeedTierOverride = -1;
    private byte mMode = 0;
    private static Textures.BlockIcons.CustomIcon _mGTIco_Norm_Idle;
    private static Textures.BlockIcons.CustomIcon _mGTIco_Norm_Active;
    private static Textures.BlockIcons.CustomIcon _mGTIco_TE_Idle;
    private static Textures.BlockIcons.CustomIcon _mGTIco_TE_Active;
    private static int[] mAccelerateStatic;
    private static final int AMPERAGE_NORMAL = 3;
    private static final int AMPERAGE_TE = 6;
    private static String[] mModeStr;

    public static boolean addTileToBlacklist(Class<? extends TileEntity> clazz) {
        return _mBlacklistedTiles.add(clazz);
    }

    public static boolean addTileToBlacklist(TileEntity tileEntity) {
        return _mBlacklistedTiles.add(tileEntity.getClass());
    }

    public static HashSet<Class<? extends TileEntity>> get_mBlacklistedTiles() {
        return _mBlacklistedTiles;
    }

    private int getRadiusTierOverride() {
        if (this._mRadiusTierOverride == -1) {
            this._mRadiusTierOverride = this.mTier;
        }
        return this._mRadiusTierOverride;
    }

    private int getSpeedTierOverride() {
        if (this._mSpeedTierOverride == -1) {
            this._mSpeedTierOverride = this.mTier;
        }
        return this._mSpeedTierOverride;
    }

    private int incSpeedTierOverride() {
        this._mSpeedTierOverride = this.getSpeedTierOverride() + 1;
        if (this._mSpeedTierOverride > this.mTier) {
            this._mSpeedTierOverride = 1;
        }
        return this._mSpeedTierOverride;
    }

    private int incRadiusTierOverride() {
        this._mRadiusTierOverride = this.getRadiusTierOverride() + 1;
        if (this._mRadiusTierOverride > this.mTier) {
            this._mRadiusTierOverride = 1;
        }
        return this._mRadiusTierOverride;
    }

    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        _mGTIco_Norm_Idle = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_ACCELERATOR");
        _mGTIco_Norm_Active = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_ACCELERATOR_ACTIVE");
        _mGTIco_TE_Idle = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_ACCELERATOR_TE");
        _mGTIco_TE_Active = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_ACCELERATOR_TE_ACTIVE");
    }

    @SideOnly(value=Side.CLIENT)
    public void onValueUpdate(byte aValue) {
        this.mMode = aValue;
    }

    public byte getUpdateData() {
        return this.mMode;
    }

    public GT_MetaTileEntity_WorldAccelerator(int pID, String pName, String pNameRegional, int pTier) {
        super(pID, pName, pNameRegional, pTier, 0, "", new ITexture[0]);
    }

    public String[] getDescription() {
        return new String[]{String.format("Accelerating things (Max Radius: %d | Max Speed Bonus: x%d)", this.mTier, mAccelerateStatic[this.mTier]), "Use a screwdriver to change mode, sneak to change Radius", "Use a wrench to change speed", "To accelerate TileEntities, this machine has to be adjacent to it", String.format("Normal mode consumes up to %s amperage, depending on radius", 3), String.format("TE mode consumes %s amperage", 6)};
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        ArrayList<String> tInfoDisplay = new ArrayList<String>();
        tInfoDisplay.add(String.format("Accelerator running in %s mode", mModeStr[this.mMode]));
        tInfoDisplay.add(String.format("Speed setting: [%d / %d]", mAccelerateStatic[this.getSpeedTierOverride()], mAccelerateStatic[this.mTier]));
        tInfoDisplay.add(String.format("Consuming %d EU/t", this.getEnergyDemand(this.getSpeedTierOverride(), this.getRadiusTierOverride(), this.mMode == 1)));
        if (this.mMode == 0) {
            tInfoDisplay.add(String.format("Radius setting: [%d / %d]", this.getRadiusTierOverride(), this.mTier));
        }
        return tInfoDisplay.toArray(new String[0]);
    }

    public GT_MetaTileEntity_WorldAccelerator(String pName, int pTier, int pInvSlotCount, String pDescription, ITexture[][][] pTextures) {
        super(pName, pTier, pInvSlotCount, pDescription, pTextures);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity pTileEntity) {
        return new GT_MetaTileEntity_WorldAccelerator(this.mName, this.mTier, this.mInventory.length, this.mDescription, this.mTextures);
    }

    public ITexture[][][] getTextureSet(ITexture[] pTextures) {
        return null;
    }

    public ITexture[] getTexture(IGregTechTileEntity pBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean pActive, boolean pRedstone) {
        if (this.mMode == 0) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], side.offsetY != 0 ? null : (pActive ? new GT_RenderedTexture((IIconContainer)_mGTIco_Norm_Active) : new GT_RenderedTexture((IIconContainer)_mGTIco_Norm_Idle))};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], side.offsetY != 0 ? null : (pActive ? new GT_RenderedTexture((IIconContainer)_mGTIco_TE_Active) : new GT_RenderedTexture((IIconContainer)_mGTIco_TE_Idle))};
    }

    public boolean allowPullStack(IGregTechTileEntity pBaseMetaTileEntity, int pIndex, ForgeDirection side, ItemStack pStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity pBaseMetaTileEntity, int pIndex, ForgeDirection side, ItemStack pStack) {
        return false;
    }

    public void saveNBTData(NBTTagCompound pNBT) {
        pNBT.func_74774_a("mAccelMode", this.mMode);
        pNBT.func_74774_a("mSpeed", (byte)this.getSpeedTierOverride());
        pNBT.func_74774_a("mRadius", (byte)this.getRadiusTierOverride());
    }

    public long getEnergyDemand(int pSpeedTier, int pRangeTier, boolean pIsAcceleratingTEs) {
        if (pIsAcceleratingTEs) {
            return GT_Values.V[pSpeedTier] * 6L;
        }
        float multiplier = 100.0f / (float)this.mTier * (float)pRangeTier / 100.0f;
        long demand = GT_Values.V[pSpeedTier] * 3L;
        float tDemand = (float)demand * multiplier;
        return (int)tDemand;
    }

    public void loadNBTData(NBTTagCompound pNBT) {
        this.mMode = pNBT.func_74771_c("mAccelMode");
        if (pNBT.func_74764_b("mSpeed")) {
            this._mSpeedTierOverride = pNBT.func_74771_c("mSpeed");
        }
        if (pNBT.func_74764_b("mRadius")) {
            this._mRadiusTierOverride = pNBT.func_74771_c("mRadius");
        }
    }

    public boolean isAccessAllowed(EntityPlayer pPlayer) {
        return true;
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return true;
    }

    public boolean isTeleporterCompatible() {
        return false;
    }

    public long getMinimumStoredEU() {
        return 512L;
    }

    public long maxEUStore() {
        return 512L + GT_Values.V[this.mTier] * 50L;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public long maxAmperesIn() {
        return 8L;
    }

    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer pPlayer, float aX, float aY, float aZ) {
        this.incSpeedTierOverride();
        this.func_70296_d();
        PlayerChatHelper.SendInfo((EntityPlayer)pPlayer, (String)String.format("Machine acceleration changed to x%d", mAccelerateStatic[this.getSpeedTierOverride()]));
        return true;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer pPlayer, float pX, float pY, float pZ) {
        if (pPlayer.func_70093_af()) {
            if (this.mMode == 0) {
                this.incRadiusTierOverride();
                this.func_70296_d();
                PlayerChatHelper.SendInfo((EntityPlayer)pPlayer, (String)String.format("Machine radius changed to %d Blocks", this.getRadiusTierOverride()));
            } else {
                PlayerChatHelper.SendError((EntityPlayer)pPlayer, (String)String.format("Can't change radius; Machine is in TileEntity Mode!", new Object[0]));
            }
        } else {
            this.mMode = (byte)(this.mMode == 0 ? 1 : 0);
            this.func_70296_d();
            PlayerChatHelper.SendInfo((EntityPlayer)pPlayer, (String)String.format("Switched mode to: %s", mModeStr[this.mMode]));
        }
    }

    public void onPostTick(IGregTechTileEntity pBaseMetaTileEntity, long pTick) {
        try {
            if (!pBaseMetaTileEntity.isServerSide()) {
                return;
            }
            long tEnergyDemand = this.getEnergyDemand(this.getSpeedTierOverride(), this.getRadiusTierOverride(), this.mMode == 1);
            if (pBaseMetaTileEntity.getStoredEU() < tEnergyDemand || !pBaseMetaTileEntity.isAllowedToWork()) {
                if (pBaseMetaTileEntity.isActive()) {
                    pBaseMetaTileEntity.setActive(false);
                }
            } else if (pBaseMetaTileEntity.decreaseStoredEnergyUnits(tEnergyDemand, false)) {
                World tWorld = pBaseMetaTileEntity.getWorld();
                if (this.mMode == 0) {
                    if (pTick % 20L == 0L) {
                        this.doAccelerateNormalBlocks(pBaseMetaTileEntity, tWorld);
                    }
                } else {
                    this.doAccelerateTileEntities(pBaseMetaTileEntity, tWorld);
                }
            } else if (pBaseMetaTileEntity.isActive()) {
                pBaseMetaTileEntity.setActive(false);
            }
        }
        catch (Exception e) {
            MainRegistry.Logger.error("GT_MetaTileEntity_WorldAccelerator.onPostTick.crash", (Object)e.getMessage());
        }
    }

    private void doAccelerateTileEntities(IGregTechTileEntity pBaseMetaTileEntity, World pWorld) {
        try {
            if (!pBaseMetaTileEntity.isActive()) {
                this.getBaseMetaTileEntity().setActive(true);
            }
            block2: for (ForgeDirection tDir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tTile = pBaseMetaTileEntity.getTileEntityAtSide(tDir);
                if (this.isTEBlackListed(tTile)) continue;
                long tMaxTime = System.nanoTime() + 1000000L;
                for (int j = 0; j < mAccelerateStatic[this.getSpeedTierOverride()]; ++j) {
                    tTile.func_145845_h();
                    if (System.nanoTime() > tMaxTime) continue block2;
                }
            }
        }
        catch (Exception e) {
            MainRegistry.Logger.error("GT_MetaTileEntity_WorldAccelerator.doAccelerateTileEntities.crash", (Object)e.getMessage());
        }
    }

    private boolean isTEBlackListed(TileEntity pTile) {
        if (pTile == null) {
            return true;
        }
        if (!pTile.canUpdate()) {
            return true;
        }
        if (pTile.func_145837_r()) {
            return true;
        }
        String tSimpleClassName = simpleNameCache.get(pTile.getClass());
        String tCanonicalName = pTile.getClass().getCanonicalName().toLowerCase();
        if (tSimpleClassName.contains("conduit") || tSimpleClassName.contains("wire") || tSimpleClassName.contains("cable")) {
            return true;
        }
        if (tCanonicalName.contains("appeng") || tCanonicalName.contains(Mods.GregTech.ID)) {
            return true;
        }
        if (tSimpleClassName.contains("solar") || tCanonicalName.contains("solar")) {
            return true;
        }
        for (String tS : MainRegistry.CoreConfig.BlacklistedTileEntiyClassNames) {
            if (!tCanonicalName.equalsIgnoreCase(tS)) continue;
            return true;
        }
        return _mBlacklistedTiles.stream().map(Class::getCanonicalName).map(String::toLowerCase).anyMatch(tCanonicalName::equalsIgnoreCase);
    }

    private void doAccelerateNormalBlocks(IGregTechTileEntity pBaseMetaTileEntity, World pWorld) {
        if (!pBaseMetaTileEntity.isActive()) {
            this.getBaseMetaTileEntity().setActive(true);
        }
        Random rnd = new Random();
        int tX = pBaseMetaTileEntity.getXCoord();
        short tY = pBaseMetaTileEntity.getYCoord();
        int tZ = pBaseMetaTileEntity.getZCoord();
        int tX1 = tX - this.getRadiusTierOverride();
        int tX2 = tX + this.getRadiusTierOverride();
        int tY1 = Math.max(tY - this.getRadiusTierOverride(), 0);
        int tY2 = Math.min(tY + this.getRadiusTierOverride(), 255);
        int tZ1 = tZ - this.getRadiusTierOverride();
        int tZ2 = tZ + this.getRadiusTierOverride();
        for (int xi = tX1; xi <= tX2; ++xi) {
            for (int yi = tY1; yi <= tY2; ++yi) {
                for (int zi = tZ1; zi <= tZ2; ++zi) {
                    this.tryTickBlock(pWorld, xi, yi, zi, rnd);
                }
            }
        }
    }

    private void tryTickBlock(World pWorld, int pX, int pY, int pZ, Random pRnd) {
        try {
            for (int j = 0; j < this.getSpeedTierOverride(); ++j) {
                Block tBlock = pWorld.func_147439_a(pX, pY, pZ);
                if (!tBlock.func_149653_t()) continue;
                tBlock.func_149674_a(pWorld, pX, pY, pZ, pRnd);
            }
        }
        catch (Exception e) {
            MainRegistry.Logger.error("GT_MetaTileEntity_WorldAccelerator.tryTickBlock.crash", (Object)e.getMessage());
        }
    }

    static {
        mAccelerateStatic = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 512, 512, 512, 512, 512, 512};
        mModeStr = new String[]{"Blocks", "TileEntities"};
    }
}

