/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.thaumcraft.util;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.thaumcraft.HANDLER_Thaumcraft;
import gtPlusPlus.xmod.thaumcraft.aspect.GTPP_AspectStack;
import gtPlusPlus.xmod.thaumcraft.objects.wrapper.aspect.TC_AspectList_Wrapper;
import gtPlusPlus.xmod.thaumcraft.objects.wrapper.aspect.TC_Aspect_Wrapper;
import gtPlusPlus.xmod.thaumcraft.objects.wrapper.recipe.TC_CrucibleRecipe_Wrapper;
import gtPlusPlus.xmod.thaumcraft.objects.wrapper.recipe.TC_IArcaneRecipe_Wrapper;
import gtPlusPlus.xmod.thaumcraft.objects.wrapper.recipe.TC_InfusionEnchantmentRecipe_Wrapper;
import gtPlusPlus.xmod.thaumcraft.objects.wrapper.recipe.TC_InfusionRecipe_Wrapper;
import gtPlusPlus.xmod.thaumcraft.objects.wrapper.research.TC_ResearchCategories_Wrapper;
import gtPlusPlus.xmod.thaumcraft.objects.wrapper.research.TC_ResearchCategoryList_Wrapper;
import gtPlusPlus.xmod.thaumcraft.objects.wrapper.research.TC_ResearchItem_Wrapper;
import gtPlusPlus.xmod.thaumcraft.objects.wrapper.research.TC_ResearchNoteData_Wrapper;
import gtPlusPlus.xmod.thaumcraft.objects.wrapper.research.TC_ResearchPage_Wrapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class ThaumcraftUtils {
    private static Class<?> mClass_Aspect;
    private static Field mField_Aspects;
    private static final Class<?> mClass_ThaumcraftApi;
    private static final Class<?> mClass_ThaumcraftApiHelper;
    private static final Class<?> mClass_AspectList;
    private static final Class<?> mClass_ResearchManager;
    private static final Method mMethod_registerObjectTag1;
    private static final Method mMethod_registerObjectTag2;
    private static final Method mMethod_registerComplexObjectTag;
    private static final Method mMethod_addInfusionCraftingRecipe;
    private static final Method mMethod_addCrucibleRecipe;
    private static final Method mMethod_getObjectAspects;
    private static final Method mMethod_updateData;
    private static final Method mMethod_getData;
    private static final Field mField_PortholeBlacklist;

    public static boolean addAspectToItem(ItemStack item, TC_Aspect_Wrapper aspect, int amount) {
        return ThaumcraftUtils.addAspectToItem(item, new TC_Aspect_Wrapper[]{aspect}, new Integer[]{amount});
    }

    public static boolean addAspectToItem(ItemStack item, TC_Aspect_Wrapper[] aspect, Integer[] amounts) {
        GTPP_AspectStack[] aspects = new GTPP_AspectStack[aspect.length];
        for (int g = 0; g < aspect.length; ++g) {
            if (amounts[g] != null && amounts[g] <= 0) continue;
        }
        Pair<ItemStack, GTPP_AspectStack[]> k = new Pair<ItemStack, GTPP_AspectStack[]>(item, aspects);
        int mSizeA = HANDLER_Thaumcraft.sItemsToGetAspects.size();
        HANDLER_Thaumcraft.sItemsToGetAspects.put(k);
        if (HANDLER_Thaumcraft.sItemsToGetAspects.size() > mSizeA) {
            Logger.MATERIALS("[Aspect] Successfully queued an ItemStack for Aspect addition.");
            return true;
        }
        Logger.MATERIALS("[Aspect] Failed to queue an ItemStack for Aspect addition.");
        return false;
    }

    public static TC_Aspect_Wrapper getAspect(String name) {
        return TC_Aspect_Wrapper.getAspect(name);
    }

    public static TC_Aspects getEnumAspect(String name) {
        TC_Aspect_Wrapper r = ThaumcraftUtils.getAspect(name);
        return r.mGtEnumField;
    }

    public static Object addResearch(String aResearch, String aName, String aText, String[] aParentResearches, String aCategory, ItemStack aIcon, int aComplexity, int aType, int aX, int aY, List<GTPP_AspectStack> aAspects, ItemStack[] aResearchTriggers, Object[] aPages) {
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.researches, aResearch, true)) {
            return null;
        }
        TC_ResearchCategoryList_Wrapper tCategory = TC_ResearchCategories_Wrapper.getResearchList(aCategory);
        if (tCategory == null) {
            return null;
        }
        for (TC_ResearchItem_Wrapper tResearch : tCategory.research.values()) {
            if (tResearch.displayColumn != aX || tResearch.displayRow != aY) continue;
            aX += aX > 0 ? 5 : -5;
            aY += aY > 0 ? 5 : -5;
        }
        TC_ResearchItem_Wrapper rResearch = new TC_ResearchItem_Wrapper(aResearch, aCategory, ThaumcraftUtils.getAspectList_Ex(aAspects), aX, aY, aComplexity, aIcon);
        ArrayList<TC_ResearchPage_Wrapper> tPages = new ArrayList<TC_ResearchPage_Wrapper>(aPages.length);
        GT_LanguageManager.addStringLocalization((String)("tc.research_name." + aResearch), (String)aName);
        GT_LanguageManager.addStringLocalization((String)("tc.research_text." + aResearch), (String)("[GT++] " + aText));
        for (Object tPage : aPages) {
            if (tPage instanceof String) {
                tPages.add(new TC_ResearchPage_Wrapper((String)tPage));
                continue;
            }
            if (tPage instanceof IRecipe) {
                tPages.add(new TC_ResearchPage_Wrapper((IRecipe)tPage));
                continue;
            }
            if (tPage instanceof TC_IArcaneRecipe_Wrapper) {
                tPages.add(new TC_ResearchPage_Wrapper((TC_IArcaneRecipe_Wrapper)tPage));
                continue;
            }
            if (tPage instanceof TC_CrucibleRecipe_Wrapper) {
                tPages.add(new TC_ResearchPage_Wrapper((TC_CrucibleRecipe_Wrapper)tPage));
                continue;
            }
            if (tPage instanceof TC_InfusionRecipe_Wrapper) {
                tPages.add(new TC_ResearchPage_Wrapper((TC_InfusionRecipe_Wrapper)tPage));
                continue;
            }
            if (!(tPage instanceof TC_InfusionEnchantmentRecipe_Wrapper)) continue;
            tPages.add(new TC_ResearchPage_Wrapper((TC_InfusionEnchantmentRecipe_Wrapper)tPage));
        }
        if ((aType & 0x40) != 0) {
            rResearch.setAutoUnlock();
        }
        if ((aType & 1) != 0) {
            rResearch.setSecondary();
        }
        if ((aType & 0x20) != 0) {
            rResearch.setSpecial();
        }
        if ((aType & 8) != 0) {
            rResearch.setVirtual();
        }
        if ((aType & 4) != 0) {
            rResearch.setHidden();
        }
        if ((aType & 0x10) != 0) {
            rResearch.setRound();
        }
        if ((aType & 2) != 0) {
            rResearch.setStub();
        }
        if (aParentResearches != null) {
            ArrayList<String> tParentResearches = new ArrayList<String>();
            for (String tParent : aParentResearches) {
                if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.researches, aResearch, true)) continue;
                tParentResearches.add(tParent);
            }
            if (tParentResearches.size() > 0) {
                rResearch.setParents(tParentResearches.toArray(new String[tParentResearches.size()]));
                rResearch.setConcealed();
            }
        }
        if (aResearchTriggers != null) {
            rResearch.setItemTriggers(aResearchTriggers);
            rResearch.setHidden();
        }
        Object[] aVarArgs = tPages.toArray(new TC_ResearchPage_Wrapper[tPages.size()]);
        rResearch.setPages(aVarArgs);
        return rResearch.registerResearchItem();
    }

    public static Object addCrucibleRecipe(String aResearch, Object aInput, ItemStack aOutput, List<GTPP_AspectStack> aAspects) {
        if (GT_Utility.isStringInvalid((Object)aResearch) || aInput == null || aOutput == null || aAspects == null || aAspects.isEmpty()) {
            return null;
        }
        return ThaumcraftUtils.addCrucibleRecipe(aResearch, GT_Utility.copy((Object[])new Object[]{aOutput}), aInput instanceof ItemStack || aInput instanceof ArrayList ? aInput : aInput.toString(), ThaumcraftUtils.getAspectList_Ex(aAspects));
    }

    public static Object addInfusionRecipe(String aResearch, ItemStack aMainInput, ItemStack[] aSideInputs, ItemStack aOutput, int aInstability, List<GTPP_AspectStack> aAspects) {
        if (GT_Utility.isStringInvalid((Object)aResearch) || aMainInput == null || aSideInputs == null || aOutput == null || aAspects == null || aAspects.isEmpty()) {
            return null;
        }
        return ThaumcraftUtils.addInfusionCraftingRecipe(aResearch, GT_Utility.copy((Object[])new Object[]{aOutput}), aInstability, ThaumcraftUtils.getAspectList_Ex(aAspects), aMainInput, aSideInputs);
    }

    public static boolean registerThaumcraftAspectsToItem(ItemStack aExampleStack, List<GTPP_AspectStack> aAspects, String aOreDict) {
        if (aAspects.isEmpty()) {
            return false;
        }
        ThaumcraftUtils.registerObjectTag(aOreDict, ThaumcraftUtils.getAspectList_Ex(aAspects));
        return true;
    }

    public static boolean registerThaumcraftAspectsToItem(ItemStack aStack, List<GTPP_AspectStack> aAspects, boolean aAdditive) {
        try {
            if (aAspects.isEmpty()) {
                return false;
            }
            TC_AspectList_Wrapper h = ThaumcraftUtils.getAspectList_Ex(aAspects);
            if (aAdditive && h != null && h.size() > 0) {
                ThaumcraftUtils.registerComplexObjectTag(aStack, ThaumcraftUtils.getAspectList_Ex(aAspects));
                return true;
            }
            Logger.MATERIALS("[Aspect] Failed adding aspects to " + aStack.func_82833_r() + ".");
            TC_AspectList_Wrapper tAlreadyRegisteredAspects = ThaumcraftUtils.getObjectAspects(aStack);
            if (tAlreadyRegisteredAspects == null || tAlreadyRegisteredAspects.size() <= 0) {
                ThaumcraftUtils.registerObjectTag(aStack, ThaumcraftUtils.getAspectList_Ex(aAspects));
            }
            return true;
        }
        catch (Throwable t) {
            Logger.MATERIALS("[Aspect] Failed adding aspects to " + aStack.func_82833_r() + ".");
            t.printStackTrace();
            return false;
        }
    }

    public static void registerObjectTag(ItemStack aStack, TC_AspectList_Wrapper aAspectList) {
        try {
            mMethod_registerObjectTag1.invoke(null, aStack, aAspectList.getVanillaAspectList());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void registerObjectTag(String aOreDict, TC_AspectList_Wrapper aAspectList) {
        try {
            mMethod_registerObjectTag2.invoke(null, aOreDict, aAspectList.getVanillaAspectList());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void registerComplexObjectTag(ItemStack aStack, TC_AspectList_Wrapper aAspectList) {
        try {
            mMethod_registerComplexObjectTag.invoke(null, aStack, aAspectList.getVanillaAspectList());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static TC_AspectList_Wrapper getObjectAspects(ItemStack aStack) {
        try {
            return new TC_AspectList_Wrapper(mMethod_getObjectAspects.invoke(null, aStack));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object addCrucibleRecipe(String aResearch, ItemStack copy, Object aOutput, TC_AspectList_Wrapper aAspectList) {
        try {
            return mMethod_addCrucibleRecipe.invoke(null, aResearch, copy, aOutput, aAspectList);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object addInfusionCraftingRecipe(String aResearch, Object copy, int aInstability, TC_AspectList_Wrapper aAspectList, ItemStack aMainInput, ItemStack[] aSideInputs) {
        try {
            return mMethod_addInfusionCraftingRecipe.invoke(null, aResearch, copy, aInstability, aAspectList, aMainInput, aSideInputs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean registerPortholeBlacklistedBlock(Block aBlock) {
        try {
            ((ArrayList)mField_PortholeBlacklist.get(null)).add(aBlock);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getTagFromAspectObject(Object aAspect) {
        try {
            if (mClass_Aspect == null || mField_Aspects == null) {
                return null;
            }
            String aTafB = (String)mField_Aspects.get(aAspect);
            if (aTafB == null) {
                return null;
            }
            String aTag = aTafB.toLowerCase();
            return aTag;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return "error";
        }
    }

    public static void updateResearchNote(ItemStack a, TC_ResearchNoteData_Wrapper b) {
        try {
            mMethod_updateData.invoke((Object)a, b.getResearchNoteData());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Object getResearchNoteData(ItemStack a) {
        try {
            return mMethod_getData.invoke((Object)a, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isItemResearchNotes(ItemStack aStack) {
        return aStack != null && aStack.func_77973_b() == HANDLER_Thaumcraft.mResearchNotes && HANDLER_Thaumcraft.mResearchNotes.getClass().isInstance(aStack.func_77973_b());
    }

    public static boolean isItemStackValidResearchNotes(ItemStack aStack) {
        return ThaumcraftUtils.isItemResearchNotes(aStack) && aStack.func_77960_j() < 64;
    }

    public static TC_ResearchNoteData_Wrapper gatherResults(ItemStack note) {
        TC_ResearchNoteData_Wrapper research = null;
        if (ThaumcraftUtils.isItemResearchNotes(note)) {
            research = new TC_ResearchNoteData_Wrapper(ThaumcraftUtils.getResearchNoteData(note));
        }
        return research;
    }

    public static void completeResearchNote(World aWorld, ItemStack aStack) {
        if (!aWorld.field_72995_K && ThaumcraftUtils.isItemResearchNotes(aStack)) {
            aStack.func_77964_b(64);
        }
    }

    public static final synchronized TC_AspectList_Wrapper getAspectList_Ex(List<GTPP_AspectStack> aAspects) {
        TC_AspectList_Wrapper rAspects = new TC_AspectList_Wrapper();
        for (GTPP_AspectStack tAspect : aAspects) {
            rAspects.add(tAspect.mAspect, tAspect.mAmount);
        }
        return rAspects;
    }

    public static void addResearch(TC_ResearchItem_Wrapper tc_ResearchItem_Wrapper) {
    }

    static {
        Field aTagF;
        mClass_Aspect = ReflectionUtils.getClass("thaumcraft.api.aspects.Aspect");
        if (mClass_Aspect != null && (aTagF = ReflectionUtils.getField(mClass_Aspect, "tag")) != null) {
            mField_Aspects = aTagF;
        }
        mClass_ThaumcraftApi = ReflectionUtils.getClass("thaumcraft.api.ThaumcraftApi");
        mClass_ThaumcraftApiHelper = ReflectionUtils.getClass("thaumcraft.api.ThaumcraftApiHelper");
        mClass_AspectList = ReflectionUtils.getClass("thaumcraft.api.aspects.AspectList");
        mClass_ResearchManager = ReflectionUtils.getClass("thaumcraft.common.lib.research.ResearchManager");
        mMethod_registerObjectTag1 = ReflectionUtils.getMethod(mClass_ThaumcraftApi, "registerObjectTag", ItemStack.class, mClass_AspectList);
        mMethod_registerObjectTag2 = ReflectionUtils.getMethod(mClass_ThaumcraftApi, "registerObjectTag", String.class, mClass_AspectList);
        mMethod_registerComplexObjectTag = ReflectionUtils.getMethod(mClass_ThaumcraftApi, "registerComplexObjectTag", ItemStack.class, mClass_AspectList);
        mMethod_addInfusionCraftingRecipe = ReflectionUtils.getMethod(mClass_ThaumcraftApi, "addInfusionCraftingRecipe", String.class, Object.class, Integer.TYPE, mClass_AspectList, ItemStack.class, ItemStack[].class);
        mMethod_addCrucibleRecipe = ReflectionUtils.getMethod(mClass_ThaumcraftApi, "addCrucibleRecipe", String.class, ItemStack.class, Object.class, mClass_AspectList);
        mMethod_getObjectAspects = ReflectionUtils.getMethod(mClass_ThaumcraftApiHelper, "getObjectAspects", ItemStack.class);
        mMethod_updateData = ReflectionUtils.getMethod(mClass_ResearchManager, "updateData", ItemStack.class, ReflectionUtils.getClass("thaumcraft.common.lib.research.ResearchNoteData"));
        mMethod_getData = ReflectionUtils.getMethod(mClass_ResearchManager, "getData", ItemStack.class);
        mField_PortholeBlacklist = ReflectionUtils.getField(mClass_ThaumcraftApi, "portableHoleBlackList");
    }
}

