/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.generators;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public abstract class GregtechMetaSolarGenerator
extends GT_MetaTileEntity_BasicTank {
    public int mEfficiency;
    public int mProcessingEnergy = 0;
    public int mSolarCharge = 20;
    public int mLossTimer = 0;
    public static int sEnergyPerTick = 16;

    public GregtechMetaSolarGenerator(int aID, String aName, String aNameRegional, int aTier, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, 3, aDescription, aTextures);
    }

    public GregtechMetaSolarGenerator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][aColorIndex + 1];
    }

    public String[] getDescription() {
        return (String[])ArrayUtils.add((Object[])this.mDescriptionArray, (Object)("Efficiency: " + this.getEfficiency() + "%"));
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return this.getFront(aColor);
    }

    public ITexture[] getBackActive(byte aColor) {
        return this.getBack(aColor);
    }

    public ITexture[] getBottomActive(byte aColor) {
        return this.getBottom(aColor);
    }

    public ITexture[] getTopActive(byte aColor) {
        return this.getTop(aColor);
    }

    public ITexture[] getSidesActive(byte aColor) {
        return this.getSides(aColor);
    }

    public boolean isFacingValid(ForgeDirection side) {
        return side.offsetY == 0;
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isValidSlot(int aIndex) {
        return aIndex < 2;
    }

    public boolean isEnetOutput() {
        return true;
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public long maxEUOutput() {
        return this.getBaseMetaTileEntity().isAllowedToWork() ? GT_Values.V[this.mTier] : 0L;
    }

    public long maxEUStore() {
        return Math.max(this.getEUVar(), GT_Values.V[this.mTier] * 40L + this.getMinimumStoredEU());
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && aTick > 20L && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() + aBaseMetaTileEntity.getEUCapacity()) {
            if (this.mSolarCharge <= 20) {
                this.mSolarCharge = 20;
                this.mLossTimer = 0;
            }
            if (++this.mLossTimer > 45) {
                --this.mSolarCharge;
                this.mLossTimer = 0;
            }
            if (aTick % 25L == 0L && this.mSolarCharge > 100 && this.mProcessingEnergy > 0 && aBaseMetaTileEntity.isAllowedToWork() && aTick % 256L == 0L && !aBaseMetaTileEntity.getWorld().func_72911_I() && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() * 20L + this.getMinimumStoredEU()) {
                this.getBaseMetaTileEntity().increaseStoredEnergyUnits((long)(sEnergyPerTick * this.getEfficiency() / 10), false);
            }
            if (this.mSolarCharge < 500 && this.mProcessingEnergy > 0 && aTick % 12L == 0L) {
                --this.mProcessingEnergy;
                ++this.mSolarCharge;
            }
            if (this.mProcessingEnergy <= 0 && aBaseMetaTileEntity.isAllowedToWork() && aTick % 256L == 0L && !aBaseMetaTileEntity.getWorld().func_72911_I()) {
                boolean bRain;
                boolean bl = bRain = aBaseMetaTileEntity.getWorld().func_72896_J() && aBaseMetaTileEntity.getBiome().field_76751_G > 0.0f;
                this.mProcessingEnergy += bRain && aBaseMetaTileEntity.getWorld().field_73008_k >= 4 || !aBaseMetaTileEntity.getSkyAtSide(ForgeDirection.UP) ? 0 : (!bRain && aBaseMetaTileEntity.getWorld().func_72935_r() ? 8 : 1);
            }
            if (aBaseMetaTileEntity.isServerSide()) {
                aBaseMetaTileEntity.setActive(aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() >= this.maxEUOutput() + this.getMinimumStoredEU());
            }
        }
    }

    public abstract int getEfficiency();

    public boolean doesFillContainers() {
        return false;
    }

    public boolean doesEmptyContainers() {
        return false;
    }

    public boolean canTankBeFilled() {
        return false;
    }

    public boolean canTankBeEmptied() {
        return false;
    }

    public boolean displaysItemStack() {
        return false;
    }

    public boolean displaysStackSize() {
        return false;
    }
}

