/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.InventoryUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_Energy_RTG
extends GT_MetaTileEntity_Hatch_Energy {
    private static final HashMap<String, ItemStack> mFuelInstanceMap = new HashMap();
    private static final HashMap<String, Long> mFuelValueMap = new HashMap();
    private static final HashMap<String, Integer> mFuelTypeMap = new HashMap();
    private static final HashMap<Integer, String> mFuelTypeMapReverse = new HashMap();

    public GT_MetaTileEntity_Hatch_Energy_RTG(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, new String[]{"Energy Injector for Multiblocks", "Accepts up to 2 Amps"}, new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_Energy_RTG(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public String[] getDescription() {
        String[] S = super.getDescription();
        String[] desc = new String[S.length + 1];
        System.arraycopy(S, 0, desc, 0, S.length);
        desc[S.length] = CORE.GT_Tooltip.get();
        return desc;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TexturesGtBlock.getTextureFromIcon(TexturesGtBlock.Overlay_Hatch_RTG_On, new short[]{220, 220, 220, 0})};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TexturesGtBlock.getTextureFromIcon(TexturesGtBlock.Overlay_Hatch_RTG_Off, new short[]{220, 220, 220, 0})};
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isEnetInput() {
        return false;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public long maxEUStore() {
        return 2216406038640L;
    }

    public long maxAmperesIn() {
        return 0L;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Energy_RTG(this.mName, this.mTier, 9, this.mDescriptionArray, this.mTextures);
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return true;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public static boolean registerPelletForHatch(ItemStack aStack, long aFuelValue) {
        if (!ItemUtils.checkForInvalidItems(aStack)) {
            return false;
        }
        ItemStack aTemp = aStack.func_77946_l();
        aTemp.field_77994_a = 1;
        Dat aDat = new Dat(aTemp);
        String aKey = aDat.mUniqueDataTag;
        mFuelInstanceMap.put(aKey, aTemp);
        mFuelValueMap.put(aKey, aFuelValue);
        mFuelTypeMap.put(aKey, aDat.getKey());
        mFuelTypeMapReverse.put(aDat.getKey(), aKey);
        Logger.INFO("RTG Hatch: Registered Fuel Pellet: " + ItemUtils.getItemName(aTemp) + ", Fuel Value: " + aFuelValue + ", Key: " + aKey + ", Key2: " + aDat.getKey());
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.hasInventoryBeenModified()) {
            InventoryUtils.sortInventoryItems((MetaTileEntity)this);
        }
        if (aTimer % 100L == 0L && aBaseMetaTileEntity.isServerSide() && GT_MetaTileEntity_Hatch_Energy_RTG.hasPellet(this)) {
            Logger.INFO("Has Pellet");
            GT_MetaTileEntity_Hatch_Energy_RTG.tryConsumePellet(this);
        }
    }

    private static void tryConsumePellet(GT_MetaTileEntity_Hatch_Energy_RTG aTile) {
        ItemStack aPellet = GT_MetaTileEntity_Hatch_Energy_RTG.getPelletToConsume(aTile);
        if (aPellet != null) {
            Logger.INFO("Found Pellet");
            long aFuel = GT_MetaTileEntity_Hatch_Energy_RTG.getFuelValueOfPellet(aPellet);
            if (aFuel > 0L) {
                Logger.INFO("Has Fuel Value: " + aFuel);
                if (GT_MetaTileEntity_Hatch_Energy_RTG.hasSpaceForEnergy(aTile, aFuel)) {
                    Logger.INFO("Can buffer");
                    aPellet.field_77994_a = 0;
                    Logger.INFO("Stack set to 0");
                    aPellet = null;
                    Logger.INFO("null stack");
                    GT_MetaTileEntity_Hatch_Energy_RTG.addEnergyToInternalStorage(aTile, aFuel);
                    Logger.INFO("Consumed");
                }
            }
        }
        aTile.updateSlots();
        Logger.INFO("updating slots");
    }

    private static void addEnergyToInternalStorage(GT_MetaTileEntity_Hatch_Energy_RTG aTile, long aFuel) {
        aTile.getBaseMetaTileEntity().increaseStoredEnergyUnits(aFuel, true);
    }

    public static boolean hasSpaceForEnergy(GT_MetaTileEntity_Hatch_Energy_RTG aTile, long aAmount) {
        long aCurrent;
        long aMax = aTile.maxEUStore();
        return aMax - (aCurrent = aTile.getEUVar()) >= aAmount;
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
        InventoryUtils.sortInventoryItems((MetaTileEntity)this);
    }

    public static boolean hasPellet(GT_MetaTileEntity_Hatch_Energy_RTG aTile) {
        for (ItemStack o : aTile.mInventory) {
            if (o == null) continue;
            for (ItemStack i : mFuelInstanceMap.values()) {
                if (!GT_Utility.areStacksEqual((ItemStack)o, (ItemStack)i)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPelletType(ItemStack o) {
        if (o == null) {
            return "error";
        }
        Dat aDat = new Dat(o);
        return mFuelTypeMapReverse.get(aDat.getKey());
    }

    public static long getFuelValueOfPellet(ItemStack aPellet) {
        String aType = GT_MetaTileEntity_Hatch_Energy_RTG.getPelletType(aPellet);
        if (mFuelValueMap.containsKey(aType)) {
            return mFuelValueMap.get(aType);
        }
        return 0L;
    }

    public static ItemStack getPelletToConsume(GT_MetaTileEntity_Hatch_Energy_RTG aTile) {
        for (ItemStack o : aTile.mInventory) {
            if (o == null) continue;
            for (ItemStack i : mFuelInstanceMap.values()) {
                if (!GT_Utility.areStacksEqual((ItemStack)o, (ItemStack)i)) continue;
                return o;
            }
        }
        return null;
    }

    public boolean useModularUI() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        this.getBaseMetaTileEntity().add3by3Slots(builder, new IDrawable[0]);
    }

    private static class Dat {
        protected final String mUniqueDataTag;
        private final ItemStack mStack;
        private final NBTTagCompound mNBT;

        public Dat(ItemStack aStack) {
            this.mStack = aStack;
            this.mNBT = aStack.func_77978_p() != null ? aStack.func_77978_p() : new NBTTagCompound();
            this.mUniqueDataTag = "" + Item.func_150891_b((Item)aStack.func_77973_b()) + "" + aStack.func_77960_j() + "" + 1 + "" + this.mNBT.func_74732_a();
        }

        public int getKey() {
            return Item.func_150891_b((Item)this.mStack.func_77973_b()) + this.mStack.func_77960_j();
        }
    }
}

