/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import gtPlusPlus.preloader.DevHelper;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class ClassTransformer_Forge_ChunkLoading {
    private static final String className = "net.minecraftforge.common.ForgeChunkManager";
    private final boolean isValid;
    private final ClassReader reader;
    private final ClassWriter writer;
    String aChunkCoordIntPair;
    String aItemStack;
    String aWorld;
    String aEntity;
    private static boolean doesMethodAlreadyExist = false;

    public ClassTransformer_Forge_ChunkLoading(byte[] basicClass, boolean obfuscated) {
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        aTempReader.accept((ClassVisitor)new localClassVisitor((ClassVisitor)aTempWriter), 0);
        this.isValid = aTempReader != null && aTempWriter != null;
        this.reader = aTempReader;
        this.writer = aTempWriter;
        if (this.reader != null && this.writer != null && !doesMethodAlreadyExist) {
            this.aChunkCoordIntPair = obfuscated ? DevHelper.getObfuscated("net/minecraft/world/ChunkCoordIntPair") : "net/minecraft/world/ChunkCoordIntPair";
            this.aWorld = obfuscated ? DevHelper.getObfuscated("net/minecraft/world/World") : "net/minecraft/world/World";
            this.aEntity = obfuscated ? DevHelper.getObfuscated("net/minecraft/entity/Entity") : "net/minecraft/entity/Entity";
            this.injectMethod("forceChunk");
            this.injectMethod("unforceChunk");
            this.injectMethod("requestTicket");
            this.injectMethod("releaseTicket");
        }
    }

    public boolean isValidTransformer() {
        return this.isValid;
    }

    public ClassReader getReader() {
        return this.reader;
    }

    public ClassWriter getWriter() {
        return this.writer;
    }

    public void injectMethod(String aMethodName) {
        FMLRelaunchLog.log((String)"[GT++ ASM] Chunkloading Patch", (Level)Level.INFO, (String)("Injecting " + aMethodName + " into " + className + "."), (Object[])new Object[0]);
        if (aMethodName.equals("forceChunk")) {
            MethodVisitor mv = this.getWriter().visitMethod(9, "forceChunk", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;L" + this.aChunkCoordIntPair + ";)V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(730, l0);
            mv.visitVarInsn(25, 0);
            Label l1 = new Label();
            mv.visitJumpInsn(198, l1);
            mv.visitVarInsn(25, 1);
            Label l2 = new Label();
            mv.visitJumpInsn(199, l2);
            mv.visitLabel(l1);
            mv.visitLineNumber(732, l1);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitInsn(177);
            mv.visitLabel(l2);
            mv.visitLineNumber(734, l2);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$500", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)Lnet/minecraftforge/common/ForgeChunkManager$Type;", false);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager$Type", "ENTITY", "Lnet/minecraftforge/common/ForgeChunkManager$Type;");
            Label l3 = new Label();
            mv.visitJumpInsn(166, l3);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$600", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)L" + this.aEntity + ";", false);
            mv.visitJumpInsn(199, l3);
            Label l4 = new Label();
            mv.visitLabel(l4);
            mv.visitLineNumber(736, l4);
            mv.visitTypeInsn(187, "java/lang/RuntimeException");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)"Attempted to use an entity ticket to force a chunk, without an entity");
            mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V", false);
            mv.visitInsn(191);
            mv.visitLabel(l3);
            mv.visitLineNumber(738, l3);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "net/minecraftforge/common/ForgeChunkManager$Ticket", "isPlayerTicket", "()Z", false);
            Label l5 = new Label();
            mv.visitJumpInsn(153, l5);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "playerTickets", "Lcom/google/common/collect/SetMultimap;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "com/google/common/collect/SetMultimap", "containsValue", "(Ljava/lang/Object;)Z", true);
            Label l6 = new Label();
            mv.visitJumpInsn(154, l6);
            Label l7 = new Label();
            mv.visitJumpInsn(167, l7);
            mv.visitLabel(l5);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "tickets", "Ljava/util/Map;");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "net/minecraftforge/common/ForgeChunkManager$Ticket", "world", "L" + this.aWorld + ";");
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, "com/google/common/collect/Multimap");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$200", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)Ljava/lang/String;", false);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "com/google/common/collect/Multimap", "containsEntry", "(Ljava/lang/Object;Ljava/lang/Object;)Z", true);
            mv.visitJumpInsn(154, l6);
            mv.visitLabel(l7);
            mv.visitLineNumber(740, l7);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitLdcInsn((Object)"The mod %s attempted to force load a chunk with an invalid ticket. This is not permitted.");
            mv.visitInsn(4);
            mv.visitTypeInsn(189, "java/lang/Object");
            mv.visitInsn(89);
            mv.visitInsn(3);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$200", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)Ljava/lang/String;", false);
            mv.visitInsn(83);
            mv.visitMethodInsn(184, "cpw/mods/fml/common/FMLLog", "severe", "(Ljava/lang/String;[Ljava/lang/Object;)V", false);
            Label l8 = new Label();
            mv.visitLabel(l8);
            mv.visitLineNumber(741, l8);
            mv.visitInsn(177);
            mv.visitLabel(l6);
            mv.visitLineNumber(743, l6);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$700", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)Ljava/util/LinkedHashSet;", false);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "java/util/LinkedHashSet", "add", "(Ljava/lang/Object;)Z", false);
            mv.visitInsn(87);
            Label l9 = new Label();
            mv.visitLabel(l9);
            mv.visitLineNumber(744, l9);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/ChunkDebugger", "storeLoadChunkToCache", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;L" + this.aChunkCoordIntPair + ";)V", false);
            Label l10 = new Label();
            mv.visitLabel(l10);
            mv.visitLineNumber(745, l10);
            mv.visitFieldInsn(178, "net/minecraftforge/common/MinecraftForge", "EVENT_BUS", "Lcpw/mods/fml/common/eventhandler/EventBus;");
            mv.visitTypeInsn(187, "net/minecraftforge/common/ForgeChunkManager$ForceChunkEvent");
            mv.visitInsn(89);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, "net/minecraftforge/common/ForgeChunkManager$ForceChunkEvent", "<init>", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;L" + this.aChunkCoordIntPair + ";)V", false);
            mv.visitMethodInsn(182, "cpw/mods/fml/common/eventhandler/EventBus", "post", "(Lcpw/mods/fml/common/eventhandler/Event;)Z", false);
            mv.visitInsn(87);
            Label l11 = new Label();
            mv.visitLabel(l11);
            mv.visitLineNumber(747, l11);
            mv.visitMethodInsn(184, "com/google/common/collect/ImmutableSetMultimap", "builder", "()Lcom/google/common/collect/ImmutableSetMultimap$Builder;", false);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "forcedChunks", "Ljava/util/Map;");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "net/minecraftforge/common/ForgeChunkManager$Ticket", "world", "L" + this.aWorld + ";");
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, "com/google/common/collect/Multimap");
            mv.visitMethodInsn(182, "com/google/common/collect/ImmutableSetMultimap$Builder", "putAll", "(Lcom/google/common/collect/Multimap;)Lcom/google/common/collect/ImmutableSetMultimap$Builder;", false);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "com/google/common/collect/ImmutableSetMultimap$Builder", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/google/common/collect/ImmutableSetMultimap$Builder;", false);
            mv.visitMethodInsn(182, "com/google/common/collect/ImmutableSetMultimap$Builder", "build", "()Lcom/google/common/collect/ImmutableSetMultimap;", false);
            mv.visitVarInsn(58, 2);
            Label l12 = new Label();
            mv.visitLabel(l12);
            mv.visitLineNumber(748, l12);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "forcedChunks", "Ljava/util/Map;");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "net/minecraftforge/common/ForgeChunkManager$Ticket", "world", "L" + this.aWorld + ";");
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitInsn(87);
            Label l13 = new Label();
            mv.visitLabel(l13);
            mv.visitLineNumber(749, l13);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$800", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)I", false);
            Label l14 = new Label();
            mv.visitJumpInsn(158, l14);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$700", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)Ljava/util/LinkedHashSet;", false);
            mv.visitMethodInsn(182, "java/util/LinkedHashSet", "size", "()I", false);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$800", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)I", false);
            mv.visitJumpInsn(164, l14);
            Label l15 = new Label();
            mv.visitLabel(l15);
            mv.visitLineNumber(751, l15);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$700", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)Ljava/util/LinkedHashSet;", false);
            mv.visitMethodInsn(182, "java/util/LinkedHashSet", "iterator", "()Ljava/util/Iterator;", false);
            mv.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, "" + this.aChunkCoordIntPair + "");
            mv.visitVarInsn(58, 3);
            Label l16 = new Label();
            mv.visitLabel(l16);
            mv.visitLineNumber(752, l16);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager", "unforceChunk", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;L" + this.aChunkCoordIntPair + ";)V", false);
            mv.visitLabel(l14);
            mv.visitLineNumber(754, l14);
            mv.visitFrame(1, 1, new Object[]{"com/google/common/collect/ImmutableSetMultimap"}, 0, null);
            mv.visitInsn(177);
            Label l17 = new Label();
            mv.visitLabel(l17);
            mv.visitLocalVariable("ticket", "Lnet/minecraftforge/common/ForgeChunkManager$Ticket;", null, l0, l17, 0);
            mv.visitLocalVariable("chunk", "L" + this.aChunkCoordIntPair + ";", null, l0, l17, 1);
            mv.visitLocalVariable("newMap", "Lcom/google/common/collect/ImmutableSetMultimap;", "Lcom/google/common/collect/ImmutableSetMultimap<L" + this.aChunkCoordIntPair + ";Lnet/minecraftforge/common/ForgeChunkManager$Ticket;>;", l12, l17, 2);
            mv.visitLocalVariable("removed", "L" + this.aChunkCoordIntPair + ";", null, l16, l14, 3);
            mv.visitMaxs(5, 4);
            mv.visitEnd();
        } else if (aMethodName.equals("unforceChunk")) {
            MethodVisitor mv = this.getWriter().visitMethod(9, "unforceChunk", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;L" + this.aChunkCoordIntPair + ";)V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(781, l0);
            mv.visitVarInsn(25, 0);
            Label l1 = new Label();
            mv.visitJumpInsn(198, l1);
            mv.visitVarInsn(25, 1);
            Label l2 = new Label();
            mv.visitJumpInsn(199, l2);
            mv.visitLabel(l1);
            mv.visitLineNumber(783, l1);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitInsn(177);
            mv.visitLabel(l2);
            mv.visitLineNumber(785, l2);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$700", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)Ljava/util/LinkedHashSet;", false);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "java/util/LinkedHashSet", "remove", "(Ljava/lang/Object;)Z", false);
            mv.visitInsn(87);
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLineNumber(786, l3);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/ChunkDebugger", "removeLoadedChunkFromCache", "(L" + this.aChunkCoordIntPair + ";)V", false);
            Label l4 = new Label();
            mv.visitLabel(l4);
            mv.visitLineNumber(787, l4);
            mv.visitFieldInsn(178, "net/minecraftforge/common/MinecraftForge", "EVENT_BUS", "Lcpw/mods/fml/common/eventhandler/EventBus;");
            mv.visitTypeInsn(187, "net/minecraftforge/common/ForgeChunkManager$UnforceChunkEvent");
            mv.visitInsn(89);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, "net/minecraftforge/common/ForgeChunkManager$UnforceChunkEvent", "<init>", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;L" + this.aChunkCoordIntPair + ";)V", false);
            mv.visitMethodInsn(182, "cpw/mods/fml/common/eventhandler/EventBus", "post", "(Lcpw/mods/fml/common/eventhandler/Event;)Z", false);
            mv.visitInsn(87);
            Label l5 = new Label();
            mv.visitLabel(l5);
            mv.visitLineNumber(788, l5);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "forcedChunks", "Ljava/util/Map;");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "net/minecraftforge/common/ForgeChunkManager$Ticket", "world", "L" + this.aWorld + ";");
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, "com/google/common/collect/Multimap");
            mv.visitMethodInsn(184, "com/google/common/collect/LinkedHashMultimap", "create", "(Lcom/google/common/collect/Multimap;)Lcom/google/common/collect/LinkedHashMultimap;", false);
            mv.visitVarInsn(58, 2);
            Label l6 = new Label();
            mv.visitLabel(l6);
            mv.visitLineNumber(789, l6);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "com/google/common/collect/LinkedHashMultimap", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
            mv.visitInsn(87);
            Label l7 = new Label();
            mv.visitLabel(l7);
            mv.visitLineNumber(790, l7);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(184, "com/google/common/collect/ImmutableSetMultimap", "copyOf", "(Lcom/google/common/collect/Multimap;)Lcom/google/common/collect/ImmutableSetMultimap;", false);
            mv.visitVarInsn(58, 3);
            Label l8 = new Label();
            mv.visitLabel(l8);
            mv.visitLineNumber(791, l8);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "forcedChunks", "Ljava/util/Map;");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "net/minecraftforge/common/ForgeChunkManager$Ticket", "world", "L" + this.aWorld + ";");
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitInsn(87);
            Label l9 = new Label();
            mv.visitLabel(l9);
            mv.visitLineNumber(792, l9);
            mv.visitInsn(177);
            Label l10 = new Label();
            mv.visitLabel(l10);
            mv.visitLocalVariable("ticket", "Lnet/minecraftforge/common/ForgeChunkManager$Ticket;", null, l0, l10, 0);
            mv.visitLocalVariable("chunk", "L" + this.aChunkCoordIntPair + ";", null, l0, l10, 1);
            mv.visitLocalVariable("copy", "Lcom/google/common/collect/LinkedHashMultimap;", "Lcom/google/common/collect/LinkedHashMultimap<L" + this.aChunkCoordIntPair + ";Lnet/minecraftforge/common/ForgeChunkManager$Ticket;>;", l6, l10, 2);
            mv.visitLocalVariable("newMap", "Lcom/google/common/collect/ImmutableSetMultimap;", "Lcom/google/common/collect/ImmutableSetMultimap<L" + this.aChunkCoordIntPair + ";Lnet/minecraftforge/common/ForgeChunkManager$Ticket;>;", l8, l10, 3);
            mv.visitMaxs(5, 4);
            mv.visitEnd();
        } else if (aMethodName.equals("requestTicket")) {
            MethodVisitor mv = this.getWriter().visitMethod(9, "requestTicket", "(Ljava/lang/Object;L" + this.aWorld + ";Lnet/minecraftforge/common/ForgeChunkManager$Type;)Lnet/minecraftforge/common/ForgeChunkManager$Ticket;", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(656, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager", "getContainer", "(Ljava/lang/Object;)Lcpw/mods/fml/common/ModContainer;", false);
            mv.visitVarInsn(58, 3);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLineNumber(657, l1);
            mv.visitVarInsn(25, 3);
            Label l2 = new Label();
            mv.visitJumpInsn(199, l2);
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLineNumber(659, l3);
            mv.visitFieldInsn(178, "org/apache/logging/log4j/Level", "ERROR", "Lorg/apache/logging/log4j/Level;");
            mv.visitLdcInsn((Object)"Failed to locate the container for mod instance %s (%s : %x)");
            mv.visitInsn(6);
            mv.visitTypeInsn(189, "java/lang/Object");
            mv.visitInsn(89);
            mv.visitInsn(3);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(83);
            mv.visitInsn(89);
            mv.visitInsn(4);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
            mv.visitMethodInsn(182, "java/lang/Class", "getName", "()Ljava/lang/String;", false);
            mv.visitInsn(83);
            mv.visitInsn(89);
            mv.visitInsn(5);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "java/lang/System", "identityHashCode", "(Ljava/lang/Object;)I", false);
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
            mv.visitInsn(83);
            mv.visitMethodInsn(184, "cpw/mods/fml/common/FMLLog", "log", "(Lorg/apache/logging/log4j/Level;Ljava/lang/String;[Ljava/lang/Object;)V", false);
            Label l4 = new Label();
            mv.visitLabel(l4);
            mv.visitLineNumber(660, l4);
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitLabel(l2);
            mv.visitLineNumber(662, l2);
            mv.visitFrame(1, 1, new Object[]{"cpw/mods/fml/common/ModContainer"}, 0, null);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(185, "cpw/mods/fml/common/ModContainer", "getModId", "()Ljava/lang/String;", true);
            mv.visitVarInsn(58, 4);
            Label l5 = new Label();
            mv.visitLabel(l5);
            mv.visitLineNumber(663, l5);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "callbacks", "Ljava/util/Map;");
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(185, "java/util/Map", "containsKey", "(Ljava/lang/Object;)Z", true);
            Label l6 = new Label();
            mv.visitJumpInsn(154, l6);
            Label l7 = new Label();
            mv.visitLabel(l7);
            mv.visitLineNumber(665, l7);
            mv.visitLdcInsn((Object)"The mod %s has attempted to request a ticket without a listener in place");
            mv.visitInsn(4);
            mv.visitTypeInsn(189, "java/lang/Object");
            mv.visitInsn(89);
            mv.visitInsn(3);
            mv.visitVarInsn(25, 4);
            mv.visitInsn(83);
            mv.visitMethodInsn(184, "cpw/mods/fml/common/FMLLog", "severe", "(Ljava/lang/String;[Ljava/lang/Object;)V", false);
            Label l8 = new Label();
            mv.visitLabel(l8);
            mv.visitLineNumber(666, l8);
            mv.visitTypeInsn(187, "java/lang/RuntimeException");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)"Invalid ticket request");
            mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V", false);
            mv.visitInsn(191);
            mv.visitLabel(l6);
            mv.visitLineNumber(669, l6);
            mv.visitFrame(1, 1, new Object[]{"java/lang/String"}, 0, null);
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager", "getMaxTicketLengthFor", "(Ljava/lang/String;)I", false);
            mv.visitVarInsn(54, 5);
            Label l9 = new Label();
            mv.visitLabel(l9);
            mv.visitLineNumber(671, l9);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "tickets", "Ljava/util/Map;");
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, "com/google/common/collect/Multimap");
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(185, "com/google/common/collect/Multimap", "get", "(Ljava/lang/Object;)Ljava/util/Collection;", true);
            mv.visitMethodInsn(185, "java/util/Collection", "size", "()I", true);
            mv.visitVarInsn(21, 5);
            Label l10 = new Label();
            mv.visitJumpInsn(161, l10);
            Label l11 = new Label();
            mv.visitLabel(l11);
            mv.visitLineNumber(673, l11);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "warnedMods", "Ljava/util/Set;");
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(185, "java/util/Set", "contains", "(Ljava/lang/Object;)Z", true);
            Label l12 = new Label();
            mv.visitJumpInsn(154, l12);
            Label l13 = new Label();
            mv.visitLabel(l13);
            mv.visitLineNumber(675, l13);
            mv.visitLdcInsn((Object)"The mod %s has attempted to allocate a chunkloading ticket beyond it's currently allocated maximum : %d");
            mv.visitInsn(5);
            mv.visitTypeInsn(189, "java/lang/Object");
            mv.visitInsn(89);
            mv.visitInsn(3);
            mv.visitVarInsn(25, 4);
            mv.visitInsn(83);
            mv.visitInsn(89);
            mv.visitInsn(4);
            mv.visitVarInsn(21, 5);
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
            mv.visitInsn(83);
            mv.visitMethodInsn(184, "cpw/mods/fml/common/FMLLog", "info", "(Ljava/lang/String;[Ljava/lang/Object;)V", false);
            Label l14 = new Label();
            mv.visitLabel(l14);
            mv.visitLineNumber(676, l14);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "warnedMods", "Ljava/util/Set;");
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(185, "java/util/Set", "add", "(Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
            mv.visitLabel(l12);
            mv.visitLineNumber(678, l12);
            mv.visitFrame(1, 1, new Object[]{Opcodes.INTEGER}, 0, null);
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitLabel(l10);
            mv.visitLineNumber(680, l10);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitTypeInsn(187, "net/minecraftforge/common/ForgeChunkManager$Ticket");
            mv.visitInsn(89);
            mv.visitVarInsn(25, 4);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, "net/minecraftforge/common/ForgeChunkManager$Ticket", "<init>", "(Ljava/lang/String;Lnet/minecraftforge/common/ForgeChunkManager$Type;L" + this.aWorld + ";)V", false);
            mv.visitVarInsn(58, 6);
            Label l15 = new Label();
            mv.visitLabel(l15);
            mv.visitLineNumber(681, l15);
            mv.visitVarInsn(25, 6);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/ChunkDebugger", "storeTicketToCache", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;L" + this.aWorld + ";)V", false);
            Label l16 = new Label();
            mv.visitLabel(l16);
            mv.visitLineNumber(682, l16);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "tickets", "Ljava/util/Map;");
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, "com/google/common/collect/Multimap");
            mv.visitVarInsn(25, 4);
            mv.visitVarInsn(25, 6);
            mv.visitMethodInsn(185, "com/google/common/collect/Multimap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
            Label l17 = new Label();
            mv.visitLabel(l17);
            mv.visitLineNumber(683, l17);
            mv.visitVarInsn(25, 6);
            mv.visitInsn(176);
            Label l18 = new Label();
            mv.visitLabel(l18);
            mv.visitLocalVariable("mod", "Ljava/lang/Object;", null, l0, l18, 0);
            mv.visitLocalVariable("world", "L" + this.aWorld + ";", null, l0, l18, 1);
            mv.visitLocalVariable("type", "Lnet/minecraftforge/common/ForgeChunkManager$Type;", null, l0, l18, 2);
            mv.visitLocalVariable("container", "Lcpw/mods/fml/common/ModContainer;", null, l1, l18, 3);
            mv.visitLocalVariable("modId", "Ljava/lang/String;", null, l5, l18, 4);
            mv.visitLocalVariable("allowedCount", "I", null, l9, l18, 5);
            mv.visitLocalVariable("ticket", "Lnet/minecraftforge/common/ForgeChunkManager$Ticket;", null, l15, l18, 6);
            mv.visitMaxs(6, 7);
            mv.visitEnd();
        } else if (aMethodName.equals("releaseTicket")) {
            MethodVisitor mv = this.getWriter().visitMethod(9, "releaseTicket", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(693, l0);
            mv.visitVarInsn(25, 0);
            Label l1 = new Label();
            mv.visitJumpInsn(199, l1);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitLineNumber(695, l2);
            mv.visitInsn(177);
            mv.visitLabel(l1);
            mv.visitLineNumber(697, l1);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "net/minecraftforge/common/ForgeChunkManager$Ticket", "isPlayerTicket", "()Z", false);
            Label l3 = new Label();
            mv.visitJumpInsn(153, l3);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "playerTickets", "Lcom/google/common/collect/SetMultimap;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "com/google/common/collect/SetMultimap", "containsValue", "(Ljava/lang/Object;)Z", true);
            Label l4 = new Label();
            mv.visitJumpInsn(154, l4);
            Label l5 = new Label();
            mv.visitJumpInsn(167, l5);
            mv.visitLabel(l3);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "tickets", "Ljava/util/Map;");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "net/minecraftforge/common/ForgeChunkManager$Ticket", "world", "L" + this.aWorld + ";");
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, "com/google/common/collect/Multimap");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$200", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)Ljava/lang/String;", false);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "com/google/common/collect/Multimap", "containsEntry", "(Ljava/lang/Object;Ljava/lang/Object;)Z", true);
            mv.visitJumpInsn(154, l4);
            mv.visitLabel(l5);
            mv.visitLineNumber(699, l5);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitInsn(177);
            mv.visitLabel(l4);
            mv.visitLineNumber(701, l4);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$700", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)Ljava/util/LinkedHashSet;", false);
            Label l6 = new Label();
            mv.visitJumpInsn(198, l6);
            Label l7 = new Label();
            mv.visitLabel(l7);
            mv.visitLineNumber(703, l7);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$700", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)Ljava/util/LinkedHashSet;", false);
            mv.visitMethodInsn(184, "com/google/common/collect/ImmutableSet", "copyOf", "(Ljava/util/Collection;)Lcom/google/common/collect/ImmutableSet;", false);
            mv.visitMethodInsn(182, "com/google/common/collect/ImmutableSet", "iterator", "()Ljava/util/Iterator;", false);
            mv.visitVarInsn(58, 2);
            Label l8 = new Label();
            mv.visitJumpInsn(167, l8);
            Label l9 = new Label();
            mv.visitLabel(l9);
            mv.visitFrame(0, 3, new Object[]{"net/minecraftforge/common/ForgeChunkManager$Ticket", Opcodes.TOP, "java/util/Iterator"}, 0, new Object[0]);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, "" + this.aChunkCoordIntPair + "");
            mv.visitVarInsn(58, 1);
            Label l10 = new Label();
            mv.visitLabel(l10);
            mv.visitLineNumber(705, l10);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager", "unforceChunk", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;L" + this.aChunkCoordIntPair + ";)V", false);
            mv.visitLabel(l8);
            mv.visitLineNumber(703, l8);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
            mv.visitJumpInsn(154, l9);
            mv.visitLabel(l6);
            mv.visitLineNumber(708, l6);
            mv.visitFrame(0, 1, new Object[]{"net/minecraftforge/common/ForgeChunkManager$Ticket"}, 0, new Object[0]);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/ChunkDebugger", "removeTicketFromCache", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)V", false);
            Label l11 = new Label();
            mv.visitLabel(l11);
            mv.visitLineNumber(709, l11);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "net/minecraftforge/common/ForgeChunkManager$Ticket", "isPlayerTicket", "()Z", false);
            Label l12 = new Label();
            mv.visitJumpInsn(153, l12);
            Label l13 = new Label();
            mv.visitLabel(l13);
            mv.visitLineNumber(711, l13);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "playerTickets", "Lcom/google/common/collect/SetMultimap;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$100", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)Ljava/lang/String;", false);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "com/google/common/collect/SetMultimap", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
            Label l14 = new Label();
            mv.visitLabel(l14);
            mv.visitLineNumber(712, l14);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "tickets", "Ljava/util/Map;");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "net/minecraftforge/common/ForgeChunkManager$Ticket", "world", "L" + this.aWorld + ";");
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, "com/google/common/collect/Multimap");
            mv.visitLdcInsn((Object)"Forge");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "com/google/common/collect/Multimap", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
            Label l15 = new Label();
            mv.visitLabel(l15);
            mv.visitLineNumber(713, l15);
            Label l16 = new Label();
            mv.visitJumpInsn(167, l16);
            mv.visitLabel(l12);
            mv.visitLineNumber(716, l12);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitFieldInsn(178, "net/minecraftforge/common/ForgeChunkManager", "tickets", "Ljava/util/Map;");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "net/minecraftforge/common/ForgeChunkManager$Ticket", "world", "L" + this.aWorld + ";");
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, "com/google/common/collect/Multimap");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "net/minecraftforge/common/ForgeChunkManager$Ticket", "access$200", "(Lnet/minecraftforge/common/ForgeChunkManager$Ticket;)Ljava/lang/String;", false);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "com/google/common/collect/Multimap", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
            mv.visitLabel(l16);
            mv.visitLineNumber(718, l16);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitInsn(177);
            Label l17 = new Label();
            mv.visitLabel(l17);
            mv.visitLocalVariable("ticket", "Lnet/minecraftforge/common/ForgeChunkManager$Ticket;", null, l0, l17, 0);
            mv.visitLocalVariable("chunk", "L" + this.aChunkCoordIntPair + ";", null, l10, l8, 1);
            mv.visitMaxs(3, 3);
            mv.visitEnd();
        }
        FMLRelaunchLog.log((String)"[GT++ ASM] Chunkloading Patch", (Level)Level.INFO, (String)"Method injection complete.", (Object[])new Object[0]);
    }

    public static final class localClassVisitor
    extends ClassVisitor {
        public localClassVisitor(ClassVisitor cv) {
            super(327680, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals("forceChunk") || name.equals("unforceChunk") || name.equals("requestTicket") || name.equals("releaseTicket")) {
                FMLRelaunchLog.log((String)"[GT++ ASM] Chunkloading Patch", (Level)Level.INFO, (String)("Found method " + name + ", Patching."), (Object[])new Object[0]);
                return null;
            }
            MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            return methodVisitor;
        }
    }
}

