/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.general;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.inventories.Inventory_DecayablesChest;
import gtPlusPlus.core.item.materials.DustDecayable;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityDecayablesChest
extends TileEntity
implements ISidedInventory {
    private final Inventory_DecayablesChest inventoryContents = new Inventory_DecayablesChest();
    public boolean adjacentChestChecked;
    public TileEntityDecayablesChest adjacentChestZNeg;
    public TileEntityDecayablesChest adjacentChestXPos;
    public TileEntityDecayablesChest adjacentChestXNeg;
    public TileEntityDecayablesChest adjacentChestZPos;
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    private String customName;
    private int cachedChestType;
    private int tickCount = 0;

    public Inventory_DecayablesChest getInventory() {
        return this.inventoryContents;
    }

    public void func_145845_h() {
        try {
            this.updateEntityChest();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!this.field_145850_b.field_72995_K) {
                ++this.tickCount;
                if (this.tickCount % 10 == 0) {
                    this.cachedChestType = 1;
                }
                if (this.tickCount % 20 == 0) {
                    for (ItemStack inv : this.getInventory().getInventory()) {
                        if (inv == null || !(inv.func_77973_b() instanceof DustDecayable)) continue;
                        DustDecayable D = (DustDecayable)inv.func_77973_b();
                        this.tryUpdateDecayable(D, inv, this.field_145850_b);
                    }
                }
                this.updateSlots();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void tryUpdateDecayable(DustDecayable b, ItemStack iStack, World world) {
        if (world == null || iStack == null) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        boolean a1 = b.isTicking(world, iStack);
        boolean a2 = false;
        int SECONDS_TO_PROCESS = 1;
        for (int u = 0; u < 20 * SECONDS_TO_PROCESS && a1; ++u) {
            a1 = b.isTicking(world, iStack);
            a2 = b.tickItemTag(world, iStack);
        }
        Logger.MACHINE_INFO("| " + b.func_77658_a() + " | " + a1 + "/" + a2, new Object[0]);
        if (!a1 && !a2) {
            ItemStack replacement = ItemUtils.getSimpleStack(b.getDecayResult());
            replacement.field_77994_a = 1;
            for (int fff = 0; fff < this.inventoryContents.func_70302_i_(); ++fff) {
                if (this.inventoryContents.func_70301_a(fff) != iStack) continue;
                this.inventoryContents.func_70299_a(fff, replacement.func_77946_l());
            }
            this.updateSlots();
            this.inventoryContents.func_70296_d();
        }
    }

    public boolean anyPlayerInRange() {
        return this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 32.0) != null;
    }

    public NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound chestData = new NBTTagCompound();
        this.inventoryContents.writeToNBT(chestData);
        nbt.func_74782_a("ContentsChest", (NBTBase)chestData);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.getCustomName());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventoryContents.readFromNBT(nbt.func_74775_l("ContentsChest"));
        if (nbt.func_150297_b("CustomName", 8)) {
            this.setCustomName(nbt.func_74779_i("CustomName"));
        }
    }

    public int func_70302_i_() {
        return this.getInventory().func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.getInventory().func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.getInventory().func_70298_a(slot, count);
    }

    public ItemStack func_70304_b(int slot) {
        return this.getInventory().func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.getInventory().func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.getInventory().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.getInventory().func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        if (!this.field_145850_b.field_72995_K) {
            ++this.numPlayersUsing;
            this.cachedChestType = 1;
        }
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        this.getInventory().func_70295_k_();
    }

    public void func_70305_f() {
        if (!this.field_145850_b.field_72995_K) {
            --this.numPlayersUsing;
            this.cachedChestType = 1;
        }
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        this.getInventory().func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.getInventory().func_94041_b(slot, itemstack);
    }

    public int[] func_94128_d(int p_94128_1_) {
        int[] accessibleSides = new int[this.func_70302_i_()];
        for (int r = 0; r < this.getInventory().func_70302_i_(); ++r) {
            accessibleSides[r] = r;
        }
        return accessibleSides;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return this.getInventory().func_94041_b(0, p_102007_2_);
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return this.getInventory().func_94041_b(0, p_102008_2_);
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.DecayablesChest";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.equals("");
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.adjacentChestChecked = false;
    }

    public void checkForAdjacentChests() {
        if (!this.adjacentChestChecked) {
            this.adjacentChestChecked = true;
            this.adjacentChestZNeg = null;
            this.adjacentChestXPos = null;
            this.adjacentChestXNeg = null;
            this.adjacentChestZPos = null;
        }
    }

    public void updateEntityChest() {
        double d2;
        this.prevLidAngle = this.lidAngle;
        float f = 0.04f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f && this.adjacentChestZNeg == null && this.adjacentChestXNeg == null) {
            double d1 = (double)this.field_145851_c + 0.5;
            d2 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d1, (double)this.field_145848_d + 0.5, d2, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += (float)((double)f * 1.001)) : (this.lidAngle -= (float)((double)f * 1.001));
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2 && this.adjacentChestZNeg == null && this.adjacentChestXNeg == null) {
                d2 = (double)this.field_145851_c + 0.5;
                double d0 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d2, (double)this.field_145848_d + 0.5, d0, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int p_145842_1_, int p_145842_2_) {
        if (p_145842_1_ == 1) {
            this.numPlayersUsing = p_145842_2_;
            return true;
        }
        return super.func_145842_c(p_145842_1_, p_145842_2_);
    }

    public final void func_145843_s() {
        super.func_145843_s();
        this.cachedChestType = 1;
        this.func_145836_u();
        this.checkForAdjacentChests();
    }

    private final int updateSlots() {
        if (this.cachedChestType == 0) {
            return 0;
        }
        ItemUtils.organiseInventory(this.getInventory());
        this.cachedChestType = 0;
        return this.cachedChestType;
    }
}

