/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.commands;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.commands.CommandUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.preloader.ChunkDebugger;
import gtPlusPlus.preloader.asm.AsmConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class CommandDebugChunks
implements ICommand {
    private final List<String> aliases = new ArrayList<String>();
    protected String fullEntityName;
    protected Entity conjuredEntity;

    public CommandDebugChunks() {
        this.aliases.add("debugchunks");
        this.aliases.add("DC");
    }

    public int compareTo(Object o) {
        return 0;
    }

    public String func_71517_b() {
        return "DebugChunks";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/DebugChunks";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_71515_b(ICommandSender S, String[] argString) {
        Logger.INFO("Debug Command");
        World W = S.func_130014_f_();
        EntityPlayer P = CommandUtils.getPlayer(S);
        if (!AsmConfig.enableChunkDebugging) {
            PlayerUtils.messagePlayer(P, "Chunk Debugging is disabled.");
            return;
        }
        LinkedHashMap<String, Integer> aTicketCounter = new LinkedHashMap<String, Integer>();
        for (Pair<String, String> f : ChunkDebugger.mChunkTicketsMap.values()) {
            String aMod = f.getKey();
            String aDim = f.getValue();
            if (aMod == null) continue;
            if (aTicketCounter.containsKey(aMod)) {
                int aModTicketCount = (Integer)aTicketCounter.get(aMod);
                aTicketCounter.put(aMod, ++aModTicketCount);
                continue;
            }
            aTicketCounter.put(aMod, 1);
        }
        if (aTicketCounter.isEmpty()) {
            PlayerUtils.messagePlayer(P, "No forced chunk tickets active.");
        }
        for (String x : aTicketCounter.keySet()) {
            PlayerUtils.messagePlayer(P, x + " has " + aTicketCounter.get(x) + " tickets active.");
        }
        LinkedHashMap<String, Integer> aChunkCounter = new LinkedHashMap<String, Integer>();
        for (Pair<String, String> f : ChunkDebugger.mChunksLoadedByModsMap.values()) {
            String aMod = f.getKey();
            String aDim = f.getValue();
            if (aMod == null) {
                aMod = "Bad ModId";
            }
            if (aMod == null) continue;
            if (aChunkCounter.containsKey(aMod)) {
                int aModTicketCount = (Integer)aChunkCounter.get(aMod);
                aChunkCounter.put(aMod, ++aModTicketCount);
                Logger.INFO("Counting +1 for " + aMod + ", total of " + aModTicketCount);
                continue;
            }
            aChunkCounter.put(aMod, 1);
            Logger.INFO("Counting +1 for " + aMod);
        }
        if (aChunkCounter.isEmpty()) {
            PlayerUtils.messagePlayer(P, "No chunks force loaded.");
        }
        for (String x : aChunkCounter.keySet()) {
            PlayerUtils.messagePlayer(P, x + " has " + aChunkCounter.get(x) + " chunks active.");
        }
    }

    public boolean func_71519_b(ICommandSender var1) {
        EntityPlayer P = CommandUtils.getPlayer(var1);
        if (P == null) {
            return false;
        }
        return PlayerUtils.isPlayerOP(P);
    }

    public List<?> func_71516_a(ICommandSender var1, String[] var2) {
        return new ArrayList();
    }

    public boolean func_82358_a(String[] var1, int var2) {
        return false;
    }

    public boolean playerUsesCommand(World W, EntityPlayer P, int cost) {
        return true;
    }
}

