/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.block.general;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.block.general.LightGlass;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockSuperLight
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon textureFront;

    public BlockSuperLight() {
        super(Material.field_151594_q);
        this.func_149663_c("blockSuperLight");
        this.func_149647_a(CreativeTabs.field_78028_d);
        GameRegistry.registerBlock((Block)this, (String)"blockSuperLight");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int ordinalSide, int meta) {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a(Mods.GTPlusPlus.ID + ":SwirlBigBlue");
    }

    public TileEntity func_149915_a(World aWorld, int p_149915_2_) {
        return new TileEntitySuperLight();
    }

    public static class TileEntitySuperLight
    extends TileEntity {
        private long mCreated;
        private long mLastUpdateTick = 0L;
        private int mLitBlockCount = 0;
        private int[][][][] aLitBlocks = new int[50][10][50][1];
        private boolean mPowered = false;

        public TileEntitySuperLight() {
            this.mCreated = System.currentTimeMillis();
            Logger.INFO("Created Super-Lamp");
        }

        public void func_145839_a(NBTTagCompound aNBT) {
            super.func_145839_a(aNBT);
            this.mCreated = aNBT.func_74763_f("mCreated");
            this.mPowered = aNBT.func_74767_n("mPowered");
            NBTTagCompound aLightingData = aNBT.func_74775_l("lighting");
            for (int x = 0; x < 50; ++x) {
                for (int y = 0; y < 10; ++y) {
                    for (int z = 0; z < 50; ++z) {
                        int aData;
                        this.aLitBlocks[x][y][z][0] = aData = aLightingData.func_74762_e("[" + x + "][" + y + "][" + z + "]");
                    }
                }
            }
        }

        public void func_145841_b(NBTTagCompound aNBT) {
            super.func_145841_b(aNBT);
            aNBT.func_74772_a("mCreated", this.mCreated);
            aNBT.func_74757_a("mPowered", this.mPowered);
            NBTTagCompound aLightingData = new NBTTagCompound();
            for (int x = 0; x < 50; ++x) {
                for (int y = 0; y < 10; ++y) {
                    for (int z = 0; z < 50; ++z) {
                        int aFlag = this.aLitBlocks[x][y][z][0];
                        aLightingData.func_74768_a("[" + x + "][" + y + "][" + z + "]", aFlag);
                    }
                }
            }
            aNBT.func_74782_a("lighting", (NBTBase)aLightingData);
        }

        public void func_145845_h() {
            super.func_145845_h();
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            try {
                if (this.mLastUpdateTick == 0L || System.currentTimeMillis() - this.mLastUpdateTick >= 30000L) {
                    boolean powered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    boolean aLastState = this.mPowered;
                    this.mPowered = powered;
                    if (this.mPowered != aLastState) {
                        this.updateLighting(powered);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean canUpdate() {
            return super.canUpdate();
        }

        public void updateLighting(boolean enable) {
            this.mLastUpdateTick = System.currentTimeMillis();
            this.aLitBlocks = new int[50][10][50][1];
            int aLitCounter = 0;
            AutoMap<BlockPos> aBlocksToUpdate = new AutoMap<BlockPos>();
            Logger.INFO("Trying to relight area.");
            BlockPos aStartIterationPoint = new BlockPos(this.field_145851_c - 24, this.field_145848_d - 4, this.field_145849_e - 24, this.field_145850_b);
            for (int x = 0; x < 50; ++x) {
                for (int y = 0; y < 10; ++y) {
                    for (int z = 0; z < 50; ++z) {
                        int xOff = aStartIterationPoint.xPos + x;
                        int yOff = aStartIterationPoint.yPos + y;
                        int zOff = aStartIterationPoint.zPos + z;
                        Block aBlockGet = this.field_145850_b.func_147439_a(xOff, yOff, zOff);
                        if (aBlockGet != null) {
                            if (aBlockGet instanceof BlockAir || aBlockGet instanceof LightGlass) {
                                int aLight = aBlockGet.func_149750_m();
                                if (enable && aLight > 0 || !enable && aLight == 0) continue;
                                if (enable && aLight == 0) {
                                    aBlocksToUpdate.put(new BlockPos(xOff, yOff, zOff, this.field_145850_b));
                                    if (aBlockGet instanceof BlockAir) {
                                        Logger.INFO("Lit air.");
                                        this.field_145850_b.func_147465_d(xOff, yOff, zOff, ModBlocks.MatterFabricatorEffectBlock, 0, 3);
                                    }
                                    ++aLitCounter;
                                } else if (!enable && aLight > 0) {
                                    aBlocksToUpdate.put(new BlockPos(xOff, yOff, zOff, this.field_145850_b));
                                    if (aBlockGet instanceof LightGlass) {
                                        Logger.INFO("Dimmed air.");
                                        this.field_145850_b.func_147465_d(xOff, yOff, zOff, Blocks.field_150350_a, 0, 3);
                                    }
                                }
                                this.aLitBlocks[x][y][z][0] = enable ? 15 : 0;
                                continue;
                            }
                            this.aLitBlocks[x][y][z][0] = -1;
                            continue;
                        }
                        this.aLitBlocks[x][y][z][0] = -1;
                    }
                }
            }
            this.mLitBlockCount = aLitCounter;
            this.doLargeBlockUpdate(aBlocksToUpdate);
        }

        public void doLargeBlockUpdate(AutoMap<BlockPos> aUpdateMap) {
            if (aUpdateMap.isEmpty()) {
                return;
            }
            for (BlockPos blockPos : aUpdateMap) {
            }
        }
    }
}

