/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import forestry.api.farming.FarmDirection;
import forestry.core.utils.vect.MutableVect;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import forestry.farming.FarmHelper;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class FarmTarget {
    private final Vect start;
    private final FarmDirection direction;
    private final int limit;
    private int yOffset;
    private int extent;

    public FarmTarget(Vect start, FarmDirection direction, int limit) {
        this.start = start;
        this.direction = direction;
        this.limit = limit;
    }

    public Vect getStart() {
        return this.start;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public int getExtent() {
        return this.extent;
    }

    public FarmDirection getDirection() {
        return this.direction;
    }

    public void setExtentAndYOffset(World world, Vect platformPosition) {
        Block platform;
        if (platformPosition == null) {
            this.extent = 0;
            return;
        }
        MutableVect position = new MutableVect(platformPosition);
        this.extent = 0;
        while (this.extent < this.limit && FarmHelper.bricks.contains((Object)(platform = VectUtil.getBlock(world, position)))) {
            position.add(this.getDirection().getForgeDirection());
            ++this.extent;
        }
        this.yOffset = platformPosition.getY() + 1 - this.getStart().getY();
    }
}

