/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerProvider;
import cpw.mods.fml.common.Optional;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.core.access.AccessHandler;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.errors.ErrorLogic;
import forestry.core.gui.IGuiHandlerTile;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.AdjacentTileCache;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.tiles.ILocatable;
import forestry.core.tiles.ITitled;
import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="buildcraft.api.statements.ITriggerProvider", modid="BuildCraftAPI|statements")
public abstract class TileForestry
extends TileEntity
implements IStreamable,
IErrorLogicSource,
ITriggerProvider,
ISidedInventory,
IFilterSlotDelegate,
IRestrictedAccess,
ITitled,
ILocatable,
IGuiHandlerTile {
    private static final ForgeDirection[] forgeDirections = ForgeDirection.values();
    private static final Random rand = new Random();
    private final AccessHandler accessHandler = new AccessHandler(this);
    private final ErrorLogic errorHandler = new ErrorLogic();
    private final AdjacentTileCache tileCache = new AdjacentTileCache(this);
    private IInventoryAdapter inventory = FakeInventoryAdapter.instance();
    private int tickCount = rand.nextInt(256);
    private boolean needsNetworkUpdate = false;
    private ForgeDirection orientation = ForgeDirection.WEST;

    protected AdjacentTileCache getTileCache() {
        return this.tileCache;
    }

    public void onNeighborBlockChange(Block id) {
        this.tileCache.onNeighborChange();
    }

    public void func_145843_s() {
        this.tileCache.purge();
        super.func_145843_s();
    }

    public void func_145829_t() {
        this.tileCache.purge();
        super.func_145829_t();
    }

    public void rotateAfterPlacement(EntityPlayer player, int side) {
        int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            this.setOrientation(ForgeDirection.NORTH);
        }
        if (l == 1) {
            this.setOrientation(ForgeDirection.EAST);
        }
        if (l == 2) {
            this.setOrientation(ForgeDirection.SOUTH);
        }
        if (l == 3) {
            this.setOrientation(ForgeDirection.WEST);
        }
    }

    public boolean rotate(ForgeDirection axis) {
        if (axis == ForgeDirection.DOWN || axis == ForgeDirection.UP) {
            ForgeDirection orientation = this.getOrientation().getRotation(axis);
            this.setOrientation(orientation);
            return true;
        }
        return false;
    }

    public final void func_145845_h() {
        ++this.tickCount;
        if (!this.field_145850_b.field_72995_K) {
            this.updateServerSide();
        } else {
            this.updateClientSide();
        }
        if (this.needsNetworkUpdate) {
            this.needsNetworkUpdate = false;
            this.sendNetworkUpdate();
        }
    }

    protected void updateClientSide() {
    }

    protected void updateServerSide() {
    }

    protected final boolean updateOnInterval(int tickInterval) {
        return this.tickCount % tickInterval == 0;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inventory.readFromNBT(data);
        this.accessHandler.readFromNBT(data);
        this.orientation = data.func_74764_b("Orientation") ? ForgeDirection.values()[data.func_74762_e("Orientation")] : ForgeDirection.WEST;
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.inventory.writeToNBT(data);
        this.accessHandler.writeToNBT(data);
        data.func_74768_a("Orientation", this.orientation.ordinal());
    }

    public Packet func_145844_m() {
        PacketTileStream packet = new PacketTileStream(this);
        return packet.getPacket();
    }

    protected final void sendNetworkUpdate() {
        PacketTileStream packet = new PacketTileStream(this);
        Proxies.net.sendNetworkPacket(packet, this.field_145850_b);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeEnum((Enum)this.orientation, (Enum[])forgeDirections);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.orientation = (ForgeDirection)data.readEnum((Enum[])forgeDirections);
    }

    public void onRemoval() {
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerInternal> getInternalTriggers(IStatementContainer container) {
        return null;
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        return null;
    }

    protected boolean isRedstoneActivated() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ForgeDirection orientation) {
        if (orientation == null) {
            throw new NullPointerException("Orientation cannot be null");
        }
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.setNeedsNetworkUpdate();
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected final void setNeedsNetworkUpdate() {
        this.needsNetworkUpdate = true;
    }

    @Override
    public final IErrorLogic getErrorLogic() {
        return this.errorHandler;
    }

    @Override
    public final IAccessHandler getAccessHandler() {
        return this.accessHandler;
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        if (oldAccess == EnumAccess.SHARED || newAccess == EnumAccess.SHARED) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
            this.func_70296_d();
        }
    }

    @Override
    public String getUnlocalizedTitle() {
        String blockUnlocalizedName = this.func_145838_q().func_149739_a();
        return blockUnlocalizedName + '.' + this.func_145832_p() + ".name";
    }

    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    protected final void setInternalInventory(IInventoryAdapter inv) {
        if (inv == null) {
            throw new NullPointerException("Inventory cannot be null");
        }
        this.inventory = inv;
    }

    public final int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public final ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_70295_k_() {
        this.getInternalInventory().func_70295_k_();
    }

    public final void func_70305_f() {
        this.getInternalInventory().func_70305_f();
    }

    public final String func_145825_b() {
        return this.getUnlocalizedTitle();
    }

    public final boolean func_70300_a(EntityPlayer player) {
        return this.getInternalInventory().func_70300_a(player);
    }

    public final boolean func_145818_k_() {
        return this.getInternalInventory().func_145818_k_();
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    public final int[] func_94128_d(int side) {
        return this.getInternalInventory().func_94128_d(side);
    }

    public final boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        return this.getInternalInventory().func_102007_a(slotIndex, itemStack, side);
    }

    public final boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        return this.getInternalInventory().func_102008_b(slotIndex, itemStack, side);
    }

    @Override
    public final ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

