/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorSource;
import forestry.core.access.IRestrictedAccess;
import forestry.core.config.Config;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.IHintSource;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.ledgers.ClimateLedger;
import forestry.core.gui.ledgers.HintLedger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.gui.ledgers.OwnerLedger;
import forestry.core.gui.ledgers.PowerLedger;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.FontColour;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.IPowerHandler;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public abstract class GuiForestry<C extends Container, I extends IInventory>
extends GuiContainer
implements INEIGuiHandler {
    protected final I inventory;
    protected final C container;
    public final ResourceLocation textureFile;
    protected final WidgetManager widgetManager = new WidgetManager(this);
    protected LedgerManager ledgerManager;
    protected TextLayoutHelper textLayout;
    protected FontColour fontColor;

    protected GuiForestry(String texture, C container, I inventory) {
        this(new ResourceLocation("forestry", texture), container, inventory);
    }

    protected GuiForestry(ResourceLocation texture, C container, I inventory) {
        super(container);
        this.textureFile = texture;
        this.inventory = inventory;
        this.container = container;
        this.fontColor = new FontColour(Proxies.render.getSelectedTexturePack());
        this.textLayout = new TextLayoutHelper(this, this.fontColor);
    }

    public void func_146280_a(Minecraft minecraft, int width, int height) {
        super.func_146280_a(minecraft, width, height);
        this.textLayout.setFontRendererObj(this.field_146289_q);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxLedgerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        this.ledgerManager = new LedgerManager(this, maxLedgerWidth);
        this.addLedgers();
    }

    protected void addLedgers() {
        IHintSource hintSource;
        List<String> hints;
        if (this.inventory instanceof IErrorSource) {
            this.ledgerManager.add((IErrorSource)this.inventory);
        }
        if (this.inventory instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)this.inventory;
            this.ledgerManager.add(errorLogicSource.getErrorLogic());
        }
        if (this.inventory instanceof IClimatised) {
            this.ledgerManager.add(new ClimateLedger(this.ledgerManager, (IClimatised)this.inventory));
        }
        if (Config.enableEnergyStat && this.inventory instanceof IPowerHandler && ((IPowerHandler)this.inventory).getEnergyManager().getMaxEnergyStored() > 0) {
            this.ledgerManager.add(new PowerLedger(this.ledgerManager, (IPowerHandler)this.inventory));
        }
        if (Config.enableHints && this.inventory instanceof IHintSource && (hints = (hintSource = (IHintSource)this.inventory).getHints()) != null && hints.size() > 0) {
            this.ledgerManager.add(new HintLedger(this.ledgerManager, hintSource));
        }
        if (this.inventory instanceof IRestrictedAccess) {
            this.ledgerManager.add(new OwnerLedger(this.ledgerManager, (IRestrictedAccess)this.inventory));
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.ledgerManager.onGuiClosed();
    }

    public FontColour getFontColor() {
        return this.fontColor;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    protected void func_73864_a(int xPos, int yPos, int mouseButton) {
        super.func_73864_a(xPos, yPos, mouseButton);
        this.ledgerManager.handleMouseClicked(xPos, yPos, mouseButton);
        this.widgetManager.handleMouseClicked(xPos, yPos, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int eventType) {
        super.func_146286_b(mouseX, mouseY, eventType);
        this.widgetManager.handleMouseRelease(mouseX, mouseY, eventType);
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long time) {
        this.widgetManager.handleMouseMove(mouseX, mouseY, mouseButton, time);
        super.func_146273_a(mouseX, mouseY, mouseButton, time);
    }

    protected Slot func_146975_c(int par1, int par2) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.isMouseOverSlot(slot, par1, par2)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot par1Slot, int par2, int par3) {
        return this.func_146978_c(par1Slot.field_75223_e, par1Slot.field_75221_f, 16, 16, par2, par3);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GL11.glPushAttrib((int)8192);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.ledgerManager.drawTooltips(mouseX, mouseY);
        InventoryPlayer playerInv = this.field_146297_k.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o() == null) {
            GuiUtil.drawToolTips(this, this.widgetManager.getWidgets(), mouseX, mouseY);
            GuiUtil.drawToolTips(this, this.field_146292_n, mouseX, mouseY);
            GuiUtil.drawToolTips(this, this.field_147002_h.field_75151_b, mouseX, mouseY);
        }
        GL11.glPopAttrib();
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        this.bindTexture(this.textureFile);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        GL11.glPushAttrib((int)8192);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawWidgets();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        this.bindTexture(this.textureFile);
    }

    protected void drawWidgets() {
        this.ledgerManager.drawLedgers();
        this.widgetManager.drawWidgets();
    }

    protected void bindTexture(ResourceLocation texturePath) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Proxies.render.bindTexture(texturePath);
    }

    public void setZLevel(float level) {
        this.field_73735_i = level;
    }

    public static RenderItem getItemRenderer() {
        return field_146296_j;
    }

    public int getSizeX() {
        return this.field_146999_f;
    }

    public int getSizeY() {
        return this.field_147000_g;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public void func_73733_a(int par1, int par2, int par3, int par4, int par5, int par6) {
        super.func_73733_a(par1, par2, par3, par4, par5, par6);
    }

    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return Collections.emptyList();
    }

    @Optional.Method(modid="NotEnoughItems")
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        if (gui instanceof GuiForestry) {
            return ((GuiForestry)gui).ledgerManager.ledgerOverlaps(x, y, w, h);
        }
        return false;
    }
}

