/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllelePlantType;
import forestry.core.genetics.alleles.AlleleCategorized;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.common.EnumPlantType;

public class AllelePlantType
extends AlleleCategorized
implements IAllelePlantType {
    public static IAllelePlantType plantTypeNone;
    public static IAllelePlantType plantTypePlains;
    public static IAllelePlantType plantTypeDesert;
    public static IAllelePlantType plantTypeBeach;
    public static IAllelePlantType plantTypeCave;
    public static IAllelePlantType plantTypeWater;
    public static IAllelePlantType plantTypeNether;
    public static IAllelePlantType plantTypeCrop;
    private final EnumSet<EnumPlantType> types;

    public static void createAlleles() {
        plantTypeNone = new AllelePlantType("none", EnumSet.noneOf(EnumPlantType.class), true);
        List<IAllelePlantType> alleles = Arrays.asList(plantTypeNone, plantTypePlains = new AllelePlantType(EnumPlantType.Plains), plantTypeDesert = new AllelePlantType(EnumPlantType.Desert), plantTypeBeach = new AllelePlantType(EnumPlantType.Beach), plantTypeCave = new AllelePlantType(EnumPlantType.Cave), plantTypeWater = new AllelePlantType(EnumPlantType.Water), plantTypeNether = new AllelePlantType(EnumPlantType.Nether), plantTypeCrop = new AllelePlantType(EnumPlantType.Crop));
        for (IAllelePlantType allele : alleles) {
            AlleleManager.alleleRegistry.registerAllele(allele, EnumTreeChromosome.PLANT);
        }
    }

    protected AllelePlantType(EnumPlantType type) {
        this(type.toString().toLowerCase(Locale.ENGLISH), EnumSet.of(type), false);
    }

    protected AllelePlantType(String name, EnumSet<EnumPlantType> types, boolean isDominant) {
        super("forestry", "plantType", name, isDominant);
        this.types = types;
    }

    @Override
    public EnumSet<EnumPlantType> getPlantTypes() {
        return this.types;
    }
}

