/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CheckBox;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.render.ColorUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.ContainerNoInv;
import crazypants.enderio.machine.monitor.PacketPowerMonitor;
import crazypants.enderio.machine.monitor.TilePowerMonitor;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.NumberFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiPowerMonitor
extends GuiContainerBaseEIO {
    private static final NumberFormat INT_NF = NumberFormat.getIntegerInstance();
    private static final int ICON_SIZE = 16;
    private static final int SPACING = 6;
    private static final int MARGIN = 7;
    private static final int WIDTH = 210;
    private static final int HEIGHT = 146;
    private static final int POWER_X = 185;
    private static final int POWER_Y = 9;
    private static final int POWER_WIDTH = 10;
    private static final int POWER_HEIGHT = 130;
    protected static final int BOTTOM_POWER_Y = 139;
    private final TilePowerMonitor te;
    private boolean isRedstoneMode = false;
    private CheckBox enabledB;
    private TextFieldEnder startTF;
    private TextFieldEnder endTF;
    private String titleStr;
    private String engineTxt1;
    private String engineTxt2;
    private String engineTxt3;
    private String engineTxt4;
    private String engineTxt5;
    private String engineTxt6;
    private String monHeading1;
    private String monHeading2;
    private String monHeading3;
    private String monHeading4;
    private String monHeading5;
    private String noNetworkError;

    public GuiPowerMonitor(InventoryPlayer playerInv, final TilePowerMonitor te) {
        super(new ContainerNoInv(te), "powerMonitor");
        this.te = te;
        this.field_146999_f = 210;
        this.field_147000_g = 146;
        this.titleStr = EnderIO.lang.localize("gui.powerMonitor.engineControl");
        this.engineTxt1 = EnderIO.lang.localize("gui.powerMonitor.engineSection1");
        this.engineTxt2 = EnderIO.lang.localize("gui.powerMonitor.engineSection2");
        this.engineTxt3 = EnderIO.lang.localize("gui.powerMonitor.engineSection3");
        this.engineTxt4 = EnderIO.lang.localize("gui.powerMonitor.engineSection4");
        this.engineTxt5 = EnderIO.lang.localize("gui.powerMonitor.engineSection5");
        this.engineTxt6 = EnderIO.lang.localize("gui.powerMonitor.engineSection6");
        this.monHeading1 = EnderIO.lang.localize("gui.powerMonitor.monHeading1");
        this.monHeading2 = EnderIO.lang.localize("gui.powerMonitor.monHeading2");
        this.monHeading3 = EnderIO.lang.localize("gui.powerMonitor.monHeading3");
        this.monHeading4 = EnderIO.lang.localize("gui.powerMonitor.monHeading4");
        this.monHeading5 = EnderIO.lang.localize("gui.powerMonitor.monHeading5");
        this.noNetworkError = EnderIO.lang.localize("gui.powerMonitor.noNetworkError");
        this.addToolTip(new GuiToolTip(new Rectangle(185, 9, 10, 130), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(PowerDisplayUtil.formatPower(te.getEnergyStored()) + "/" + PowerDisplayUtil.formatPower(te.getMaxEnergyStored()) + " " + PowerDisplayUtil.abrevation());
            }
        });
        int x = 7 + Minecraft.func_71410_x().field_71466_p.func_78256_a(this.titleStr) + 6;
        this.enabledB = new CheckBox((IGuiScreen)this, 21267, x, 8);
        this.enabledB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.enabled")});
        this.enabledB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.disabled")});
        this.enabledB.setSelected(te.engineControlEnabled);
        x = 7 + this.getFontRenderer().func_78256_a(this.engineTxt2) + 4;
        int y = 39 + this.getFontRenderer().field_78288_b;
        this.startTF = new TextFieldEnder(this.getFontRenderer(), x, y, 28, 14);
        this.startTF.func_146205_d(true);
        this.startTF.func_146203_f(3);
        this.startTF.func_146189_e(false);
        this.startTF.func_146180_a(INT_NF.format(te.asPercentInt(te.startLevel)));
        y = y + this.getFontRenderer().field_78288_b + 16 + 16 + 4;
        x = 12 + this.getFontRenderer().func_78256_a(this.engineTxt5);
        this.endTF = new TextFieldEnder(this.getFontRenderer(), x, y, 28, 14);
        this.endTF.func_146205_d(true);
        this.endTF.func_146203_f(3);
        this.endTF.func_146189_e(false);
        this.endTF.func_146180_a(INT_NF.format(te.asPercentInt(te.stopLevel)));
        this.textFields.add(this.startTF);
        this.textFields.add(this.endTF);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        if (this.isRedstoneMode) {
            this.enabledB.onGuiInit();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public int getOverlayOffsetX() {
        return 0;
    }

    protected void func_73864_a(int x, int y, int par3) {
        super.func_73864_a(x, y, par3);
        y -= this.field_147009_r;
        if ((x -= this.field_147003_i) > 200 && x < 220) {
            if (y >= 6 && y < 30) {
                this.isRedstoneMode = false;
                this.enabledB.detach();
                this.startTF.func_146189_e(false);
                this.endTF.func_146189_e(false);
            } else if (y >= 36 && y < 60) {
                this.isRedstoneMode = true;
                this.enabledB.onGuiInit();
                this.startTF.func_146189_e(true);
                this.endTF.func_146189_e(true);
            }
        }
    }

    protected void func_146976_a(float ptick, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.te.getEnergyStoredScaled(130);
        this.func_73729_b(sx + 185, sy + 139 - i1, 245, 0, 10, i1);
        this.renderRedstoneTab(sx, sy);
        this.renderInfoTab(sx, sy);
        this.checkForModifications();
        super.func_146976_a(ptick, mouseX, mouseY);
    }

    private void checkForModifications() {
        if (this.enabledB.isSelected() != this.te.engineControlEnabled || this.getInt((GuiTextField)this.startTF) != this.te.asPercentInt(this.te.startLevel) || this.getInt((GuiTextField)this.endTF) != this.te.asPercentInt(this.te.stopLevel)) {
            this.te.engineControlEnabled = this.enabledB.isSelected();
            int i = this.getInt((GuiTextField)this.startTF);
            if (i >= 0) {
                this.te.startLevel = this.te.asPercentFloat(i);
            }
            if ((i = this.getInt((GuiTextField)this.endTF)) >= 0) {
                this.te.stopLevel = this.te.asPercentFloat(i);
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketPowerMonitor(this.te));
        }
    }

    private int getInt(GuiTextField tf) {
        String txt = tf.func_146179_b();
        if (txt == null) {
            return -1;
        }
        try {
            int val = Integer.parseInt(tf.func_146179_b());
            if (val >= 0 && val <= 100) {
                return val;
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private void renderRedstoneTab(int sx, int sy) {
        if (this.isRedstoneMode) {
            int left;
            IconEIO.map.render((IWidgetIcon)IconEIO.ACTIVE_TAB, (double)(sx + 200), (double)(sy + 30 + 6), true);
            field_146296_j.func_77015_a(this.field_146289_q, this.field_146297_k.field_71446_o, new ItemStack(Items.field_151137_ax), sx + 201, sy + 30 + 6 + 3);
            GL11.glDisable((int)2896);
            int x = left = this.field_147003_i + 7;
            int y = this.field_147009_r + 7 + 6;
            int rgb = !this.enabledB.isSelected() ? ColorUtil.getRGB((Color)Color.darkGray) : ColorUtil.getRGB((Color)Color.black);
            FontRenderer fontRenderer = this.getFontRenderer();
            fontRenderer.func_85187_a(this.titleStr, x, y, rgb, false);
            x = left + fontRenderer.func_78256_a(this.titleStr) + 6 + 16 + 6;
            y = this.field_147009_r + 14;
            if (!this.enabledB.isSelected()) {
                rgb = ColorUtil.getRGB((Color)Color.darkGray);
                this.enabledB.func_146112_a(this.field_146297_k, this.field_147003_i, this.field_147009_r);
            } else {
                rgb = ColorUtil.getRGB((Color)Color.black);
            }
            this.enabledB.func_146112_a(this.field_146297_k, this.field_147003_i, this.field_147009_r);
            x = left;
            String txt = this.engineTxt1;
            fontRenderer.func_85187_a(txt, x, y += 22, rgb, false);
            x = left;
            txt = this.engineTxt2;
            fontRenderer.func_85187_a(txt, x, y += 6 + fontRenderer.field_78288_b, rgb, false);
            x = left + fontRenderer.func_78256_a(txt) + 6 + this.startTF.func_146200_o() + 12;
            txt = this.engineTxt3;
            fontRenderer.func_85187_a(txt, x, y, rgb, false);
            x = left;
            txt = this.engineTxt4;
            fontRenderer.func_85187_a(txt, x, y += 16 + fontRenderer.field_78288_b + 6, rgb, false);
            x = left;
            txt = this.engineTxt5;
            fontRenderer.func_85187_a(txt, x, y += 6 + fontRenderer.field_78288_b, rgb, false);
            x += fontRenderer.func_78256_a(txt);
            txt = this.engineTxt3;
            fontRenderer.func_85187_a(txt, x += 7 + this.endTF.func_146200_o() + 10, y, rgb, false);
        } else {
            IconEIO.map.render((IWidgetIcon)IconEIO.INACTIVE_TAB, (double)(sx + 200), (double)(sy + 30 + 6), true);
            field_146296_j.func_77015_a(this.field_146289_q, this.field_146297_k.field_71446_o, new ItemStack(Items.field_151137_ax), sx + 201, sy + 30 + 6 + 3);
        }
    }

    private void renderInfoTab(int sx, int sy) {
        if (!this.isRedstoneMode) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            IconEIO.map.render((IWidgetIcon)IconEIO.ACTIVE_TAB, (double)(sx + 200), (double)(sy + 6), true);
            int headingCol = ColorUtil.getRGB((Color)Color.white);
            int valuesCol = ColorUtil.getRGB((Color)Color.black);
            int x = this.field_147003_i + 7;
            int y = this.field_147009_r + 7;
            int sectionGap = 6;
            FontRenderer fontRenderer = this.getFontRenderer();
            if (this.te.maxPowerInConduits == 0) {
                fontRenderer.func_78279_b(this.noNetworkError, x, y, 170, ColorUtil.getRGB((Color)Color.red));
                return;
            }
            int rgb = headingCol;
            StringBuilder sb = new StringBuilder();
            sb.append(this.monHeading1);
            fontRenderer.func_85187_a(sb.toString(), x, y, rgb, true);
            rgb = valuesCol;
            y += fontRenderer.field_78288_b + 2;
            sb = new StringBuilder();
            sb.append(PowerDisplayUtil.formatPower(this.te.powerInConduits));
            sb.append(" ");
            sb.append(PowerDisplayUtil.ofStr());
            sb.append(" ");
            sb.append(PowerDisplayUtil.formatPower(this.te.maxPowerInConduits));
            sb.append(" ");
            sb.append(PowerDisplayUtil.abrevation());
            fontRenderer.func_85187_a(sb.toString(), x, y, rgb, false);
            rgb = headingCol;
            sb = new StringBuilder();
            sb.append(this.monHeading2);
            fontRenderer.func_85187_a(sb.toString(), x, y += fontRenderer.field_78288_b + sectionGap, rgb, true);
            rgb = valuesCol;
            y += fontRenderer.field_78288_b + 2;
            sb = new StringBuilder();
            sb.append(PowerDisplayUtil.formatPower(this.te.powerInCapBanks));
            sb.append(" ");
            sb.append(PowerDisplayUtil.ofStr());
            sb.append(" ");
            sb.append(PowerDisplayUtil.formatPower(this.te.maxPowerInCapBanks));
            sb.append(" ");
            sb.append(PowerDisplayUtil.abrevation());
            fontRenderer.func_85187_a(sb.toString(), x, y, rgb, false);
            rgb = headingCol;
            sb = new StringBuilder();
            sb.append(this.monHeading3);
            fontRenderer.func_85187_a(sb.toString(), x, y += fontRenderer.field_78288_b + sectionGap, rgb, true);
            rgb = valuesCol;
            y += fontRenderer.field_78288_b + 2;
            sb = new StringBuilder();
            sb.append(PowerDisplayUtil.formatPower(this.te.powerInMachines));
            sb.append(" ");
            sb.append(PowerDisplayUtil.ofStr());
            sb.append(" ");
            sb.append(PowerDisplayUtil.formatPower(this.te.maxPowerInMachines));
            sb.append(" ");
            sb.append(PowerDisplayUtil.abrevation());
            fontRenderer.func_85187_a(sb.toString(), x, y, rgb, false);
            rgb = headingCol;
            sb = new StringBuilder();
            sb.append(this.monHeading4);
            fontRenderer.func_85187_a(sb.toString(), x, y += fontRenderer.field_78288_b + sectionGap, rgb, true);
            rgb = valuesCol;
            y += fontRenderer.field_78288_b + 2;
            sb = new StringBuilder();
            sb.append(PowerDisplayUtil.formatPowerFloat(this.te.aveRfSent));
            sb.append(" ");
            sb.append(PowerDisplayUtil.abrevation());
            sb.append(PowerDisplayUtil.perTickStr());
            fontRenderer.func_85187_a(sb.toString(), x, y, rgb, false);
            rgb = headingCol;
            sb = new StringBuilder();
            sb.append(this.monHeading5);
            fontRenderer.func_85187_a(sb.toString(), x, y += fontRenderer.field_78288_b + sectionGap, rgb, true);
            rgb = valuesCol;
            y += fontRenderer.field_78288_b + 2;
            sb = new StringBuilder();
            sb.append(PowerDisplayUtil.formatPowerFloat(this.te.aveRfReceived));
            sb.append(" ");
            sb.append(PowerDisplayUtil.abrevation());
            sb.append(PowerDisplayUtil.perTickStr());
            fontRenderer.func_85187_a(sb.toString(), x, y, rgb, false);
        } else {
            IconEIO.map.render((IWidgetIcon)IconEIO.INACTIVE_TAB, (double)(sx + 200), (double)(sy + 6), true);
        }
    }
}

