/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.CycleButton;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.PacketRedstoneMode;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.network.PacketHandler;

public class RedstoneModeButton
extends CycleButton<RedstoneControlMode> {
    private IRedstoneModeControlable model;
    private BlockCoord bc;
    private String tooltipKey = "enderio.gui.tooltip.redstoneControlMode";

    public RedstoneModeButton(IGuiScreen gui, int id, int x, int y, IRedstoneModeControlable model) {
        this(gui, id, x, y, model, null);
    }

    public RedstoneModeButton(IGuiScreen gui, int id, int x, int y, IRedstoneModeControlable model, BlockCoord bc) {
        super(gui, id, x, y, RedstoneControlMode.class);
        this.model = model;
        this.bc = bc;
        this.setMode(model.getRedstoneControlMode());
    }

    public void setMode(RedstoneControlMode newMode) {
        if (this.model == null) {
            return;
        }
        super.setMode((Enum)newMode);
        this.model.setRedstoneControlMode((RedstoneControlMode)this.getMode());
        if (this.bc != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRedstoneMode(this.model, this.bc.x, this.bc.y, this.bc.z));
        }
        this.setTooltipKey(this.tooltipKey);
    }

    public void setTooltipKey(String key) {
        this.tooltipKey = key;
        this.setToolTip(new String[]{EnderIO.lang.localizeExact(this.tooltipKey), ((RedstoneControlMode)this.getMode()).getTooltip()});
    }
}

