/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power.endergy;

import com.enderio.core.client.render.IconUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.power.PowerConduit;
import crazypants.enderio.config.Config;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class PowerConduitEndergy
extends PowerConduit {
    static final Map<String, IIcon> ICONS = new HashMap<String, IIcon>();
    private static ICapacitor[] capacitors;
    static final String[] POSTFIX;

    static ICapacitor[] getCapacitors() {
        if (capacitors == null) {
            capacitors = new BasicCapacitor[]{new BasicCapacitor(Config.powerConduitEndergyTiers[0]), new BasicCapacitor(Config.powerConduitEndergyTiers[1]), new BasicCapacitor(Config.powerConduitEndergyTiers[2]), new BasicCapacitor(Config.powerConduitEndergyTiers[3]), new BasicCapacitor(Config.powerConduitEndergyTiers[4]), new BasicCapacitor(Config.powerConduitEndergyTiers[5]), new BasicCapacitor(Config.powerConduitEndergyTiers[6]), new BasicCapacitor(Config.powerConduitEndergyTiers[7]), new BasicCapacitor(Config.powerConduitEndergyTiers[8]), new BasicCapacitor(Config.powerConduitEndergyTiers[9]), new BasicCapacitor(Config.powerConduitEndergyTiers[10]), new BasicCapacitor(Config.powerConduitEndergyTiers[11])};
        }
        return capacitors;
    }

    static ItemStack createItemStackForSubtype(int subtype) {
        ItemStack result = new ItemStack((Item)EnderIO.itemPowerConduitEndergy, 1, subtype);
        return result;
    }

    public static void initIcons() {
        PowerConduitEndergy.initIcons(POSTFIX, ICONS);
    }

    public PowerConduitEndergy() {
    }

    public PowerConduitEndergy(int meta) {
        super(meta);
    }

    @Override
    public ICapacitor getCapacitor() {
        return PowerConduitEndergy.getCapacitors()[this.getSubtype()];
    }

    @Override
    public ItemStack createItem() {
        return PowerConduitEndergy.createItemStackForSubtype(this.getSubtype());
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return ICONS.get("enderio:powerConduitCore" + POSTFIX[this.getSubtype()]);
        }
        if ("ColorController".equals(component.data)) {
            return IconUtil.whiteTexture;
        }
        return ICONS.get("enderio:powerConduit" + POSTFIX[this.getSubtype()]);
    }

    @Override
    public IIcon getTextureForInputMode() {
        return ICONS.get("enderio:powerConduitInput" + POSTFIX[this.getSubtype()]);
    }

    @Override
    public IIcon getTextureForOutputMode() {
        return ICONS.get("enderio:powerConduitOutput" + POSTFIX[this.getSubtype()]);
    }

    @Override
    public int getMaxEnergyStored() {
        return PowerConduitEndergy.getCapacitors()[this.getSubtype()].getMaxEnergyStored();
    }

    static {
        POSTFIX = new String[]{"Crude", "Iron", "Aluminum", "Gold", "Copper", "Silver", "Electrum", "EnergeticSilver", "Crystalline", "CrystallinePinkSlime", "Melodic", "Stellar"};
    }
}

