/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.common.util.FluidUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidFilter {
    private final FluidStack[] fluids = new FluidStack[5];
    private boolean isBlacklist;

    public boolean isEmpty() {
        for (FluidStack f : this.fluids) {
            if (f == null) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.fluids.length;
    }

    @Deprecated
    public Fluid getFluidAt(int index) {
        return this.fluids[index].getFluid();
    }

    public FluidStack getFluidStackAt(int index) {
        return this.fluids[index];
    }

    @Deprecated
    public boolean setFluid(int index, Fluid fluid) {
        this.fluids[index] = new FluidStack(fluid, 0);
        return true;
    }

    public boolean setFluid(int index, FluidStack fluid) {
        this.fluids[index] = fluid == null || fluid.getFluid() == null ? null : fluid;
        return true;
    }

    public boolean setFluid(int index, ItemStack stack) {
        if (stack == null) {
            return this.setFluid(index, (FluidStack)null);
        }
        FluidStack f = FluidUtil.getFluidFromItem((ItemStack)stack);
        if (f == null || f.getFluid() == null) {
            return false;
        }
        return this.setFluid(index, f);
    }

    public boolean removeFluid(int index) {
        if (index < 0 || index >= this.fluids.length) {
            return false;
        }
        this.fluids[index] = null;
        return true;
    }

    @Deprecated
    protected void setFluid(int index, String fluidName) {
        Fluid f = FluidRegistry.getFluid((String)fluidName);
        this.setFluid(index, f);
    }

    public boolean isBlacklist() {
        return this.isBlacklist;
    }

    public void setBlacklist(boolean isBlacklist) {
        this.isBlacklist = isBlacklist;
    }

    public boolean isDefault() {
        return !this.isBlacklist && this.isEmpty();
    }

    public void writeToNBT(NBTTagCompound root) {
        root.func_74757_a("isBlacklist", this.isBlacklist);
        if (this.isEmpty()) {
            root.func_82580_o("fluidFilter");
            return;
        }
        NBTTagList fluidList = new NBTTagList();
        int index = 0;
        for (FluidStack f : this.fluids) {
            if (f != null) {
                NBTTagCompound fRoot = new NBTTagCompound();
                fRoot.func_74768_a("index", index);
                f.writeToNBT(fRoot);
                fluidList.func_74742_a((NBTBase)fRoot);
            }
            ++index;
        }
        root.func_74782_a("fluidStackFilter", (NBTBase)fluidList);
    }

    public void readFromNBT(NBTTagCompound root) {
        this.isBlacklist = root.func_74767_n("isBlacklist");
        if (root.func_74764_b("fluidFilter")) {
            NBTTagList fluidList = (NBTTagList)root.func_74781_a("fluidFilter");
            for (int i = 0; i < fluidList.func_74745_c(); ++i) {
                NBTTagCompound fRoot = fluidList.func_150305_b(i);
                this.setFluid(fRoot.func_74762_e("index"), fRoot.func_74779_i("fluidName"));
            }
        } else if (root.func_74764_b("fluidStackFilter")) {
            NBTTagList fluidList = (NBTTagList)root.func_74781_a("fluidStackFilter");
            for (int i = 0; i < fluidList.func_74745_c(); ++i) {
                NBTTagCompound fRoot = fluidList.func_150305_b(i);
                this.setFluid(fRoot.func_74762_e("index"), FluidStack.loadFluidStackFromNBT((NBTTagCompound)fRoot));
            }
        } else {
            this.clear();
            return;
        }
    }

    private void clear() {
        for (int i = 0; i < this.fluids.length; ++i) {
            this.fluids[i] = null;
        }
    }

    public boolean matchesFilter(FluidStack drained) {
        if (drained == null || drained.getFluid() == null) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        for (FluidStack f : this.fluids) {
            if (f == null || !f.isFluidEqual(drained)) continue;
            return !this.isBlacklist;
        }
        return this.isBlacklist;
    }
}

