/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.IConduitItem;
import crazypants.enderio.conduit.ItemConduitSubtype;
import crazypants.enderio.conduit.MicroblocksUtil;
import crazypants.enderio.conduit.TileConduitBundle;
import java.util.List;
import mods.immibis.microblocks.api.IMicroblockCoverSystem;
import mods.immibis.microblocks.api.IMicroblockSupporterTile;
import mods.immibis.microblocks.api.MicroblockAPIUtils;
import mods.immibis.microblocks.api.Part;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractItemConduit
extends Item
implements IConduitItem {
    protected ModObject modObj;
    protected ItemConduitSubtype[] subtypes;
    protected IIcon[] icons;

    protected AbstractItemConduit(ModObject modObj, ItemConduitSubtype ... subtypes) {
        this.modObj = modObj;
        this.subtypes = subtypes;
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(modObj.unlocalisedName);
        this.func_77625_d(64);
        this.func_77627_a(true);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)this.modObj.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IIconRegister2) {
        this.icons = new IIcon[this.subtypes.length];
        int index = 0;
        for (ItemConduitSubtype subtype : this.subtypes) {
            this.icons[index] = IIconRegister2.func_94245_a(subtype.iconKey);
            ++index;
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (MicroblocksUtil.supportMicroblocks() && this.tryAddToMicroblocks(stack, player, world, x, y, z, side)) {
            return true;
        }
        BlockCoord placeAt = Util.canPlaceItem((ItemStack)stack, (Block)EnderIO.blockConduitBundle, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z, (int)side);
        if (placeAt != null) {
            TileEntity te;
            if (!world.field_72995_K && world.func_147465_d(placeAt.x, placeAt.y, placeAt.z, (Block)EnderIO.blockConduitBundle, 0, 1) && (te = world.func_147438_o(placeAt.x, placeAt.y, placeAt.z)) instanceof IConduitBundle) {
                IConduitBundle bundle = (IConduitBundle)te;
                bundle.addConduit(this.createConduit(stack, player));
                ConduitUtil.playBreakSound(Block.field_149777_j, world, placeAt.x, placeAt.y, placeAt.z);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        ForgeDirection dir = ForgeDirection.values()[side];
        int placeX = x + dir.offsetX;
        int placeY = y + dir.offsetY;
        int placeZ = z + dir.offsetZ;
        if (world.func_147439_a(placeX, placeY, placeZ) == EnderIO.blockConduitBundle) {
            TileConduitBundle bundle = (TileConduitBundle)world.func_147438_o(placeX, placeY, placeZ);
            if (bundle == null) {
                System.out.println("AbstractItemConduit.onItemUse: Bundle null");
                return false;
            }
            if (!bundle.hasType(this.getBaseConduitType())) {
                if (!world.field_72995_K) {
                    IConduit con = this.createConduit(stack, player);
                    if (con == null) {
                        System.out.println("AbstractItemConduit.onItemUse: Conduit null.");
                        return false;
                    }
                    bundle.addConduit(con);
                    ConduitUtil.playBreakSound(Block.field_149777_j, world, placeX, placeY, placeZ);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean tryAddToMicroblocks(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te.getClass().getName().equals("mods.immibis.microblocks.TileMicroblockContainer")) {
            IMicroblockCoverSystem covers = ((IMicroblockSupporterTile)te).getCoverSystem();
            world.func_147449_b(x, y, z, (Block)EnderIO.blockConduitBundle);
            EnderIO.blockConduitBundle.func_149727_a(world, x, y, z, player, side, 0.0f, 0.0f, 0.0f);
            IMicroblockCoverSystem newCovers = MicroblockAPIUtils.createMicroblockCoverSystem((IMicroblockSupporterTile)((IMicroblockSupporterTile)world.func_147438_o(x, y, z)));
            for (Part p : covers.getAllParts()) {
                newCovers.addPart(p);
            }
            ((TileConduitBundle)world.func_147438_o((int)x, (int)y, (int)z)).covers = newCovers;
            return true;
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof IConduitBundle)) {
            return false;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        Object existingConduit = bundle.getConduit(this.getBaseConduitType());
        if (existingConduit == null) {
            return false;
        }
        ItemStack existingConduitAsItemStack = existingConduit.createItem();
        if (!ItemUtil.areStacksEqual((ItemStack)existingConduitAsItemStack, (ItemStack)stack)) {
            if (!world.field_72995_K) {
                IConduit newConduit = this.createConduit(stack, player);
                if (newConduit == null) {
                    System.out.println("AbstractItemConduit.onItemUse: Conduit null.");
                    return false;
                }
                bundle.removeConduit((IConduit)existingConduit);
                bundle.addConduit(newConduit);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                    for (ItemStack drop : existingConduit.getDrops()) {
                        if (player.field_71071_by.func_70441_a(drop)) continue;
                        ItemUtil.spawnItemInWorldWithRandomMotion((World)world, (ItemStack)drop, (int)x, (int)y, (int)z);
                    }
                    player.field_71069_bz.func_75142_b();
                }
                return true;
            }
            player.func_71038_i();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        damage = MathHelper.func_76125_a((int)damage, (int)0, (int)(this.subtypes.length - 1));
        return this.icons[damage];
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        int i = MathHelper.func_76125_a((int)par1ItemStack.func_77960_j(), (int)0, (int)(this.subtypes.length - 1));
        return this.subtypes[i].unlocalisedName;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < this.subtypes.length; ++j) {
            par3List.add(new ItemStack((Item)this, 1, j));
        }
    }
}

