/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.gitlab.cdagaming.craftpresence.core.config.element.ColorData;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.DynamicWidget;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1600;
import net.minecraft.class_356;
import net.minecraft.class_370;
import net.minecraft.class_372;
import net.minecraft.class_388;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ExtendedScreen
extends class_388 {
    private static int lastIndex = 0;
    public final class_388 parentScreen;
    public final class_388 currentScreen;
    private final List<class_372> extendedControls = StringUtils.newArrayList();
    private final List<DynamicWidget> extendedWidgets = StringUtils.newArrayList();
    private final List<ScrollableListControl> extendedLists = StringUtils.newArrayList();
    private Phase currentPhase = Phase.PREINIT;
    private boolean debugMode = false;
    private boolean verboseMode = false;
    private int screenX = 0;
    private int screenY = 0;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private int lastMouseScroll = 0;
    private int contentHeight;
    private boolean canClose;
    private boolean isOverScreen;

    public ExtendedScreen(class_388 parentScreen) {
        this.setGameInstance(CraftPresence.instance);
        this.currentScreen = this;
        this.parentScreen = parentScreen;
        this.canClose = true;
        this.setContentHeight(0);
        this.setDebugMode(CommandUtils.isDebugMode());
        this.setVerboseMode(CommandUtils.isVerboseMode());
    }

    public ExtendedScreen() {
        this(null);
        this.canClose = false;
    }

    public ExtendedScreen(class_388 parentScreen, boolean debugMode) {
        this(parentScreen);
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(boolean debugMode) {
        this();
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(class_388 parentScreen, boolean debugMode, boolean verboseMode) {
        this(parentScreen, debugMode);
        this.setVerboseMode(verboseMode);
    }

    public ExtendedScreen(boolean debugMode, boolean verboseMode) {
        this(debugMode);
        this.setVerboseMode(verboseMode);
    }

    public static int getNextIndex() {
        return lastIndex++;
    }

    public static void resetIndex() {
        lastIndex = 0;
    }

    public void method_1044() {
        super.method_1044();
        this.clearData();
        Keyboard.enableRepeatEvents((boolean)true);
        this.currentPhase = Phase.INIT;
        this.initializeUi();
        this.currentPhase = Phase.READY;
    }

    public void clearData() {
        if (this.currentPhase != Phase.PREINIT) {
            this.currentPhase = Phase.PREINIT;
            this.setContentHeight(0);
            this.field_1232.clear();
            this.extendedControls.clear();
            this.extendedWidgets.clear();
            this.extendedLists.clear();
        }
    }

    public void initializeUi() {
        if (this.currentPhase == Phase.PREINIT) {
            this.method_1044();
            return;
        }
        if (this.currentPhase == Phase.INIT) {
            this.resetMouseScroll();
            for (class_372 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).initializeUi();
            }
            this.refreshContentHeight();
        }
    }

    public void reloadUi() {
        this.method_1028(this.getGameInstance(), this.getScreenWidth(), this.getScreenHeight());
    }

    public void method_1028(@Nonnull class_1600 mcIn, int w, int h) {
        if (this.isLoaded()) {
            for (class_372 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).method_1028(mcIn, w, h);
            }
        }
        super.method_1028(mcIn, w, h);
    }

    @Nonnull
    public <T extends class_372> T addControl(@Nonnull T buttonIn) {
        if (buttonIn instanceof DynamicWidget && !this.extendedWidgets.contains(buttonIn)) {
            this.addWidget((DynamicWidget)buttonIn);
        }
        if (buttonIn instanceof class_356 && !this.field_1232.contains(buttonIn)) {
            this.field_1232.add((class_356)buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends ScrollableListControl> T addList(@Nonnull T buttonIn) {
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends DynamicWidget> T addWidget(@Nonnull T buttonIn) {
        if (!this.extendedWidgets.contains(buttonIn)) {
            buttonIn.setControlPosY(this.getTop() + buttonIn.getTop());
            this.extendedWidgets.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        RenderUtils.drawBackground(this.getGameInstance(), this.getLeft(), this.getRight(), this.getTop(), this.getBottom(), this.getOffset(), this.getTintFactor(), this.getScreenBackground());
    }

    public boolean hasWorld() {
        return this.getGameInstance().field_3803 != null;
    }

    public ColorData getRawBackground() {
        return this.hasWorld() ? CraftPresence.CONFIG.accessibilitySettings.worldGuiBackground : CraftPresence.CONFIG.accessibilitySettings.guiBackground;
    }

    public float getTintFactor() {
        return 1.0f;
    }

    public ColorData getScreenBackground() {
        ColorData data = this.getRawBackground();
        if (!this.hasWorld()) {
            data.getStart().alpha = 255;
            data.getEnd().alpha = 255;
        }
        return data;
    }

    public double getOffset() {
        return 0.0;
    }

    public void preRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.preDraw(this);
        }
    }

    public void renderExtra() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.draw(this);
        }
    }

    public void postRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.postDraw(this);
        }
    }

    public void copyToClipboard(String input) {
        ExtendedScreen.method_1036((String)StringUtils.normalize(input));
    }

    public void method_1031(int tint) {
        this.renderCriticalData();
    }

    public void method_1025(int mouseX, int mouseY, float partialTicks) {
        if (this.isLoaded()) {
            this.preRender();
            int scale = this.computeGuiScale();
            RenderUtils.drawWithin(this.getLeft() * scale, this.getGameInstance().field_3802 - this.getBottom() * scale, this.getScreenWidth() * scale, this.getScreenHeight() * scale);
            this.method_1043();
            for (ScrollableListControl listControl : this.getLists()) {
                if (!listControl.method_6710()) continue;
                listControl.method_1053(mouseX, mouseY, partialTicks);
            }
            super.method_1025(mouseX, mouseY, partialTicks);
            for (class_372 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_937();
            }
            this.renderExtra();
            RenderUtils.drawAnywhere();
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.isOverScreen = RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this);
            for (class_372 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).method_1025(mouseX, mouseY, partialTicks);
            }
            this.postRender();
        }
    }

    public void method_1035() {
        if (this.isLoaded()) {
            this.setMouseScroll(Mouse.getEventDWheel());
            int dw = this.getMouseScroll();
            if (dw != 0) {
                this.mouseScrolled(this.getMouseX(), this.getMouseY(), (int)((double)dw / 60.0));
            }
            super.method_1035();
        }
    }

    public void mouseScrolled(int mouseX, int mouseY, int wheelY) {
        if (this.isLoaded()) {
            for (class_372 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).mouseScrolled(mouseX, mouseY, wheelY);
            }
        }
    }

    protected void method_1027(@Nonnull class_356 button) {
        if (this.isOverScreen()) {
            if (button instanceof ExtendedButtonControl) {
                ((ExtendedButtonControl)button).onClick();
            }
            super.method_1027(button);
        }
    }

    protected void method_1024(char typedChar, int keyCode) {
        if (this.isLoaded()) {
            if (keyCode == 1 && this.canClose) {
                this.openScreen(this.parentScreen);
                return;
            }
            for (class_372 extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.method_917(typedChar, keyCode);
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).method_1024(typedChar, keyCode);
            }
        }
    }

    protected void method_1026(int mouseX, int mouseY, int mouseButton) {
        if (this.isLoaded()) {
            for (class_372 extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.method_920(mouseX, mouseY, mouseButton);
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).method_1026(mouseX, mouseY, mouseButton);
            }
            super.method_1026(mouseX, mouseY, mouseButton);
        }
    }

    protected void method_4259(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        if (this.isLoaded()) {
            for (class_372 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).method_4259(mouseX, mouseY, mouseButton, timeSinceLastClick);
            }
            super.method_4259(mouseX, mouseY, mouseButton, timeSinceLastClick);
        }
    }

    protected void method_1032(int mouseX, int mouseY, int state) {
        if (this.isLoaded()) {
            for (class_372 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).method_1032(mouseX, mouseY, state);
            }
            super.method_1032(mouseX, mouseY, state);
        }
    }

    public void method_1033() {
        if (this.isLoaded()) {
            for (class_372 extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.method_916();
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).method_1033();
            }
            super.method_1033();
        }
    }

    public void method_1030() {
        if (this.isLoaded()) {
            for (class_372 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).method_1030();
            }
            this.clearData();
            ExtendedScreen.resetIndex();
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    public class_1600 getGameInstance() {
        return this.field_1229;
    }

    public void setGameInstance(class_1600 instance) {
        this.field_1229 = instance;
    }

    public void openScreen(class_388 targetScreen) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen);
    }

    public int computeGuiScale() {
        return RenderUtils.computeGuiScale(this.getGameInstance());
    }

    public int getButtonY(int order) {
        return 40 + 25 * (order - 1);
    }

    public int getButtonY(int order, int offset, boolean appendByOrder) {
        return this.getButtonY(order) + offset * (appendByOrder ? order : 1);
    }

    public int getButtonY(int order, int offset) {
        return this.getButtonY(order, offset, false);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY) {
        RenderUtils.drawMultiLineString(this.getGameInstance(), textToInput, posX, posY, this.getScreenWidth(), this.getScreenHeight(), this.getWrapWidth(), this.getFontRenderer(), new Tuple<Boolean, ColorData, ColorData>(CraftPresence.CONFIG.accessibilitySettings.renderTooltips, CraftPresence.CONFIG.accessibilitySettings.tooltipBackground, CraftPresence.CONFIG.accessibilitySettings.tooltipBorder));
    }

    public void drawMultiLineString(List<String> textToInput) {
        this.drawMultiLineString(textToInput, this.getMouseX(), this.getMouseY());
    }

    public void renderNotice(List<String> notice) {
        this.renderNotice(notice, 2.0f, 3.0f);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale) {
        this.renderNotice(notice, widthScale, heightScale, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale, boolean useXAsActual, boolean useYAsActual) {
        if (notice != null && !notice.isEmpty()) {
            for (int i = 0; i < notice.size(); ++i) {
                String string = notice.get(i);
                this.renderString(string, (useXAsActual ? widthScale : (float)this.getScreenWidth() / widthScale) - (float)this.getStringWidth(string) / widthScale, (useYAsActual ? heightScale : (float)this.getScreenHeight() / heightScale) + (float)(i * 10), 0xFFFFFF);
            }
        }
    }

    public void renderCenteredString(String text, float xPos, float yPos, int color) {
        this.renderString(text, xPos - (float)this.getStringWidth(text) / 2.0f, yPos, color);
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        this.getFontRenderer().method_956(text, Math.round(xPos), Math.round(yPos), color);
    }

    public int getStringWidth(String string) {
        return this.getFontRenderer().method_954(string);
    }

    public List<String> createRenderLines(List<String> original, int wrapWidth) {
        List<String> data = StringUtils.newArrayList();
        for (String line : original) {
            data.addAll(RenderUtils.listFormattedStringToWidth(this.getFontRenderer(), line, wrapWidth));
        }
        return data;
    }

    public List<String> createRenderLines(String original, int wrapWidth) {
        return this.createRenderLines(StringUtils.splitTextByNewLine(original, true), wrapWidth);
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public void setScreenX(int screenX) {
        this.screenX = screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public void setScreenY(int screenY) {
        this.screenY = screenY;
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public int getMouseScroll() {
        return this.lastMouseScroll;
    }

    public void setMouseScroll(int mouseScroll) {
        this.lastMouseScroll = mouseScroll;
    }

    public void resetMouseScroll() {
        this.setMouseScroll(0);
    }

    public int getMaxWidth() {
        return this.getScreenWidth();
    }

    public int getScreenWidth() {
        return this.field_1230;
    }

    public void setScreenWidth(int screenWidth) {
        this.field_1230 = screenWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
    }

    public void refreshContentHeight() {
        this.setContentHeight(0);
        for (DynamicWidget widget : this.getWidgets()) {
            int widgetHeight = widget.getBottom();
            if (widgetHeight <= this.getContentHeight()) continue;
            this.setContentHeight(widgetHeight);
        }
    }

    public int getScreenHeight() {
        return this.field_1231;
    }

    public void setScreenHeight(int screenHeight) {
        this.field_1231 = screenHeight;
    }

    public class_370 getFontRenderer() {
        return this.getGameInstance().field_3814 != null ? this.getGameInstance().field_3814 : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        return this.getFontRenderer().field_1141;
    }

    public int getLeft() {
        return this.getScreenX();
    }

    public int getRight() {
        return this.getScreenX() + this.getScreenWidth();
    }

    public int getBottom() {
        return this.getScreenY() + this.getScreenHeight();
    }

    public int getTop() {
        return this.getScreenY();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.debugMode = isDebugMode;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(boolean isVerboseMode) {
        this.verboseMode = isVerboseMode;
    }

    public List<class_372> getControls() {
        return StringUtils.newArrayList(this.extendedControls);
    }

    public List<DynamicWidget> getWidgets() {
        return StringUtils.newArrayList(this.extendedWidgets);
    }

    public List<ScrollableListControl> getLists() {
        return StringUtils.newArrayList(this.extendedLists);
    }

    public boolean isLoaded() {
        return this.currentPhase == Phase.READY;
    }

    public static enum Phase {
        PREINIT,
        INIT,
        READY;

    }
}

