/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.utils;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class TranslationUtils {
    private final Map<String, Map<String, String>> requestMap = StringUtils.newHashMap();
    private String defaultLanguageId;
    private String languageId = this.defaultLanguageId = Constants.MCBuildProtocol >= 315 ? "en_us" : "en_US";
    private String modId;
    private String encoding;
    private boolean usingJson = false;
    private boolean usingAssetsPath = true;
    private boolean stripColors = false;
    private BiFunction<String, String, List<InputStream>> resourceSupplier = (id, langPath) -> StringUtils.newArrayList();
    private Function<String, String> languageSupplier = fallback -> fallback;
    private boolean needsSync;

    public TranslationUtils() {
        this(false);
    }

    public TranslationUtils(boolean useJson) {
        this("", useJson);
    }

    public TranslationUtils(String modId) {
        this(modId, false);
    }

    public TranslationUtils(String modId, boolean useJson) {
        this(modId, useJson, "UTF-8");
    }

    public TranslationUtils(String modId, boolean useJson, String encoding) {
        this.setUsingJson(useJson);
        this.setModId(modId);
        this.setEncoding(encoding);
    }

    public static String convertId(String originalId, int protocol, ConversionMode mode) {
        String resultId = originalId;
        if (originalId.length() == 5 && originalId.contains("_")) {
            if (mode == ConversionMode.PackFormat2 || mode == ConversionMode.None && protocol < 315) {
                resultId = resultId.substring(0, 3).toLowerCase() + resultId.substring(3).toUpperCase();
            } else if (mode == ConversionMode.PackFormat3 || mode == ConversionMode.None) {
                resultId = resultId.toLowerCase();
            }
        }
        if (resultId.equals(originalId) && mode != ConversionMode.None) {
            Constants.LOG.debugWarn(Constants.TRANSLATOR.translate("craftpresence.logger.warning.convert.invalid", resultId, mode.name()), new Object[0]);
        }
        return resultId.trim();
    }

    public String getLocalizedMessage(String original) {
        String result = original.trim();
        if (result.contains(" ")) {
            String adjusted = result;
            for (String dataPart : result.split(" ")) {
                if (!this.hasTranslation(dataPart)) continue;
                adjusted = adjusted.replace(dataPart, this.translate(dataPart, new Object[0]));
            }
            result = adjusted;
        } else if (this.hasTranslation(original)) {
            result = this.translate(result, new Object[0]);
        }
        return result;
    }

    public TranslationUtils build() {
        this.syncTranslations(this.getDefaultLanguage());
        this.needsSync = true;
        return this;
    }

    public void onTick() {
        boolean hasLanguageChanged;
        String currentLanguageId = this.getCurrentLanguage();
        boolean bl = hasLanguageChanged = !this.languageId.equals(currentLanguageId) && (!this.hasTranslationsFrom(currentLanguageId) || !this.requestMap.get(currentLanguageId).isEmpty());
        if (Constants.HAS_GAME_LOADED) {
            if (this.needsSync) {
                List<String> requestedKeys = StringUtils.newArrayList(this.requestMap.keySet());
                for (String key : requestedKeys) {
                    this.syncTranslations(key, false);
                }
                this.needsSync = false;
            } else if (hasLanguageChanged) {
                this.syncTranslations(currentLanguageId);
            }
        }
    }

    public void syncTranslations(String languageId, boolean setLanguage) {
        if (setLanguage) {
            this.setLanguage(languageId);
        }
        this.getTranslationMapFrom(languageId, this.encoding);
    }

    public void syncTranslations(String languageId) {
        this.syncTranslations(languageId, true);
    }

    public void syncTranslations() {
        this.needsSync = true;
    }

    private String getCurrentLanguage() {
        String result = this.languageSupplier.apply(this.defaultLanguageId);
        return this.usingJson ? result.toLowerCase() : result;
    }

    public String getDefaultLanguage() {
        return this.usingJson ? this.defaultLanguageId.toLowerCase() : this.defaultLanguageId;
    }

    public TranslationUtils setDefaultLanguage(String languageId) {
        this.defaultLanguageId = languageId;
        return this;
    }

    public TranslationUtils setUsingAssetsPath(boolean usingAssetsPath) {
        this.usingAssetsPath = usingAssetsPath;
        return this;
    }

    public TranslationUtils setStripColors(boolean stripColors) {
        this.stripColors = stripColors;
        return this;
    }

    public TranslationUtils setResourceSupplier(BiFunction<String, String, List<InputStream>> resourceSupplier) {
        this.resourceSupplier = resourceSupplier;
        return this;
    }

    public TranslationUtils setResourceSupplier(List<InputStream> resourceSupplier) {
        this.resourceSupplier = (id, langPath) -> resourceSupplier;
        return this;
    }

    public TranslationUtils setLanguageSupplier(Function<String, String> languageSupplier) {
        this.languageSupplier = languageSupplier;
        return this;
    }

    public TranslationUtils setLanguageSupplier(String languageSupplier) {
        this.languageSupplier = fallback -> languageSupplier;
        return this;
    }

    public TranslationUtils setUsingJson(boolean usingJson) {
        this.usingJson = usingJson;
        return this;
    }

    public TranslationUtils setLanguage(String languageId) {
        String result = StringUtils.getOrDefault(languageId, this.defaultLanguageId);
        this.languageId = this.usingJson ? result.toLowerCase() : result;
        return this;
    }

    public TranslationUtils setEncoding(String encoding) {
        this.encoding = StringUtils.getOrDefault(encoding, "UTF-8");
        return this;
    }

    public TranslationUtils setModId(String modId) {
        this.modId = StringUtils.getOrDefault(modId);
        return this;
    }

    private List<InputStream> getLocaleStreamsFrom(String languageId, String ext) {
        String assetsPath = this.usingAssetsPath ? String.format("/assets/%s/", this.modId) : "/";
        String langPath = String.format("lang/%s.%s", languageId, ext);
        List<InputStream> results = StringUtils.newArrayList();
        InputStream local = FileUtils.getResourceAsStream(TranslationUtils.class, assetsPath + langPath);
        if (local != null) {
            results.add(local);
        }
        results.addAll((Collection)this.resourceSupplier.apply(this.modId, langPath));
        return results;
    }

    private List<InputStream> getLocaleStreamsFrom(String languageId) {
        return this.getLocaleStreamsFrom(languageId, this.usingJson ? "json" : "lang");
    }

    private List<InputStream> getLocaleStreams(String ext) {
        return this.getLocaleStreamsFrom(this.languageId, ext);
    }

    private List<InputStream> getLocaleStreams() {
        return this.getLocaleStreamsFrom(this.languageId);
    }

    private Map<String, String> getTranslationMapFrom(String languageId, String encoding, List<InputStream> data) {
        boolean hasError = false;
        boolean hadBefore = this.hasTranslationsFrom(languageId);
        this.requestMap.remove(languageId);
        Map<String, String> translationMap = StringUtils.newHashMap();
        if (data != null && !data.isEmpty()) {
            for (InputStream in : data) {
                if (in != null) {
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName(encoding)));
                        try {
                            String currentString;
                            while ((currentString = reader.readLine()) != null) {
                                String[] splitTranslation;
                                if ((currentString = currentString.trim()).startsWith("#") || currentString.startsWith("[{}]") || !(this.usingJson ? currentString.contains(":") : currentString.contains("="))) continue;
                                String[] stringArray = splitTranslation = this.usingJson ? currentString.split(":", 2) : currentString.split("=", 2);
                                if (this.usingJson) {
                                    String str1 = splitTranslation[0].substring(1, splitTranslation[0].length() - 1).trim();
                                    String str2 = splitTranslation[1].substring(2, splitTranslation[1].length() - (splitTranslation[1].endsWith(",") ? 2 : 1)).trim();
                                    translationMap.put(str1.replaceAll("(?s)\\\\(.)", "$1"), str2.replaceAll("(?s)\\\\(.)", "$1"));
                                    continue;
                                }
                                translationMap.put(splitTranslation[0].trim(), splitTranslation[1].trim());
                            }
                            in.close();
                            continue;
                        }
                        finally {
                            reader.close();
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        Constants.LOG.error("An exception has occurred while loading Translation Mappings, aborting scan to prevent issues...", new Object[0]);
                        Constants.LOG.debugError(ex);
                        hasError = true;
                    }
                } else {
                    hasError = true;
                }
                break;
            }
        } else {
            hasError = true;
        }
        if (hasError) {
            Constants.LOG.error("Translations for " + this.modId + " do not exist for " + languageId, new Object[0]);
            translationMap.clear();
            this.requestMap.put(languageId, translationMap);
            this.setLanguage(this.defaultLanguageId);
        } else {
            Constants.LOG.debugInfo((hadBefore ? "Refreshed" : "Added") + " translations for " + this.modId + " for " + languageId, new Object[0]);
            this.requestMap.put(languageId, translationMap);
        }
        return translationMap;
    }

    private Map<String, String> getTranslationMapFrom(String languageId, String encoding) {
        return this.getTranslationMapFrom(languageId, encoding, this.getLocaleStreamsFrom(languageId));
    }

    private Map<String, String> getTranslationMapFrom(String languageId) {
        return this.getTranslationMapFrom(languageId, "UTF-8");
    }

    private Map<String, String> getTranslationMap() {
        return this.getTranslationMapFrom(this.languageId);
    }

    public String translateFrom(String languageId, boolean stripColors, String translationKey, Object ... parameters) {
        boolean hasError = false;
        String translatedString = translationKey;
        try {
            if (this.hasTranslationFrom(languageId, translationKey)) {
                String rawString = this.getTranslationFrom(languageId, translationKey);
                translatedString = parameters.length > 0 ? String.format(rawString, parameters) : rawString;
            } else {
                hasError = true;
            }
        }
        catch (Exception ex) {
            Constants.LOG.error("Exception parsing " + translationKey + " from " + languageId, new Object[0]);
            Constants.LOG.debugError(ex);
            return translationKey;
        }
        if (hasError) {
            Constants.LOG.debugError("Unable to retrieve a translation for " + translationKey + " from " + languageId, new Object[0]);
            if (!languageId.equals(this.getDefaultLanguage())) {
                Constants.LOG.debugError("Attempting to retrieve default translation for " + translationKey, new Object[0]);
                return this.translateFrom(this.getDefaultLanguage(), stripColors, translationKey, parameters);
            }
        }
        return stripColors ? StringUtils.stripColors(translatedString) : translatedString;
    }

    public String translateFrom(boolean stripColors, String translationKey, Object ... parameters) {
        return this.translateFrom(this.getDefaultLanguage(), stripColors, translationKey, parameters);
    }

    public String translate(boolean stripColors, String translationKey, Object ... parameters) {
        return this.translateFrom(this.languageId, stripColors, translationKey, parameters);
    }

    public String translateFrom(String languageId, String translationKey, Object ... parameters) {
        return this.translateFrom(languageId, this.stripColors, translationKey, parameters);
    }

    public String translateFrom(String translationKey, Object ... parameters) {
        return this.translateFrom(this.getDefaultLanguage(), translationKey, parameters);
    }

    public String translate(String translationKey, Object ... parameters) {
        return this.translateFrom(this.languageId, translationKey, parameters);
    }

    public boolean hasTranslationsFrom(String languageId) {
        return this.requestMap.containsKey(languageId);
    }

    public boolean hasTranslationFrom(String languageId, String translationKey) {
        if (this.hasTranslationsFrom(languageId)) {
            return this.requestMap.get(languageId).containsKey(translationKey);
        }
        return this.getTranslationMapFrom(languageId).containsKey(translationKey);
    }

    public boolean hasTranslation(String translationKey) {
        return this.hasTranslationFrom(this.languageId, translationKey);
    }

    public String getTranslationFrom(String languageId, String translationKey) {
        if (this.hasTranslationFrom(languageId, translationKey)) {
            return this.requestMap.get(languageId).get(translationKey);
        }
        return null;
    }

    public String getTranslation(String translationKey) {
        return this.getTranslationFrom(this.languageId, translationKey);
    }

    public static enum ConversionMode {
        PackFormat2,
        PackFormat3,
        None,
        Unknown;

    }
}

