/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry.food.recipe;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingforblockheads.registry.food.FoodIngredient;
import net.blay09.mods.cookingforblockheads.registry.food.FoodRecipe;
import net.minecraft.item.ItemStack;

public class RemoteCraftingFood
extends FoodRecipe {
    private final boolean isSmeltingRecipe;

    public RemoteCraftingFood(ItemStack outputItem, int recipeWidth, int recipeHeight, List<FoodIngredient> craftMatrix, boolean isSmeltingRecipe) {
        this.outputItem = outputItem;
        this.recipeWidth = recipeWidth;
        this.recipeHeight = recipeHeight;
        this.craftMatrix = craftMatrix;
        this.isSmeltingRecipe = isSmeltingRecipe;
    }

    @Override
    public boolean isSmeltingRecipe() {
        return this.isSmeltingRecipe;
    }

    public static RemoteCraftingFood read(ByteBuf buf) {
        ItemStack outputItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        byte recipeWidth = buf.readByte();
        byte recipeHeight = buf.readByte();
        int ingredientCount = buf.readShort();
        ArrayList<FoodIngredient> craftMatrix = new ArrayList<FoodIngredient>(ingredientCount);
        for (int k = 0; k < ingredientCount; ++k) {
            int stackCount = buf.readShort();
            if (stackCount > 0) {
                ItemStack[] itemStacks = new ItemStack[stackCount];
                for (int l = 0; l < stackCount; ++l) {
                    itemStacks[l] = ByteBufUtils.readItemStack((ByteBuf)buf);
                }
                boolean isOptional = buf.readBoolean();
                craftMatrix.add(new FoodIngredient(itemStacks, isOptional));
                continue;
            }
            craftMatrix.add(null);
        }
        boolean isSmeltingRecipe = buf.readBoolean();
        return new RemoteCraftingFood(outputItem, recipeWidth, recipeHeight, craftMatrix, isSmeltingRecipe);
    }

    public static void write(ByteBuf buf, FoodRecipe recipe) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)recipe.getOutputItem());
        buf.writeByte(recipe.getRecipeWidth());
        buf.writeByte(recipe.getRecipeHeight());
        buf.writeShort(recipe.getCraftMatrix().size());
        for (FoodIngredient ingredient : recipe.getCraftMatrix()) {
            if (ingredient != null && ingredient.getItemStacks().length > 0) {
                buf.writeShort(ingredient.getItemStacks().length);
                for (ItemStack ingredientStack : ingredient.getItemStacks()) {
                    ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)ingredientStack);
                }
                buf.writeBoolean(ingredient.isToolItem());
                continue;
            }
            buf.writeShort(0);
        }
        buf.writeBoolean(recipe.isSmeltingRecipe());
    }
}

