/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.block;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.network.Environment;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.block.BlockPeripheral;
import pl.asie.computronics.integration.railcraft.tile.TileDigitalDetector;
import pl.asie.computronics.oc.manual.IBlockWithPrefix;
import pl.asie.lib.block.BlockBase;

public class BlockDigitalDetector
extends BlockPeripheral
implements IBlockWithPrefix {
    private IIcon mSide;
    private IIcon mConnect;
    private static final String prefix = "railcraft/";

    public BlockDigitalDetector() {
        super("digital_detector");
        this.func_149663_c("computronics.detector");
        this.setRotation(BlockBase.Rotation.NONE);
        this.func_149752_b(4.5f);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149769_e);
        this.func_149647_a(Computronics.tab);
        this.setHarvestLevel("pickaxe", 2);
        this.setHarvestLevel("crowbar", 0);
    }

    public boolean isSideSolid(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        return true;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileDigitalDetector();
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileDigitalDetector) {
            ((TileDigitalDetector)tile).direction = MiscTools.getSideClosestToPlayer((World)world, (int)i, (int)j, (int)k, (EntityLivingBase)entityliving);
            world.func_147459_d(i, j, k, (Block)this);
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float u1, float u2, float u3) {
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileDigitalDetector) {
            TileDigitalDetector detector = (TileDigitalDetector)tile;
            detector.direction = detector.direction == axis ? axis.getOpposite() : axis;
            world.func_147459_d(x, y, z, (Block)this);
            world.func_147471_g(x, y, z);
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IIcon[] icons = TextureAtlasSheet.unstitchIcons((IIconRegister)iconRegister, (String)"computronics:digital_detector", (int)2);
        this.mSide = icons[0];
        this.mConnect = icons[1];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileDigitalDetector) {
            TileDigitalDetector detectorTile = (TileDigitalDetector)tile;
            if (detectorTile.direction.ordinal() == side) {
                return this.mConnect;
            }
            return this.mSide;
        }
        return null;
    }

    public int getFrontSide(int m) {
        return ForgeDirection.NORTH.ordinal();
    }

    public int relToAbs(int side, int metadata) {
        return side;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getAbsoluteIcon(int side, int metadata) {
        return this.func_149691_a(side, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getAbsoluteIcon(World world, int x, int y, int z, int side, int metadata) {
        return this.func_149673_e((IBlockAccess)world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == ForgeDirection.NORTH.ordinal() ? this.mConnect : this.mSide;
    }

    public void func_149726_b(World world, int i, int j, int k) {
        super.func_149726_b(world, i, j, k);
        world.func_147471_g(i, j, k);
        if (world.field_72995_K) {
            return;
        }
        world.func_147459_d(i + 1, j, k, (Block)this);
        world.func_147459_d(i - 1, j, k, (Block)this);
        world.func_147459_d(i, j, k + 1, (Block)this);
        world.func_147459_d(i, j, k - 1, (Block)this);
        world.func_147459_d(i, j - 1, k, (Block)this);
        world.func_147459_d(i, j + 1, k, (Block)this);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        super.func_149749_a(world, x, y, z, (Block)this, metadata);
        if (world.field_72995_K) {
            return;
        }
        world.func_147459_d(x + 1, y, z, (Block)this);
        world.func_147459_d(x - 1, y, z, (Block)this);
        world.func_147459_d(x, y, z + 1, (Block)this);
        world.func_147459_d(x, y, z - 1, (Block)this);
        world.func_147459_d(x, y - 1, z, (Block)this);
        world.func_147459_d(x, y + 1, z, (Block)this);
    }

    public boolean canConnectRedstone(IBlockAccess world, int i, int j, int k, int dir) {
        return false;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Class<? extends Environment> getTileEntityClass(int meta) {
        return TileDigitalDetector.class;
    }

    @Override
    public String getPrefix(World world, int x, int y, int z) {
        return prefix;
    }

    @Override
    public String getPrefix(ItemStack stack) {
        return prefix;
    }
}

