/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.client.AudioCableRender;
import pl.asie.computronics.oc.manual.IBlockWithDocumentation;
import pl.asie.computronics.tile.TileAudioCable;
import pl.asie.lib.block.BlockBase;
import pl.asie.lib.util.ColorUtils;

public class BlockAudioCable
extends BlockBase
implements IBlockWithDocumentation {
    private IIcon mCable;
    private int connectionMask = 63;
    private int ImmibisMicroblocks_TransformableBlockMarker;
    protected String documentationName = "audio_cable";

    public BlockAudioCable() {
        super(Material.field_151573_f, (Object)Computronics.instance);
        this.func_149647_a(Computronics.tab);
        this.func_149663_c("computronics.audiocable");
    }

    public void setRenderMask(int m) {
        this.connectionMask = m;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int a, float _x, float _y, float _z) {
        ColorUtils.Color color;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileAudioCable && (color = ColorUtils.getColor((ItemStack)player.func_70694_bm())) != null) {
            ((TileAudioCable)tile).setColor(color.color);
            world.func_147471_g(x, y, z);
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, a, _x, _y, _z);
    }

    public int func_149741_i(int meta) {
        return ColorUtils.Color.LightGray.color;
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileAudioCable) {
            return ((TileAudioCable)tile).getColor();
        }
        return this.func_149741_i(world.func_72805_g(x, y, z));
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileAudioCable) {
            ((TileAudioCable)tile).setColor(ColorUtils.fromWoolMeta((int)colour).color);
            world.func_147471_g(x, y, z);
            return true;
        }
        return super.recolourBlock(world, x, y, z, side, colour);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.doSetBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return super.func_149633_g(world, x, y, z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void func_149719_a(IBlockAccess world, int x, int y, int z) {
        BlockAudioCable blockAudioCable = this;
        synchronized (blockAudioCable) {
            this.doSetBlockBoundsBasedOnState(world, x, y, z);
        }
    }

    protected void doSetBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        this.setBlockBounds(BoundingBox.getBox(this.neighbors(world, x, y, z)));
    }

    private int neighbors(IBlockAccess world, int x, int y, int z) {
        int result = 0;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileAudioCable) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (!((TileAudioCable)tile).connectsAudio(side)) continue;
                result |= side.flag;
            }
        }
        return result;
    }

    protected void setBlockBounds(AxisAlignedBB bounds) {
        this.func_149676_a((float)bounds.field_72340_a, (float)bounds.field_72338_b, (float)bounds.field_72339_c, (float)bounds.field_72336_d, (float)bounds.field_72337_e, (float)bounds.field_72334_f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        BlockAudioCable blockAudioCable = this;
        synchronized (blockAudioCable) {
            return super.func_149731_a(world, x, y, z, start, end);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return (this.connectionMask & 1 << side) != 0;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileAudioCable();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getAbsoluteIcon(int sideNumber, int metadata) {
        return this.mCable;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister r) {
        super.func_149651_a(r);
        this.mCable = r.func_94245_a("computronics:audio_cable");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return AudioCableRender.id();
    }

    @Override
    public String getDocumentationName(World world, int x, int y, int z) {
        return this.documentationName;
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        return this.documentationName;
    }

    private static class BoundingBox {
        private static AxisAlignedBB[] bounds;
        private static final AxisAlignedBB DEFAULT_BOX;

        private BoundingBox() {
        }

        private static AxisAlignedBB getBox(int msk) {
            if (bounds == null) {
                BoundingBox.setupBounds();
            }
            if (msk < 0 || msk >= bounds.length || bounds[msk] == null) {
                return DEFAULT_BOX.func_72329_c();
            }
            return bounds[msk].func_72329_c();
        }

        private static void setupBounds() {
            ArrayList<AxisAlignedBB> newbounds = new ArrayList<AxisAlignedBB>(63);
            for (int mask = 0; mask <= 63; ++mask) {
                AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)-0.195, (double)-0.195, (double)-0.195, (double)0.195, (double)0.195, (double)0.195);
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    if ((side.flag & mask) == 0) continue;
                    if (side.offsetX < 0) {
                        bounds.field_72340_a += (double)side.offsetX * 0.375;
                    } else {
                        bounds.field_72336_d += (double)side.offsetX * 0.375;
                    }
                    if (side.offsetY < 0) {
                        bounds.field_72338_b += (double)side.offsetY * 0.375;
                    } else {
                        bounds.field_72337_e += (double)side.offsetY * 0.375;
                    }
                    if (side.offsetZ < 0) {
                        bounds.field_72339_c += (double)side.offsetZ * 0.375;
                        continue;
                    }
                    bounds.field_72334_f += (double)side.offsetZ * 0.375;
                }
                bounds.func_72324_b(BoundingBox.clamp(bounds.field_72340_a + 0.5), BoundingBox.clamp(bounds.field_72338_b + 0.5), BoundingBox.clamp(bounds.field_72339_c + 0.5), BoundingBox.clamp(bounds.field_72336_d + 0.5), BoundingBox.clamp(bounds.field_72337_e + 0.5), BoundingBox.clamp(bounds.field_72334_f + 0.5));
                newbounds.add(bounds);
            }
            bounds = newbounds.toArray(new AxisAlignedBB[newbounds.size()]);
        }

        private static double clamp(double val) {
            return Math.min(Math.max(val, 0.0), 1.0);
        }

        static {
            DEFAULT_BOX = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
    }
}

