/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.data.ISided;
import com.carpentersblocks.tileentity.TEBase;
import net.minecraftforge.common.util.ForgeDirection;

public class DaylightSensor
implements ISided {
    public static final byte POLARITY_POSITIVE = 0;
    public static final byte POLARITY_NEGATIVE = 1;
    public static final byte SENSITIVITY_SLEEP = 0;
    public static final byte SENSITIVITY_MONSTERS = 1;
    public static final byte SENSITIVITY_DYNAMIC = 2;

    @Override
    public ForgeDirection getDirection(TEBase TE) {
        int side = (TE.getData() & 0x380) >> 7;
        return ForgeDirection.getOrientation((int)side);
    }

    @Override
    public boolean setDirection(TEBase TE, ForgeDirection dir) {
        int temp = TE.getData() & 0xFFFFFC7F | dir.ordinal() << 7;
        return TE.setData(temp);
    }

    public int getLightLevel(TEBase TE) {
        return TE.getData() & 0xF;
    }

    public void setLightLevel(TEBase TE, int lightLevel) {
        int temp = TE.getData() & 0xFFFFFFF0 | lightLevel;
        TE.setData(temp);
    }

    public int getPolarity(TEBase TE) {
        return (TE.getData() & 0x10) >> 4;
    }

    public void setPolarity(TEBase TE, int state) {
        int temp = TE.getData() & 0xFFFFFFEF | state << 4;
        TE.setData(temp);
    }

    public int getSensitivity(TEBase TE) {
        return (TE.getData() & 0x60) >> 5;
    }

    private void setSensitivity(TEBase TE, int sensitivity) {
        int temp = TE.getData() & 0xFFFFFF9F | sensitivity << 5;
        TE.setData(temp);
    }

    public int setNextSensitivity(TEBase TE) {
        int sensitivity = this.getSensitivity(TE);
        if (++sensitivity > 2) {
            sensitivity = 0;
        }
        this.setSensitivity(TE, sensitivity);
        return sensitivity;
    }

    public boolean isActive(TEBase TE) {
        return this.getRedstoneOutput(TE) > 0;
    }

    public int getRedstoneOutput(TEBase TE) {
        boolean posPolarity = this.getPolarity(TE) == 0;
        int output = 0;
        int lightLevel = this.getLightLevel(TE);
        int sensitivity = this.getSensitivity(TE);
        if (sensitivity == 0) {
            boolean active;
            boolean bl = posPolarity ? lightLevel > 11 : (active = lightLevel <= 11);
            if (active) {
                output = 15;
            }
        } else if (sensitivity == 1) {
            boolean active;
            boolean bl = posPolarity ? lightLevel > 7 : (active = lightLevel <= 7);
            if (active) {
                output = 15;
            }
        } else {
            output = posPolarity ? lightLevel : 15 - lightLevel;
        }
        return output;
    }
}

