/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.common.utills;

public class SimplexNoise {
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double SQRT5 = Math.sqrt(5.0);
    private static final double F2 = 0.5 * (SQRT3 - 1.0);
    private static final double G2 = (3.0 - SQRT3) / 6.0;
    private static final double G22 = G2 * 2.0 - 1.0;
    private static final double F3 = 0.3333333333333333;
    private static final double G3 = 0.16666666666666666;
    private static final double F4 = (SQRT5 - 1.0) / 4.0;
    private static final double G4 = (5.0 - SQRT5) / 20.0;
    private static final double G42 = G4 * 2.0;
    private static final double G43 = G4 * 3.0;
    private static final double G44 = G4 * 4.0 - 1.0;
    private static final int[][] grad3 = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}};
    private static final int[][] grad4 = new int[][]{{0, 1, 1, 1}, {0, 1, 1, -1}, {0, 1, -1, 1}, {0, 1, -1, -1}, {0, -1, 1, 1}, {0, -1, 1, -1}, {0, -1, -1, 1}, {0, -1, -1, -1}, {1, 0, 1, 1}, {1, 0, 1, -1}, {1, 0, -1, 1}, {1, 0, -1, -1}, {-1, 0, 1, 1}, {-1, 0, 1, -1}, {-1, 0, -1, 1}, {-1, 0, -1, -1}, {1, 1, 0, 1}, {1, 1, 0, -1}, {1, -1, 0, 1}, {1, -1, 0, -1}, {-1, 1, 0, 1}, {-1, 1, 0, -1}, {-1, -1, 0, 1}, {-1, -1, 0, -1}, {1, 1, 1, 0}, {1, 1, -1, 0}, {1, -1, 1, 0}, {1, -1, -1, 0}, {-1, 1, 1, 0}, {-1, 1, -1, 0}, {-1, -1, 1, 0}, {-1, -1, -1, 0}};
    private static final int[] p = new int[]{151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180};
    private static int[] perm = new int[512];
    private static final int[][] simplex = new int[][]{{0, 1, 2, 3}, {0, 1, 3, 2}, {0, 0, 0, 0}, {0, 2, 3, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 2, 3, 0}, {0, 2, 1, 3}, {0, 0, 0, 0}, {0, 3, 1, 2}, {0, 3, 2, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 3, 2, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 2, 0, 3}, {0, 0, 0, 0}, {1, 3, 0, 2}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {2, 3, 0, 1}, {2, 3, 1, 0}, {1, 0, 2, 3}, {1, 0, 3, 2}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {2, 0, 3, 1}, {0, 0, 0, 0}, {2, 1, 3, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {2, 0, 1, 3}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {3, 0, 1, 2}, {3, 0, 2, 1}, {0, 0, 0, 0}, {3, 1, 2, 0}, {2, 1, 0, 3}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {3, 1, 0, 2}, {0, 0, 0, 0}, {3, 2, 0, 1}, {3, 2, 1, 0}};

    private static double dot(int[] g, double x, double y) {
        return (double)g[0] * x + (double)g[1] * y;
    }

    private static double dot(int[] g, double x, double y, double z) {
        return (double)g[0] * x + (double)g[1] * y + (double)g[2] * z;
    }

    private static double dot(int[] g, double x, double y, double z, double w) {
        return (double)g[0] * x + (double)g[1] * y + (double)g[2] * z + (double)g[3] * w;
    }

    private static final int fastfloor(double x) {
        return x >= 0.0 ? (int)x : (int)x - 1;
    }

    public static double noise(double x, double y) {
        double t2;
        double t1;
        int j1;
        int i1;
        double y0;
        int j;
        double t;
        double n0 = 0.0;
        double n1 = 0.0;
        double n2 = 0.0;
        double s = (x + y) * F2;
        int i = SimplexNoise.fastfloor(x + s);
        double x0 = x - ((double)i - (t = (double)(i + (j = SimplexNoise.fastfloor(y + s))) * G2));
        if (x0 > (y0 = y - ((double)j - t))) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        double x1 = x0 - (double)i1 + G2;
        double y1 = y0 - (double)j1 + G2;
        double x2 = x0 + G22;
        double y2 = y0 + G22;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        double t0 = 0.5 - x0 * x0 - y0 * y0;
        if (t0 > 0.0) {
            t0 *= t0;
            int gi0 = perm[ii + perm[jj]] % 12;
            n0 = t0 * t0 * SimplexNoise.dot(grad3[gi0], x0, y0);
        }
        if ((t1 = 0.5 - x1 * x1 - y1 * y1) > 0.0) {
            t1 *= t1;
            int gi1 = perm[ii + i1 + perm[jj + j1]] % 12;
            n1 = t1 * t1 * SimplexNoise.dot(grad3[gi1], x1, y1);
        }
        if ((t2 = 0.5 - x2 * x2 - y2 * y2) > 0.0) {
            t2 *= t2;
            int gi2 = perm[ii + 1 + perm[jj + 1]] % 12;
            n2 = t2 * t2 * SimplexNoise.dot(grad3[gi2], x2, y2);
        }
        return 70.0 * (n0 + n1 + n2);
    }

    public static double noise(double x, double y, double z) {
        double t3;
        double t2;
        double t1;
        int k2;
        int j2;
        int i2;
        int k1;
        int j1;
        int i1;
        double n0 = 0.0;
        double n1 = 0.0;
        double n2 = 0.0;
        double n3 = 0.0;
        double s = (x + y + z) * 0.3333333333333333;
        int i = SimplexNoise.fastfloor(x + s);
        int j = SimplexNoise.fastfloor(y + s);
        int k = SimplexNoise.fastfloor(z + s);
        double t = (double)(i + j + k) * 0.16666666666666666;
        double x0 = x - ((double)i - t);
        double y0 = y - ((double)j - t);
        double z0 = z - ((double)k - t);
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        double x1 = x0 - (double)i1 + 0.16666666666666666;
        double y1 = y0 - (double)j1 + 0.16666666666666666;
        double z1 = z0 - (double)k1 + 0.16666666666666666;
        double x2 = x0 - (double)i2 + 0.3333333333333333;
        double y2 = y0 - (double)j2 + 0.3333333333333333;
        double z2 = z0 - (double)k2 + 0.3333333333333333;
        double x3 = x0 - 0.5;
        double y3 = y0 - 0.5;
        double z3 = z0 - 0.5;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        int kk = k & 0xFF;
        double t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0;
        if (t0 > 0.0) {
            t0 *= t0;
            int gi0 = perm[ii + perm[jj + perm[kk]]] % 12;
            n0 = t0 * t0 * SimplexNoise.dot(grad3[gi0], x0, y0, z0);
        }
        if ((t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1) > 0.0) {
            t1 *= t1;
            int gi1 = perm[ii + i1 + perm[jj + j1 + perm[kk + k1]]] % 12;
            n1 = t1 * t1 * SimplexNoise.dot(grad3[gi1], x1, y1, z1);
        }
        if ((t2 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2) > 0.0) {
            t2 *= t2;
            int gi2 = perm[ii + i2 + perm[jj + j2 + perm[kk + k2]]] % 12;
            n2 = t2 * t2 * SimplexNoise.dot(grad3[gi2], x2, y2, z2);
        }
        if ((t3 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3) > 0.0) {
            t3 *= t3;
            int gi3 = perm[ii + 1 + perm[jj + 1 + perm[kk + 1]]] % 12;
            n3 = t3 * t3 * SimplexNoise.dot(grad3[gi3], x3, y3, z3);
        }
        return 32.0 * (n0 + n1 + n2 + n3);
    }

    public static double noise(double x, double y, double z, double w) {
        double t4;
        double t3;
        double t2;
        double t1;
        int[] sc;
        double n0 = 0.0;
        double n1 = 0.0;
        double n2 = 0.0;
        double n3 = 0.0;
        double n4 = 0.0;
        double s = (x + y + z + w) * F4;
        int i = SimplexNoise.fastfloor(x + s);
        int j = SimplexNoise.fastfloor(y + s);
        int k = SimplexNoise.fastfloor(z + s);
        int l = SimplexNoise.fastfloor(w + s);
        double t = (double)(i + j + k + l) * G4;
        double x0 = x - ((double)i - t);
        double y0 = y - ((double)j - t);
        double z0 = z - ((double)k - t);
        double w0 = w - ((double)l - t);
        int c = 0;
        if (x0 > y0) {
            c = 32;
        }
        if (x0 > z0) {
            c |= 0x10;
        }
        if (y0 > z0) {
            c |= 8;
        }
        if (x0 > w0) {
            c |= 4;
        }
        if (y0 > w0) {
            c |= 2;
        }
        if (z0 > w0) {
            c |= 1;
        }
        int i1 = (sc = simplex[c])[0] >= 3 ? 1 : 0;
        int j1 = sc[1] >= 3 ? 1 : 0;
        int k1 = sc[2] >= 3 ? 1 : 0;
        int l1 = sc[3] >= 3 ? 1 : 0;
        int i2 = sc[0] >= 2 ? 1 : 0;
        int j2 = sc[1] >= 2 ? 1 : 0;
        int k2 = sc[2] >= 2 ? 1 : 0;
        int l2 = sc[3] >= 2 ? 1 : 0;
        int i3 = sc[0] >= 1 ? 1 : 0;
        int j3 = sc[1] >= 1 ? 1 : 0;
        int k3 = sc[2] >= 1 ? 1 : 0;
        int l3 = sc[3] >= 1 ? 1 : 0;
        double x1 = x0 - (double)i1 + G4;
        double y1 = y0 - (double)j1 + G4;
        double z1 = z0 - (double)k1 + G4;
        double w1 = w0 - (double)l1 + G4;
        double x2 = x0 - (double)i2 + G42;
        double y2 = y0 - (double)j2 + G42;
        double z2 = z0 - (double)k2 + G42;
        double w2 = w0 - (double)l2 + G42;
        double x3 = x0 - (double)i3 + G43;
        double y3 = y0 - (double)j3 + G43;
        double z3 = z0 - (double)k3 + G43;
        double w3 = w0 - (double)l3 + G43;
        double x4 = x0 + G44;
        double y4 = y0 + G44;
        double z4 = z0 + G44;
        double w4 = w0 + G44;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        int kk = k & 0xFF;
        int ll = l & 0xFF;
        double t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0 - w0 * w0;
        if (t0 > 0.0) {
            t0 *= t0;
            int gi0 = perm[ii + perm[jj + perm[kk + perm[ll]]]] % 32;
            n0 = t0 * t0 * SimplexNoise.dot(grad4[gi0], x0, y0, z0, w0);
        }
        if ((t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1 - w1 * w1) > 0.0) {
            t1 *= t1;
            int gi1 = perm[ii + i1 + perm[jj + j1 + perm[kk + k1 + perm[ll + l1]]]] % 32;
            n1 = t1 * t1 * SimplexNoise.dot(grad4[gi1], x1, y1, z1, w1);
        }
        if ((t2 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2 - w2 * w2) > 0.0) {
            t2 *= t2;
            int gi2 = perm[ii + i2 + perm[jj + j2 + perm[kk + k2 + perm[ll + l2]]]] % 32;
            n2 = t2 * t2 * SimplexNoise.dot(grad4[gi2], x2, y2, z2, w2);
        }
        if ((t3 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3 - w3 * w3) > 0.0) {
            t3 *= t3;
            int gi3 = perm[ii + i3 + perm[jj + j3 + perm[kk + k3 + perm[ll + l3]]]] % 32;
            n3 = t3 * t3 * SimplexNoise.dot(grad4[gi3], x3, y3, z3, w3);
        }
        if ((t4 = 0.6 - x4 * x4 - y4 * y4 - z4 * z4 - w4 * w4) > 0.0) {
            t4 *= t4;
            int gi4 = perm[ii + 1 + perm[jj + 1 + perm[kk + 1 + perm[ll + 1]]]] % 32;
            n4 = t4 * t4 * SimplexNoise.dot(grad4[gi4], x4, y4, z4, w4);
        }
        return 27.0 * (n0 + n1 + n2 + n3 + n4);
    }

    static {
        for (int i = 0; i < 512; ++i) {
            SimplexNoise.perm[i] = p[i & 0xFF];
        }
    }
}

