/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.alchemy.energy;

import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import net.minecraft.nbt.NBTTagCompound;

public class ReagentStack {
    public Reagent reagent;
    public int amount;

    public ReagentStack(Reagent reagent, int amount) {
        this.reagent = reagent;
        this.amount = amount;
    }

    public ReagentStack(ReagentStack reagentStack, int amount) {
        this(reagentStack.reagent, amount);
    }

    public static ReagentStack loadReagentStackFromNBT(NBTTagCompound tag) {
        Reagent reagent = ReagentRegistry.getReagentForKey(tag.func_74779_i("Reagent"));
        if (reagent == null) {
            return null;
        }
        int amount = tag.func_74762_e("amount");
        ReagentStack stack = new ReagentStack(reagent, amount);
        return stack;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("Reagent", ReagentRegistry.getKeyForReagent(this.reagent));
        tag.func_74768_a("amount", this.amount);
        return tag;
    }

    public ReagentStack splitStack(int amount) {
        int splitAmount;
        ReagentStack copyStack = this.copy();
        copyStack.amount = splitAmount = Math.min(amount, this.amount);
        this.amount -= splitAmount;
        return copyStack;
    }

    public ReagentStack copy() {
        return new ReagentStack(this.reagent, this.amount);
    }

    public boolean isReagentEqual(ReagentStack other) {
        return other != null && this.reagent == other.reagent;
    }
}

