/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.world.mapgen.BaseStructureComponent;
import de.katzenpapst.amunra.world.mapgen.populator.AbstractPopulator;
import de.katzenpapst.amunra.world.mapgen.populator.SpawnEntity;
import java.util.HashMap;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public abstract class BaseStructureStart
extends BaseStructureComponent {
    protected PopulatorByChunkMap populatorsByChunk;
    protected int chunkX;
    protected int chunkZ;
    protected Random rand;
    protected World worldObj;
    protected int startX;
    protected int startZ;

    public BaseStructureStart(World world, int chunkX, int chunkZ, Random rand) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.worldObj = world;
        this.rand = rand;
        this.startX = this.rand.nextInt(16);
        this.startZ = this.rand.nextInt(16);
        this.populatorsByChunk = new PopulatorByChunkMap();
    }

    protected void preparePopulatorListForChunk(int chunkX, int chunkZ) {
        Long key = ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ);
        if (this.populatorsByChunk.containsKey(key)) {
            AmunRa.LOGGER.error("Tried to prepare populator list for chunk {}/{}. This could mean that the chunk is being generated twice.", new Object[]{chunkX, chunkZ});
            return;
        }
        this.populatorsByChunk.put(key, new PopulatorMap());
    }

    public World getWorld() {
        return this.worldObj;
    }

    @Override
    public boolean generateChunk(int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        this.preparePopulatorListForChunk(chunkX, chunkZ);
        return true;
    }

    public void populateChunk(World world, int chunkX, int chunkZ) {
        Long chunkKey = ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ);
        if (!this.populatorsByChunk.containsKey(chunkKey)) {
            AmunRa.LOGGER.warn("No populator list for chunk {}/{}", new Object[]{chunkX, chunkZ});
            return;
        }
        PopulatorMap curMap = (PopulatorMap)this.populatorsByChunk.get(chunkKey);
        this.populatorsByChunk.remove(chunkKey);
        for (AbstractPopulator p : curMap.values()) {
            if (p.populate(world)) continue;
            AmunRa.LOGGER.error("Populator {} failed...", new Object[]{p.getClass().getCanonicalName()});
        }
        curMap.clear();
    }

    public void addPopulator(AbstractPopulator p) {
        BlockVec3 key;
        int chunkZ;
        int chunkX = CoordHelper.blockToChunk(p.getX());
        Long chunkKey = ChunkCoordIntPair.func_77272_a((int)chunkX, (int)(chunkZ = CoordHelper.blockToChunk(p.getZ())));
        if (!this.populatorsByChunk.containsKey(chunkKey)) {
            AmunRa.LOGGER.error("Cannot add populator for {}/{}, offender: {}. Probably it's the wrong chunk", new Object[]{chunkX, chunkZ, p.getClass().getCanonicalName()});
            return;
        }
        PopulatorMap curMap = (PopulatorMap)this.populatorsByChunk.get(chunkKey);
        if (curMap.containsKey(key = p.getBlockVec3())) {
            AmunRa.LOGGER.error("Cannot add populator for {}, offender: {}", new Object[]{key, p.getClass().getCanonicalName()});
            return;
        }
        curMap.put(key, p);
    }

    public void spawnLater(Entity ent, int x, int y, int z) {
        SpawnEntity p = new SpawnEntity(x, y, z, ent);
        this.addPopulator(p);
    }

    public int getWorldGroundLevel() {
        return this.worldObj.field_73011_w.func_76557_i();
    }

    public class PopulatorByChunkMap
    extends HashMap<Long, PopulatorMap> {
        private static final long serialVersionUID = 2084699646332356938L;
    }

    public class PopulatorMap
    extends HashMap<BlockVec3, AbstractPopulator> {
        private static final long serialVersionUID = -1581029941656595874L;
    }
}

