/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.command;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.helper.AstronomyHelper;
import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.mothership.MothershipWorldProvider;
import de.katzenpapst.amunra.network.packet.PacketSimpleAR;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;

public class CommandMoveMothership
extends CommandBase {
    public String func_71517_b() {
        return "mothership_move";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " <name> [<travel time>]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        long travelTime = 100L;
        if (!(sender.func_130014_f_().field_73011_w instanceof MothershipWorldProvider)) {
            throw new WrongUsageException("You are not on a mothership", new Object[0]);
        }
        if (args.length < 1) {
            throw new WrongUsageException("Not enough arguments, usage: " + this.func_71518_a(sender), new Object[0]);
        }
        Mothership mShip = (Mothership)((MothershipWorldProvider)sender.func_130014_f_().field_73011_w).getCelestialBody();
        String targetName = args[0];
        if (args.length >= 2 && (travelTime = (long)Integer.parseInt(args[1])) < 1L) {
            throw new WrongUsageException("Travel time must be at least 1!", new Object[0]);
        }
        CelestialBody targetBody = Mothership.findBodyByString(targetName);
        if (targetBody == null) {
            throw new WrongUsageException("Found no body for " + targetName, new Object[0]);
        }
        if (!mShip.getWorldProviderServer().startTransit(targetBody, true)) {
            throw new WrongUsageException("Starting transit failed", new Object[0]);
        }
        AmunRa.packetPipeline.sendToAll(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.C_MOTHERSHIP_TRANSIT_STARTED, mShip.getID(), AstronomyHelper.getOrbitableBodyName(targetBody), travelTime));
    }
}

