/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.sugar.impl;

import com.llamalad7.mixinextras.sugar.impl.SugarApplicationException;
import com.llamalad7.mixinextras.sugar.impl.SugarApplicator;
import com.llamalad7.mixinextras.sugar.impl.SugarParameter;
import com.llamalad7.mixinextras.sugar.impl.ref.LocalRefClassGenerator;
import com.llamalad7.mixinextras.sugar.impl.ref.LocalRefUtils;
import com.llamalad7.mixinextras.utils.CompatibilityHelper;
import java.util.HashMap;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.modify.InvalidImplicitDiscriminatorException;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;

class LocalSugarApplicator
extends SugarApplicator {
    private final boolean isArgsOnly;
    private final Type targetLocalType;
    private final boolean isMutable;

    LocalSugarApplicator(InjectionInfo info, SugarParameter parameter) {
        super(info, parameter);
        this.targetLocalType = LocalRefUtils.getTargetType(this.paramType, this.paramGeneric);
        this.isMutable = this.targetLocalType != this.paramType;
        this.isArgsOnly = Annotations.getValue(this.sugar, "argsOnly", Boolean.valueOf(false));
    }

    @Override
    void validate(Target target, InjectionNodes.InjectionNode node) {
        LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse(this.sugar);
        LocalVariableDiscriminator.Context context = this.getOrCreateLocalContext(target, node);
        if (discriminator.printLVT()) {
            this.printLocals(target, node.getCurrentTarget(), context, discriminator);
            this.info.addCallbackInvocation(this.info.getMethod());
            throw new SugarApplicationException("Application aborted because locals are being printed instead.");
        }
        try {
            if (discriminator.findLocal(context) < 0) {
                throw new SugarApplicationException("Unable to find matching local!");
            }
        }
        catch (InvalidImplicitDiscriminatorException e) {
            throw new SugarApplicationException("Invalid implicit variable discriminator: ", e);
        }
    }

    @Override
    void prepare(Target target, InjectionNodes.InjectionNode node) {
        this.getOrCreateLocalContext(target, node);
    }

    @Override
    void inject(Target target, InjectionNodes.InjectionNode node) {
        LocalVariableDiscriminator.Context context;
        LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse(this.sugar);
        int index = discriminator.findLocal(context = (LocalVariableDiscriminator.Context)node.getDecoration(this.getLocalContextKey()));
        if (index < 0) {
            throw new SugarApplicationException("Failed to match a local, this should have been caught during validation.");
        }
        if (this.isMutable) {
            this.initAndLoadLocalRef(target, node, index);
        } else {
            target.insns.insertBefore(node.getCurrentTarget(), new VarInsnNode(this.targetLocalType.getOpcode(21), index));
        }
    }

    private void initAndLoadLocalRef(Target target, InjectionNodes.InjectionNode node, int index) {
        String refName = LocalRefClassGenerator.getForType(this.targetLocalType);
        int refIndex = this.getOrCreateRef(target, node, index, refName);
        target.insns.insertBefore(node.getCurrentTarget(), new VarInsnNode(25, refIndex));
    }

    private int getOrCreateRef(Target target, InjectionNodes.InjectionNode node, int index, String refImpl) {
        HashMap<Integer, Integer> refIndices = (HashMap<Integer, Integer>)node.getDecoration("mixinextras_localRefMap");
        if (refIndices == null) {
            refIndices = new HashMap<Integer, Integer>();
            node.decorate("mixinextras_localRefMap", refIndices);
        }
        if (refIndices.containsKey(index)) {
            return (Integer)refIndices.get(index);
        }
        int refIndex = target.allocateLocal();
        target.addLocalVariable(refIndex, "ref" + refIndex, 'L' + refImpl + ';');
        InsnList before = new InsnList();
        LocalRefUtils.generateWrapping(before, this.targetLocalType, () -> before.add(new VarInsnNode(this.targetLocalType.getOpcode(21), index)));
        before.add(new VarInsnNode(58, refIndex));
        target.insertBefore(node, before);
        InsnList after = new InsnList();
        LocalRefUtils.generateUnwrapping(after, this.targetLocalType, () -> after.add(new VarInsnNode(25, refIndex)));
        after.add(new VarInsnNode(this.targetLocalType.getOpcode(54), index));
        target.insns.insert(node.getCurrentTarget(), after);
        refIndices.put(index, refIndex);
        return refIndex;
    }

    private LocalVariableDiscriminator.Context getOrCreateLocalContext(Target target, InjectionNodes.InjectionNode node) {
        String decorationKey = this.getLocalContextKey();
        if (node.hasDecoration(decorationKey)) {
            return (LocalVariableDiscriminator.Context)node.getDecoration(decorationKey);
        }
        LocalVariableDiscriminator.Context context = CompatibilityHelper.makeLvtContext(this.info, this.targetLocalType, this.isArgsOnly, target, node.getCurrentTarget());
        node.decorate(decorationKey, context);
        return context;
    }

    private String getLocalContextKey() {
        return String.format("mixinextras_localSugarContext(%s,%s)", this.targetLocalType, this.isArgsOnly ? "argsOnly" : "fullFrame");
    }

    private void printLocals(Target target, AbstractInsnNode node, LocalVariableDiscriminator.Context context, LocalVariableDiscriminator discriminator) {
        int baseArgIndex = target.isStatic ? 0 : 1;
        new PrettyPrinter().kvWidth(20).kv("Target Class", target.classNode.name.replace('/', '.')).kv("Target Method", target.method.name).kv("Capture Type", SignaturePrinter.getTypeName(this.targetLocalType, false)).kv("Instruction", "[%d] %s %s", target.insns.indexOf(node), node.getClass().getSimpleName(), Bytecode.getOpcodeName(node.getOpcode())).hr().kv("Match mode", this.isImplicit(discriminator, baseArgIndex) ? "IMPLICIT (match single)" : "EXPLICIT (match by criteria)").kv("Match ordinal", discriminator.getOrdinal() < 0 ? "any" : Integer.valueOf(discriminator.getOrdinal())).kv("Match index", discriminator.getIndex() < baseArgIndex ? "any" : Integer.valueOf(discriminator.getIndex())).kv("Match name(s)", discriminator.hasNames() ? discriminator.getNames() : "any").kv("Args only", this.isArgsOnly).hr().add(context).print(System.err);
    }

    private boolean isImplicit(LocalVariableDiscriminator discriminator, int baseArgIndex) {
        return discriminator.getOrdinal() < 0 && discriminator.getIndex() < baseArgIndex && discriminator.getNames().isEmpty();
    }
}

