/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.preprocessor;

import crafttweaker.preprocessor.PreprocessorActionBase;
import crafttweaker.runtime.ScriptFile;
import crafttweaker.util.SuppressErrorFlag;
import youyihj.zenutils.impl.util.InternalUtils;

public class SuppressErrorPreprocessor
extends PreprocessorActionBase {
    public static final String NAME = "suppress";
    public final SuppressErrorFlag suppressLevel;

    public SuppressErrorPreprocessor(String fileName, String preprocessorLine, int lineIndex) {
        super(fileName, preprocessorLine, lineIndex);
        switch (preprocessorLine.substring(NAME.length() + 1).trim()) {
            case "warning": 
            case "warnings": {
                this.suppressLevel = SuppressErrorFlag.ONLY_WARNINGS;
                break;
            }
            case "errors": 
            case "error": 
            case "all": {
                this.suppressLevel = SuppressErrorFlag.ALL;
                break;
            }
            default: {
                this.suppressLevel = SuppressErrorFlag.DEFAULT;
            }
        }
    }

    public void executeActionOnFind(ScriptFile scriptFile) {
        InternalUtils.doSuppressErrorSingleScriptMode();
        InternalUtils.putSuppressErrorFlag(scriptFile.getEffectiveName(), this.suppressLevel);
    }

    public String getPreprocessorName() {
        return NAME;
    }
}

