/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.ftbq.event;

import com.feed_the_beast.ftbquests.events.CustomTaskEvent;
import com.feed_the_beast.ftbquests.quest.task.CustomTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.event.IEventCancelable;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenSetter;
import youyihj.zenutils.api.ftbq.CTTask;

@ZenRegister
@ZenClass(value="mods.zenutils.ftbq.CustomTaskEvent")
@ModOnly(value="ftbquests")
public class CTCustomTaskEvent
implements IEventCancelable {
    private final CustomTaskEvent event;

    public CTCustomTaskEvent(CustomTaskEvent event) {
        this.event = event;
    }

    @ZenGetter(value="task")
    public CTTask getTask() {
        return new CTTask((Task)this.event.getTask());
    }

    @ZenGetter(value="checkTimer")
    public int getCheckTimer() {
        return this.event.getTask().checkTimer;
    }

    @ZenSetter(value="checkTimer")
    public void setCheckTimer(int time) {
        this.event.getTask().checkTimer = time;
    }

    @ZenSetter(value="checker")
    public void setChecker(ITaskChecker checker) {
        this.event.getTask().check = new TaskCheckWrapper(checker);
    }

    @ZenGetter(value="maxProgress")
    public int getMaxProgress() {
        return Math.toIntExact(this.event.getTask().maxProgress);
    }

    @ZenSetter(value="maxProgress")
    public void setMaxProgress(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("max progress must be bigger than 0");
        }
        this.event.getTask().maxProgress = max;
    }

    @ZenGetter
    public boolean enableButton() {
        return this.event.getTask().enableButton;
    }

    @ZenSetter
    public void enableButton(boolean b) {
        this.event.getTask().enableButton = b;
    }

    public boolean isCanceled() {
        return this.event.isCanceled();
    }

    public void setCanceled(boolean canceled) {
        this.event.setCanceled(canceled);
    }

    private static class TaskCheckWrapper
    implements CustomTask.Check {
        private final ITaskChecker checker;

        TaskCheckWrapper(ITaskChecker checker) {
            this.checker = checker;
        }

        public void check(@Nonnull CustomTask.Data taskData, @Nonnull EntityPlayerMP player) {
            taskData.setProgress((long)this.checker.check(CraftTweakerMC.getIPlayer((EntityPlayer)player), Math.toIntExact(taskData.progress)));
        }
    }

    @ZenRegister
    @ZenClass(value="mods.zenutils.ftbq.ITaskChecker")
    @FunctionalInterface
    @ModOnly(value="ftbquests")
    public static interface ITaskChecker {
        public int check(IPlayer var1, int var2);
    }
}

