/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.tweaconstruct.tweaks;

import com.rcx.tweaconstruct.ConfigHandler;
import com.rcx.tweaconstruct.TweakersConstruct;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.MaterialEvent;
import slimeknights.tconstruct.library.materials.Material;

public class PartCreationTweaks {
    public static Map<String, String[]> materialsToTweak = new HashMap<String, String[]>();
    public static boolean weAreNotDoneYet = true;

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)new PartCreationTweaks());
        if (ConfigHandler.PartCreationList.length != 0) {
            for (String entry : ConfigHandler.PartCreationList) {
                String[] entries = entry.split(":");
                if (entries.length != 3) {
                    TweakersConstruct.logger.warn("[Part Creation Tweaks] Entry: " + entry + " has incorrect syntax, skipping.");
                    continue;
                }
                materialsToTweak.put(entries[0], entries);
            }
        }
    }

    @SubscribeEvent
    public void onMaterialRegister(MaterialEvent.MaterialRegisterEvent event) {
        if (event.material != null && materialsToTweak.containsKey(event.material.identifier)) {
            String[] entries = materialsToTweak.get(event.material.identifier);
            event.material.setCraftable(Boolean.parseBoolean(entries[1]));
            event.material.setCastable(Boolean.parseBoolean(entries[2]));
        }
    }

    @SubscribeEvent
    public void onMaterialIntegrated(MaterialEvent.IntegrationEvent event) {
        if (event.material != null && materialsToTweak.containsKey(event.material.identifier)) {
            String[] entries = materialsToTweak.get(event.material.identifier);
            boolean formerlyCastable = event.material.isCastable();
            event.material.setCraftable(Boolean.parseBoolean(entries[1]));
            event.material.setCastable(Boolean.parseBoolean(entries[2]));
            if (formerlyCastable && !Boolean.parseBoolean(entries[2])) {
                event.materialIntegration.material = null;
                event.material.setRepresentativeItem(event.materialIntegration.representativeItem);
                event.setCanceled(true);
            }
        }
    }

    public static void postInit() {
        for (String entry : materialsToTweak.keySet().toArray(new String[materialsToTweak.size()])) {
            String[] entries = materialsToTweak.get(entry);
            Material material = TinkerRegistry.getMaterial((String)entry);
            material.setCraftable(Boolean.parseBoolean(entries[1]));
            material.setCastable(Boolean.parseBoolean(entries[2]));
        }
    }
}

