/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.harvest;

import net.minecraft.block.state.IBlockState;
import org.apache.logging.log4j.Level;
import tyra314.toolprogression.ToolProgressionMod;
import tyra314.toolprogression.harvest.BlockHelper;

public class BlockOverwrite {
    public String toolclass;
    public int level;
    public boolean toolRequired;
    public OverwriteSource source;
    public String sourceKey;
    public float hardness;
    public boolean destroyable;

    public BlockOverwrite(String toolclass, int level, boolean toolRequired, OverwriteSource source, String sourceKey) {
        this.toolclass = toolclass;
        this.level = level;
        this.toolRequired = toolRequired;
        this.source = source;
        this.sourceKey = sourceKey;
        this.hardness = -1.0f;
        this.destroyable = false;
    }

    public String getConfig() {
        StringBuilder str = new StringBuilder();
        if (this.destroyable) {
            str.append("!");
        }
        if (!this.toolRequired) {
            str.append("?");
        }
        str.append(this.toolclass).append("=").append(this.level);
        if (this.hardness >= 0.0f) {
            str.append("@").append(this.hardness);
        }
        return str.toString();
    }

    public void addOverwrite(String toolClass, int level, boolean toolRequired, String key) {
        this.toolclass = toolClass;
        this.level = level;
        this.toolRequired = toolRequired;
        this.source = OverwriteSource.Single;
        this.sourceKey = key;
    }

    public void apply(IBlockState state) {
        if (this.hardness >= 0.0f) {
            state.func_177230_c().func_149711_c(this.hardness);
        }
        state.func_177230_c().setHarvestLevel(this.toolclass, this.level, state);
        ToolProgressionMod.logger.log(Level.INFO, String.format("Applying overwrite to block %s: %s %d", BlockHelper.getKeyString(state), this.toolclass, this.level));
    }

    public static enum OverwriteSource {
        OreDict(0),
        Wildcard(1),
        Single(2);

        private final int priority;

        private OverwriteSource(int priority) {
            this.priority = priority;
        }

        public boolean hasLessPriority(OverwriteSource source) {
            return this.priority <= source.priority;
        }
    }
}

