/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.config;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;
import tyra314.toolprogression.ToolProgressionMod;
import tyra314.toolprogression.harvest.MaterialOverwrite;

public class MaterialOverwriteConfig {
    private final Configuration cfg;
    private final Map<String, MaterialOverwrite> overwrites = new HashMap<String, MaterialOverwrite>();

    MaterialOverwriteConfig(Configuration file) {
        this.cfg = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            this.cfg.load();
            this.cfg.addCustomCategoryComment("material", "To add any overwrites, simply copy them over from the material.cfg");
            this.overwrites.clear();
            for (Map.Entry mat : this.cfg.getCategory("material").entrySet()) {
                MaterialOverwrite overwrite = MaterialOverwrite.readFromConfig(((Property)mat.getValue()).getString());
                this.overwrites.put((String)mat.getKey(), overwrite);
            }
        }
        catch (Exception e) {
            ToolProgressionMod.logger.log(Level.ERROR, "Problem loading material overwrites file!", (Throwable)e);
        }
        finally {
            if (this.cfg.hasChanged()) {
                this.cfg.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            this.cfg.addCustomCategoryComment("material", "To add any overwrites, simply copy them over from the material.cfg");
            ConfigCategory material = this.cfg.getCategory("material");
            material.clear();
            for (Map.Entry<String, MaterialOverwrite> entry : this.overwrites.entrySet()) {
                material.put(entry.getKey(), new Property(entry.getKey(), entry.getValue().getConfig(), Property.Type.STRING));
            }
        }
        catch (Exception e) {
            ToolProgressionMod.logger.log(Level.ERROR, "Problem saving material overwrites file!", (Throwable)e);
        }
        finally {
            this.cfg.save();
        }
    }

    public MaterialOverwrite get(String key) {
        if (this.overwrites.containsKey(key)) {
            return this.overwrites.get(key);
        }
        return null;
    }

    public MaterialOverwrite get(Item.ToolMaterial mat) {
        return this.get(mat.name().toLowerCase());
    }

    public void unset(String key) {
        this.overwrites.remove(key);
    }

    public void set(String key, MaterialOverwrite overwrite) {
        this.overwrites.put(key, overwrite);
    }
}

