/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.util;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.helpers.PatternHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.util.inventory.ThEInternalInventory;

public abstract class KnowledgeCoreUtil {
    private static final int SLOT_NUM = 9;

    public static void setRecipe(ItemStack knowledgeCoreStack, int slot, Recipe recipe) {
        String slotKey = String.valueOf(slot);
        NBTTagCompound nbt = knowledgeCoreStack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (recipe == null) {
            nbt.func_82580_o(slotKey);
            return;
        }
        NBTTagCompound nbtRecipe = new NBTTagCompound();
        nbtRecipe.func_74782_a("ingredients", (NBTBase)recipe.getIngredients().serializeNBT());
        nbtRecipe.func_74782_a("result", (NBTBase)recipe.getResult().serializeNBT());
        nbtRecipe.func_74776_a("visCost", recipe.getVisCost());
        nbt.func_74782_a(slotKey, (NBTBase)nbtRecipe);
        knowledgeCoreStack.func_77982_d(nbt);
    }

    public static Recipe getRecipe(ItemStack knowledgeCoreStack, int slot) {
        NBTTagCompound nbtRecipe = KnowledgeCoreUtil.getNBTRecipe(knowledgeCoreStack, slot);
        if (nbtRecipe == null) {
            return null;
        }
        ThEInternalInventory ingredients = new ThEInternalInventory("ingredients", 15, 64);
        ItemStack result = new ItemStack(nbtRecipe.func_74775_l("result"));
        ingredients.deserializeNBT(nbtRecipe.func_150295_c("ingredients", 10));
        return new Recipe(ingredients, result, nbtRecipe.func_74760_g("visCost"));
    }

    public static HashMap<ItemStack, ThEInternalInventory> getRecipeMap(ItemStack knowledgeCoreStack) {
        HashMap<ItemStack, ThEInternalInventory> recipeMap = new HashMap<ItemStack, ThEInternalInventory>();
        for (int i = 0; i < 9; ++i) {
            Recipe recipe = KnowledgeCoreUtil.getRecipe(knowledgeCoreStack, i);
            if (recipe == null) continue;
            recipeMap.put(recipe.result, recipe.ingredients);
        }
        return recipeMap;
    }

    @Nullable
    public static Recipe getRecipe(ItemStack knowledgeCoreStack, ItemStack result) {
        for (int i = 0; i < 9; ++i) {
            Recipe recipe = KnowledgeCoreUtil.getRecipe(knowledgeCoreStack, i);
            if (recipe == null || !recipe.getResult().func_77973_b().equals(result.func_77973_b())) continue;
            return recipe;
        }
        return null;
    }

    public static Stream<Recipe> recipeStreamOf(ItemStack knowledgeCore) {
        ArrayList<Recipe> recipeArrayList = new ArrayList<Recipe>();
        for (int i = 0; i < 9; ++i) {
            recipeArrayList.add(KnowledgeCoreUtil.getRecipe(knowledgeCore, i));
        }
        return recipeArrayList.stream().filter(Objects::nonNull);
    }

    public static boolean hasRecipe(ItemStack knowledgeCoreStack, Item result) {
        return KnowledgeCoreUtil.getRecipeMap(knowledgeCoreStack).keySet().stream().map(ItemStack::func_77973_b).anyMatch(item -> item.equals(result));
    }

    public static boolean hasRecipe(ItemStack knowledgeCoreStack, int slot) {
        return KnowledgeCoreUtil.getNBTRecipe(knowledgeCoreStack, slot) != null;
    }

    public static boolean isEmpty(ItemStack knowledgeCoreStack) {
        NBTTagCompound nbt = knowledgeCoreStack.func_77978_p();
        if (nbt == null) {
            return true;
        }
        return nbt.func_82582_d();
    }

    private static NBTTagCompound getNBTRecipe(ItemStack knowledgeCoreStack, int slot) {
        String slotKey = String.valueOf(slot);
        NBTTagCompound nbt = knowledgeCoreStack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(slotKey)) {
            return null;
        }
        return nbt.func_74775_l(slotKey);
    }

    public static ICraftingPatternDetails getAEPattern(ItemStack knowledgeCore, int slot, World world) {
        Recipe recipe = KnowledgeCoreUtil.getRecipe(knowledgeCore, slot);
        return KnowledgeCoreUtil.getAEPattern(recipe, world);
    }

    public static ICraftingPatternDetails getAEPattern(Recipe recipe, World world) {
        ItemStack AEPatternStack = recipe == null ? (ItemStack)ThEApi.instance().items().knowledgeCore().maybeStack(1).orElseThrow(RuntimeException::new) : recipe.toAEPatternStack();
        return new PatternHelper(AEPatternStack, world);
    }

    public static class Recipe {
        private final ThEInternalInventory ingredients;
        private final ItemStack result;
        private final float visCost;

        public Recipe(ThEInternalInventory ingredients, ItemStack result, float visCost) {
            this.ingredients = ingredients;
            this.result = result.func_77946_l();
            this.visCost = visCost;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public ThEInternalInventory getIngredients() {
            return this.ingredients;
        }

        public ThEInternalInventory getIngredientPart(boolean aspect) {
            ThEInternalInventory ingredients;
            ThEInternalInventory ingredientsWithAspect = this.getIngredients();
            if (aspect) {
                ingredients = new ThEInternalInventory("ingredients", 6, 64);
                for (int i = 0; i < 6; ++i) {
                    ingredients.func_70299_a(i, ingredientsWithAspect.func_70301_a(i + 9));
                }
            } else {
                ingredients = new ThEInternalInventory("ingredients", 9, 64);
                for (int i = 0; i < 9; ++i) {
                    ingredients.func_70299_a(i, ingredientsWithAspect.func_70301_a(i));
                }
            }
            return ingredients;
        }

        public float getVisCost() {
            return this.visCost;
        }

        public ItemStack toAEPatternStack() {
            ItemStack stack = (ItemStack)ThEApi.instance().items().knowledgeCore().maybeStack(1).orElseThrow(RuntimeException::new);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("in", (NBTBase)this.getIngredientPart(false).serializeNBT(true));
            NBTTagList out = new NBTTagList();
            out.func_74742_a((NBTBase)this.getResult().serializeNBT());
            nbt.func_74782_a("out", (NBTBase)out);
            nbt.func_74757_a("crafting", false);
            nbt.func_74757_a("substitute", false);
            stack.func_77982_d(nbt);
            return stack;
        }
    }
}

