/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command.modules;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.command.CommandModule;
import me.lucko.spark.common.command.CommandResponseHandler;
import me.lucko.spark.common.monitor.memory.GarbageCollectionMonitor;
import me.lucko.spark.common.monitor.memory.GarbageCollectorStatistics;
import me.lucko.spark.common.util.FormatUtil;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.format.NamedTextColor;
import me.lucko.spark.lib.adventure.text.format.TextColor;
import me.lucko.spark.lib.adventure.text.format.TextDecoration;

public class GcMonitoringModule
implements CommandModule {
    private static final DecimalFormat DF = new DecimalFormat("#.##");
    private ReportingGcMonitor activeGcMonitor = null;

    @Override
    public void close() {
        if (this.activeGcMonitor != null) {
            this.activeGcMonitor.close();
            this.activeGcMonitor = null;
        }
    }

    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("gc").executor((platform, sender, resp, arguments) -> {
            resp.replyPrefixed(Component.text("Calculating GC statistics..."));
            LinkedList<Object> report = new LinkedList<Object>();
            report.add(Component.empty());
            report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("Garbage Collector statistics", (TextColor)NamedTextColor.GOLD))).build());
            long serverUptime = System.currentTimeMillis() - platform.getServerNormalOperationStartTime();
            Map<String, GarbageCollectorStatistics> collectorStats = GarbageCollectorStatistics.pollStatsSubtractInitial(platform.getStartupGcStatistics());
            for (Map.Entry<String, GarbageCollectorStatistics> collector : collectorStats.entrySet()) {
                String collectorName = collector.getKey();
                double collectionTime = collector.getValue().getCollectionTime();
                long collectionCount = collector.getValue().getCollectionCount();
                report.add(Component.empty());
                if (collectionCount == 0L) {
                    report.add(((TextComponent.Builder)Component.text().content("    ").append((Component)Component.text(collectorName + " collector:", (TextColor)NamedTextColor.GRAY))).build());
                    report.add(((TextComponent.Builder)((TextComponent.Builder)Component.text().content("      ").append((Component)Component.text(0, (TextColor)NamedTextColor.WHITE))).append((Component)Component.text(" collections", (TextColor)NamedTextColor.GRAY))).build());
                    continue;
                }
                double averageCollectionTime = collectionTime / (double)collectionCount;
                double averageFrequency = ((double)serverUptime - collectionTime) / (double)collectionCount;
                report.add(((TextComponent.Builder)Component.text().content("    ").append((Component)Component.text(collectorName + " collector:", (TextColor)NamedTextColor.GRAY))).build());
                report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("      ").append((Component)Component.text(DF.format(averageCollectionTime), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" ms avg", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text(", ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(collectionCount, (TextColor)NamedTextColor.WHITE))).append((Component)Component.text(" total collections", (TextColor)NamedTextColor.GRAY))).build());
                report.add(((TextComponent.Builder)((TextComponent.Builder)Component.text().content("      ").append((Component)Component.text(GcMonitoringModule.formatTime((long)averageFrequency), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text(" avg frequency", (TextColor)NamedTextColor.GRAY))).build());
            }
            if (collectorStats.isEmpty()) {
                resp.replyPrefixed(Component.text("No garbage collectors are reporting data."));
            } else {
                report.forEach(resp::reply);
            }
        }).build());
        consumer.accept(Command.builder().aliases("gcmonitor", "gcmonitoring").executor((platform, sender, resp, arguments) -> {
            if (this.activeGcMonitor == null) {
                this.activeGcMonitor = new ReportingGcMonitor(platform, resp);
                resp.broadcastPrefixed(Component.text("GC monitor enabled."));
            } else {
                this.close();
                resp.broadcastPrefixed(Component.text("GC monitor disabled."));
            }
        }).build());
    }

    private static String formatTime(long millis) {
        if (millis <= 0L) {
            return "0s";
        }
        long second = millis / 1000L;
        long minute = second / 60L;
        second %= 60L;
        StringBuilder sb = new StringBuilder();
        if (minute != 0L) {
            sb.append(minute).append("m ");
        }
        if (second != 0L) {
            sb.append(second).append("s ");
        }
        return sb.toString().trim();
    }

    private static class ReportingGcMonitor
    extends GarbageCollectionMonitor
    implements GarbageCollectionMonitor.Listener {
        private final SparkPlatform platform;
        private final CommandResponseHandler resp;

        ReportingGcMonitor(SparkPlatform platform, CommandResponseHandler resp) {
            this.platform = platform;
            this.resp = resp;
            this.addListener(this);
        }

        protected void sendMessage(Component message) {
            this.resp.broadcastPrefixed(message);
        }

        @Override
        public void onGc(GarbageCollectionNotificationInfo data) {
            String gcType = GarbageCollectionMonitor.getGcType(data);
            String gcCause = data.getGcCause() != null ? " (cause = " + data.getGcCause() + ")" : "";
            Map<String, MemoryUsage> beforeUsages = data.getGcInfo().getMemoryUsageBeforeGc();
            Map<String, MemoryUsage> afterUsages = data.getGcInfo().getMemoryUsageAfterGc();
            this.platform.getPlugin().executeAsync(() -> {
                LinkedList<Object> report = new LinkedList<Object>();
                report.add(CommandResponseHandler.applyPrefix((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text(gcType + " "))).append((Component)Component.text("GC", (TextColor)NamedTextColor.RED))).append((Component)Component.text(" lasting "))).append((Component)Component.text(DF.format(data.getGcInfo().getDuration()), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" ms." + gcCause))).build()));
                for (Map.Entry entry : afterUsages.entrySet()) {
                    long diff;
                    String type = (String)entry.getKey();
                    MemoryUsage after = (MemoryUsage)entry.getValue();
                    MemoryUsage before = (MemoryUsage)beforeUsages.get(type);
                    if (before == null || (diff = before.getUsed() - after.getUsed()) == 0L) continue;
                    if (diff > 0L) {
                        report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("  ").append((Component)Component.text(FormatUtil.formatBytes(diff), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" freed from ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(type, (TextColor)NamedTextColor.GRAY))).build());
                        report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)Component.text(FormatUtil.formatBytes(before.getUsed()), (TextColor)NamedTextColor.GRAY))).append((Component)Component.text(" \u2192 ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(FormatUtil.formatBytes(after.getUsed()), (TextColor)NamedTextColor.GRAY))).append((Component)Component.space())).append((Component)Component.text("(", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(FormatUtil.percent(diff, before.getUsed()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text(")", (TextColor)NamedTextColor.DARK_GRAY))).build());
                        continue;
                    }
                    report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("  ").append((Component)Component.text(FormatUtil.formatBytes(-diff), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" moved to ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(type, (TextColor)NamedTextColor.GRAY))).build());
                    report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)Component.text(FormatUtil.formatBytes(before.getUsed()), (TextColor)NamedTextColor.GRAY))).append((Component)Component.text(" \u2192 ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(FormatUtil.formatBytes(after.getUsed()), (TextColor)NamedTextColor.GRAY))).build());
                }
                report.forEach(this.resp::broadcast);
            });
        }
    }
}

