/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.world;

import epicsquid.mysticallib.world.IOreGenerator;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.materials.Materials;
import epicsquid.mysticalworld.world.WorldGenMinableDebug;
import epicsquid.mysticalworld.world.WorldGenMinableGraniteDebug;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class OreGenerator
implements IOreGenerator {
    private void generateOre(String oreName, @Nonnull IBlockState ore, @Nonnull World world, @Nonnull Random random, int x, int z, int minY, int maxY, int size, int numberToGenerate) {
        for (int i = 0; i < numberToGenerate; ++i) {
            BlockPos pos = new BlockPos(x * 16 + random.nextInt(16), random.nextInt(maxY - minY) + minY, z * 16 + random.nextInt(16));
            WorldGenMinableDebug generator = new WorldGenMinableDebug(oreName, ore, size);
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generateGraniteOre(String oreName, @Nonnull IBlockState ore, @Nonnull World world, @Nonnull Random random, int x, int z, int minY, int maxY, int size, int numberToGenerate) {
        for (int i = 0; i < numberToGenerate; ++i) {
            BlockPos pos = new BlockPos(x * 16 + random.nextInt(16), random.nextInt(maxY - minY) + minY, z * 16 + random.nextInt(16));
            WorldGenMinableGraniteDebug generator = new WorldGenMinableGraniteDebug(oreName, ore, size, numberToGenerate);
            generator.func_180709_b(world, random, pos);
        }
    }

    public void generate(@Nonnull Random random, int chunkX, int chunkZ, @Nonnull World world, @Nonnull IChunkGenerator chunkGenerator, @Nonnull IChunkProvider chunkProvider) {
        if (ConfigManager.oreGen.getSpawnDimensions().contains(world.field_73011_w.getDimension())) {
            if (ConfigManager.quartz.enableQuartz) {
                if (ConfigManager.quartz.enableGraniteOres) {
                    this.generateGraniteOre(Materials.quartz.getOredictNameSuffix(), Objects.requireNonNull(Materials.quartz.getOre()).func_176223_P(), world, random, chunkX, chunkZ, ConfigManager.oreGen.quartzMinY, ConfigManager.oreGen.quartzMaxY, ConfigManager.oreGen.quartzVeinSize, ConfigManager.oreGen.quartzPerChunk);
                } else if (ConfigManager.quartz.enableStoneOres) {
                    this.generateOre(Materials.quartz.getOredictNameSuffix(), Objects.requireNonNull(Materials.quartz.getOre()).func_176223_P(), world, random, chunkX, chunkZ, ConfigManager.oreGen.quartzMinY, ConfigManager.oreGen.quartzMaxY, ConfigManager.oreGen.quartzVeinSize, ConfigManager.oreGen.quartzPerChunk);
                }
            }
            if (ConfigManager.copper.enableCopper && ConfigManager.copper.enableOres) {
                this.generateOre(Materials.copper.getOredictNameSuffix(), Objects.requireNonNull(Materials.copper.getOre()).func_176223_P(), world, random, chunkX, chunkZ, ConfigManager.oreGen.copperMinY, ConfigManager.oreGen.copperMaxY, ConfigManager.oreGen.copperVeinSize, ConfigManager.oreGen.copperPerChunk);
            }
            if (ConfigManager.silver.enableSilver && ConfigManager.silver.enableOres) {
                this.generateOre(Materials.silver.getOredictNameSuffix(), Objects.requireNonNull(Materials.silver.getOre()).func_176223_P(), world, random, chunkX, chunkZ, ConfigManager.oreGen.silverMinY, ConfigManager.oreGen.silverMaxY, ConfigManager.oreGen.silverVeinSize, ConfigManager.oreGen.silverPerChunk);
            }
            if (ConfigManager.amethyst.enableAmethyst && ConfigManager.amethyst.enableOres) {
                this.generateOre(Materials.amethyst.getOredictNameSuffix(), Objects.requireNonNull(Materials.amethyst.getOre()).func_176223_P(), world, random, chunkX, chunkZ, ConfigManager.oreGen.amethystMinY, ConfigManager.oreGen.amethystMaxY, ConfigManager.oreGen.amethystVeinSize, ConfigManager.oreGen.amethystPerChunk);
            }
        }
    }
}

