/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.events;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticalworld.capability.AnimalCooldownCapabilityProvider;
import epicsquid.mysticalworld.capability.PlayerShoulderCapability;
import epicsquid.mysticalworld.capability.PlayerShoulderCapabilityProvider;
import epicsquid.mysticalworld.network.MessagePlayerShoulderUpdate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="mysticalworld")
public class CapabilityHandler {
    @SubscribeEvent
    public static void attackCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntitySquid) {
            event.addCapability(AnimalCooldownCapabilityProvider.IDENTIFIER, (ICapabilityProvider)new AnimalCooldownCapabilityProvider());
        } else if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(PlayerShoulderCapabilityProvider.IDENTIFIER, (ICapabilityProvider)new PlayerShoulderCapabilityProvider());
        }
    }

    @SubscribeEvent
    public void onTracking(PlayerEvent.StartTracking event) {
        PlayerShoulderCapability cap;
        Entity target = event.getTarget();
        EntityPlayer victim = event.getEntityPlayer();
        if (target instanceof EntityPlayerMP && (cap = (PlayerShoulderCapability)target.getCapability(PlayerShoulderCapabilityProvider.PLAYER_SHOULDER_CAPABILITY, null)) != null) {
            MessagePlayerShoulderUpdate packet = new MessagePlayerShoulderUpdate((EntityPlayer)target, cap);
            PacketHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)victim);
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        EntityPlayerMP player;
        PlayerShoulderCapability cap;
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerMP && (cap = (PlayerShoulderCapability)(player = (EntityPlayerMP)entity).getCapability(PlayerShoulderCapabilityProvider.PLAYER_SHOULDER_CAPABILITY, null)) != null) {
            MessagePlayerShoulderUpdate packet = new MessagePlayerShoulderUpdate((EntityPlayer)player, cap);
            PacketHandler.INSTANCE.sendTo((IMessage)packet, player);
        }
    }
}

