/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting;

import com.google.common.collect.Iterables;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ActiveMachineRecipe {
    private final MachineRecipe recipe;
    private int tick = 0;

    public ActiveMachineRecipe(MachineRecipe recipe) {
        this.recipe = recipe;
    }

    public ActiveMachineRecipe(NBTTagCompound serialized) {
        this.recipe = RecipeRegistry.getRegistry().getRecipe(new ResourceLocation(serialized.func_74779_i("recipeName")));
        this.tick = serialized.func_74762_e("tick");
    }

    public void reset() {
        this.tick = 0;
    }

    public MachineRecipe getRecipe() {
        return this.recipe;
    }

    @Nonnull
    public TileMachineController.CraftingStatus tick(RecipeCraftingContext context) {
        RecipeCraftingContext.CraftingCheckResult check = context.ioTick(this.tick);
        if (!check.isFailure()) {
            ++this.tick;
            return TileMachineController.CraftingStatus.working();
        }
        this.tick = 0;
        return TileMachineController.CraftingStatus.failure((String)Iterables.getFirst(check.getUnlocalizedErrorMessages(), (Object)""));
    }

    public int getTick() {
        return this.tick;
    }

    public boolean isCompleted(TileMachineController controller, RecipeCraftingContext context) {
        int time = this.recipe.getRecipeTotalTickTime();
        time = Math.round(RecipeModifier.applyModifiers(context.getModifiers("duration"), "duration", null, time, false));
        return this.tick >= time;
    }

    public void complete(RecipeCraftingContext completionContext) {
        completionContext.finishCrafting();
    }

    public NBTTagCompound serialize() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("tick", this.tick);
        tag.func_74778_a("recipeName", this.recipe.getRegistryName().toString());
        return tag;
    }
}

