/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.block.prop;

import gregtech.api.GTValues;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import javax.annotation.Nonnull;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;

public enum EnergyHatchSize implements IStringSerializable
{
    TINY(2048, 1, 128, 1, 2),
    SMALL(4096, 2, 512, 2, 2),
    NORMAL(8192, 2, 512, 2, 2),
    REINFORCED(16384, 3, 2048, 3, 2),
    BIG(32768, 4, 8192, 4, 2),
    HUGE(131072, 5, 32768, 5, 2),
    LUDICROUS(524288, 6, 131072, 6, 2),
    ULTIMATE(0x200000, 6, 131072, 6, 2);

    public long maxEnergy;
    public long transferLimit;
    public int ic2EnergyTier;
    public int gtEnergyTier;
    public int gtAmperage;
    private final int defaultConfigurationEnergy;
    private final int defaultConfigurationTransferLimit;
    private final int defaultIC2EnergyTier;
    private final int defaultGTEnergyTier;
    private final int defaultGTAmperage;

    private EnergyHatchSize(int maxEnergy, int ic2EnergyTier, int transferLimit, int gtEnergyTier, int gtAmperage) {
        this.defaultConfigurationEnergy = maxEnergy;
        this.defaultIC2EnergyTier = ic2EnergyTier;
        this.defaultConfigurationTransferLimit = transferLimit;
        this.defaultGTEnergyTier = gtEnergyTier;
        this.defaultGTAmperage = gtAmperage;
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    @Nonnull
    public String getUnlocalizedEnergyDescriptor() {
        return "tooltip.ic2.powertier." + this.ic2EnergyTier + ".name";
    }

    public int getGTEnergyTier() {
        return MathHelper.func_76125_a((int)this.gtEnergyTier, (int)0, (int)8);
    }

    public int getGtAmperage() {
        return this.gtAmperage;
    }

    @Optional.Method(modid="gregtech")
    public String getUnlocalizedGTEnergyTier() {
        return GTValues.VN[this.getGTEnergyTier()];
    }

    public long getGTEnergyTransferVoltage() {
        if (this.getGTEnergyTier() < 0) {
            return -1L;
        }
        return (int)Math.pow(2.0, (this.getGTEnergyTier() + 1) * 2 + 1);
    }

    public int getIC2EnergyTransmission() {
        if (this.ic2EnergyTier < 0) {
            return -1;
        }
        return (int)Math.pow(2.0, (this.ic2EnergyTier + 1) * 2 + 1);
    }

    public static void loadFromConfig(Configuration cfg) {
        for (EnergyHatchSize size : EnergyHatchSize.values()) {
            size.maxEnergy = cfg.get("energyhatch.size", size.name().toUpperCase(), size.defaultConfigurationEnergy + "", "Energy storage size of the energy hatch. [range: 0 ~ 9223372036854775807, default: " + size.defaultConfigurationEnergy + "]").getLong();
            size.maxEnergy = MiscUtils.clamp(size.maxEnergy, 1L, Long.MAX_VALUE);
            size.transferLimit = cfg.get("energyhatch.limit", size.name().toUpperCase(), size.defaultConfigurationTransferLimit + "", "Defines the transfer limit for RF/FE things. IC2's transfer limit is defined by the voltage tier. [range: 1 ~ 9223372036854775806, default: " + size.defaultConfigurationEnergy + "]").getLong();
            size.transferLimit = MiscUtils.clamp(size.transferLimit, 1L, 0x7FFFFFFFFFFFFFFEL);
            size.ic2EnergyTier = cfg.get("energyhatch.tier", size.name().toUpperCase(), size.defaultIC2EnergyTier, "Defines the IC2 output-voltage tier. Only affects the power the output hatches will output power as. 0 = 'ULV' = 8 EU/t, 1 = 'LV' = 32 EU/t, 2 = 'MV' = 128 EU/t, ... [range: 0 ~ 12, default: " + size.defaultIC2EnergyTier + "]").getInt();
            size.gtEnergyTier = cfg.get("energyhatch.gtvoltage", size.name().toUpperCase(), size.defaultGTEnergyTier, "Defines the GT voltage tier. Affects both input and output hatches of this tier. [range: 0 ~ 8, default: " + size.defaultGTEnergyTier + "]").getInt();
            size.gtEnergyTier = MathHelper.func_76125_a((int)size.gtEnergyTier, (int)0, (int)8);
            size.gtAmperage = cfg.get("energyhatch.gtamperage", size.name().toUpperCase(), size.defaultGTAmperage, "Defines the GT amperage. Affects both output amperage as well as maximum input amperage. [range: 1 ~ 16, default: " + size.defaultGTAmperage + "]").getInt();
            size.gtAmperage = MathHelper.func_76125_a((int)size.gtAmperage, (int)1, (int)16);
        }
    }
}

