/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.worldgen.structure.underworld;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import sblectric.lightningcraft.dimensions.ChunkProviderUnderworld;
import sblectric.lightningcraft.entities.EntityUnderworldSilverfish;
import sblectric.lightningcraft.init.LCBlocks;
import sblectric.lightningcraft.init.LCItems;
import sblectric.lightningcraft.ref.RefMisc;
import sblectric.lightningcraft.util.IntList;
import sblectric.lightningcraft.util.WeightedRandomChestContent;
import sblectric.lightningcraft.util.WorldUtils;
import sblectric.lightningcraft.worldgen.structure.Feature;
import sblectric.lightningcraft.worldgen.structure.LootChestGroup;

public class UnderworldRampart
extends Feature {
    private static final int nChests = 5;
    private static final int minStacks = 2;
    private static final int maxStacks = 5;
    private static final Block mainBlock = LCBlocks.stoneBlock;
    private static final int mainMeta = 1;
    private static final int secMeta = 7;
    private static final Block stairBlock = LCBlocks.thunderStairs;
    private static final Block slabBlock = LCBlocks.slabBlock;
    private static final int slabMeta = 0;
    private static final Block lightBlock = LCBlocks.lightBlock;
    private static final Block windowBlock = Blocks.field_150411_aY;
    private static final Block lapisBlock = LCBlocks.stoneBlock;
    private static final int lapisMeta = 8;
    private static final Block wallBlock = LCBlocks.wallBlock;
    private static final Block ladderBlock = Blocks.field_150468_ap;
    private static final Block cannonBlock = LCBlocks.lightningCannon;
    private static final Block accentBlock = Blocks.field_150343_Z;
    private static final Block tntBlock = LCBlocks.underTNT;
    private static final Block weakBlock = LCBlocks.corruptStone;

    public UnderworldRampart() {
        this(new Random(), 0, 0);
    }

    public UnderworldRampart(Random rand, int x, int z) {
        super(rand, x, 64, z, 51, 30, 51, false);
        this.spawnMinY = 190;
        this.spawnMaxY = 240;
        this.lootChests = new LootChestGroup(5, 2, 5, new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151153_ao, 0, 1, 3, 5), new WeightedRandomChestContent(Items.field_151061_bv, 0, 1, 8, 15), new WeightedRandomChestContent(LCItems.ingot, 0, 2, 7, 20), new WeightedRandomChestContent(Items.field_151166_bC, 0, 1, 3, 20), new WeightedRandomChestContent(LCItems.golfClub, 0, 1, 1, 8), new WeightedRandomChestContent(Items.field_151042_j, 0, 3, 7, 20), new WeightedRandomChestContent(Items.field_151043_k, 0, 3, 7, 20), new WeightedRandomChestContent(Items.field_151012_L, 0, 1, 1, 1), new WeightedRandomChestContent((Item)LCItems.skySword, 0, 1, 1, 1), new WeightedRandomChestContent((Item)LCItems.skyAxe, 0, 1, 1, 1), new WeightedRandomChestContent((Item)LCItems.elecSword, 0, 1, 1, 1)});
        this.lootChests.setChestContents(2, new WeightedRandomChestContent[]{new WeightedRandomChestContent(LCItems.material, 11, 10, 30, 100)});
        this.lootChests.setIsTrapped(2, true);
        this.lootChests.setStackMinMax(2, 1, 1);
    }

    @Override
    protected boolean findSpawnPosition(World world, StructureBoundingBox box, int yoff) {
        if (this.structY >= 0) {
            if (RefMisc.DEBUG) {
                System.out.println("Structure already exists @ (" + this.field_74887_e.field_78897_a + ", " + this.field_74887_e.field_78896_c + ")");
            }
            return true;
        }
        if (RefMisc.DEBUG) {
            System.out.println("Spawn check initiated at (" + this.field_74887_e.field_78897_a + ", " + this.field_74887_e.field_78896_c + ")");
        }
        int xCenter = WorldUtils.getStructureCenter(this.field_74887_e).func_177958_n();
        int zCenter = WorldUtils.getStructureCenter(this.field_74887_e).func_177952_p();
        ChunkProviderUnderworld.rampartLoadingExtraChunks = true;
        try {
            for (int i = -4; !WorldUtils.checkChunksExist(world, this.field_74887_e.field_78897_a, this.spawnMinY, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.spawnMaxY, this.field_74887_e.field_78892_f) && i <= 4; ++i) {
                for (int j = -4; !WorldUtils.checkChunksExist(world, this.field_74887_e.field_78897_a, 0, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, 255, this.field_74887_e.field_78892_f) && j <= 4; ++j) {
                    if (world.func_72863_F().func_186026_b(this.field_74887_e.field_78897_a / 16 + i, this.field_74887_e.field_78896_c / 16 + j) == null) continue;
                    world.func_72863_F().func_186025_d(this.field_74887_e.field_78897_a / 16 + i, this.field_74887_e.field_78896_c / 16 + j);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Underworld Rampart chunk error occurred: crash averted");
        }
        ChunkProviderUnderworld.rampartLoadingExtraChunks = false;
        Integer s1 = WorldUtils.getOpenCeiling(world, this.field_74887_e.field_78897_a, zCenter, this.spawnMinY, this.spawnMaxY, 4);
        Integer s2 = WorldUtils.getOpenCeiling(world, xCenter, this.field_74887_e.field_78896_c, this.spawnMinY, this.spawnMaxY, 4);
        Integer s3 = WorldUtils.getOpenCeiling(world, this.field_74887_e.field_78893_d, zCenter, this.spawnMinY, this.spawnMaxY, 4);
        Integer s4 = WorldUtils.getOpenCeiling(world, xCenter, this.field_74887_e.field_78892_f, this.spawnMinY, this.spawnMaxY, 4);
        Integer middle = WorldUtils.getOpenCeiling(world, xCenter, zCenter, this.spawnMinY, this.spawnMaxY, this.scatteredFeatureSizeY);
        if (s1 != null && s2 != null && s3 != null && s4 != null && middle != null) {
            IntList l = (IntList)new IntList().join(s1, s2, s3, s4);
            if (l.variance() <= 10) {
                this.structY = l.max() + 2 - this.scatteredFeatureSizeY;
                if (RefMisc.DEBUG) {
                    System.out.println("Spawn success at position (" + this.field_74887_e.field_78897_a + ", " + this.spawnMinY + ", " + this.field_74887_e.field_78896_c + ")");
                }
                this.field_74887_e.func_78886_a(0, this.structY - this.field_74887_e.field_78895_b + yoff, 0);
                return true;
            }
            if (RefMisc.DEBUG) {
                System.out.println("Too much variance (" + l.variance() + ")");
            }
        } else if (RefMisc.DEBUG) {
            System.out.println("Structure point(s) missing");
        }
        if (RefMisc.DEBUG) {
            System.out.println("Spawn failed at position (" + this.field_74887_e.field_78897_a + ", " + this.field_74887_e.field_78896_c + ")");
        }
        return false;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
        if (!this.findSpawnPosition(world, box, 0)) {
            return false;
        }
        this.addBlock(world, 0, 29, 24, stairBlock, 4);
        this.addBlock(world, 0, 29, 26, stairBlock, 4);
        this.addBlock(world, 1, 28, 24, stairBlock, 4);
        this.addBlock(world, 1, 28, 26, stairBlock, 4);
        this.addBlock(world, 1, 29, 24, lapisBlock, 8);
        this.addBlock(world, 1, 29, 26, lapisBlock, 8);
        this.addBlock(world, 1, 30, 24, stairBlock, 1);
        this.addBlock(world, 1, 30, 26, stairBlock, 1);
        this.addBlock(world, 2, 27, 24, stairBlock, 4);
        this.addBlock(world, 2, 27, 26, stairBlock, 4);
        this.addBlock(world, 2, 28, 24, lapisBlock, 8);
        this.addBlock(world, 2, 28, 26, lapisBlock, 8);
        this.addBlock(world, 2, 29, 24, stairBlock, 1);
        this.addBlock(world, 2, 29, 26, stairBlock, 1);
        this.addBlock(world, 3, 26, 24, stairBlock, 4);
        this.addBlock(world, 3, 26, 26, stairBlock, 4);
        this.addBlock(world, 3, 27, 24, lapisBlock, 8);
        this.addBlock(world, 3, 27, 26, lapisBlock, 8);
        this.addBlock(world, 3, 28, 24, stairBlock, 1);
        this.addBlock(world, 3, 28, 26, stairBlock, 1);
        this.addBlock(world, 4, 25, 24, stairBlock, 4);
        this.addBlock(world, 4, 25, 26, stairBlock, 4);
        this.addBlock(world, 4, 26, 24, lapisBlock, 8);
        this.addBlock(world, 4, 26, 26, lapisBlock, 8);
        this.addBlock(world, 4, 27, 24, stairBlock, 1);
        this.addBlock(world, 4, 27, 26, stairBlock, 1);
        this.addBlock(world, 5, 24, 24, stairBlock, 4);
        this.addBlock(world, 5, 24, 26, stairBlock, 4);
        this.addBlock(world, 5, 25, 24, lapisBlock, 8);
        this.addBlock(world, 5, 25, 26, lapisBlock, 8);
        this.addBlock(world, 5, 26, 24, stairBlock, 1);
        this.addBlock(world, 5, 26, 26, stairBlock, 1);
        this.addBlock(world, 6, 13, 25, mainBlock, 1);
        this.addBlock(world, 6, 14, 25, cannonBlock, 0);
        this.addBlock(world, 6, 23, 24, stairBlock, 4);
        this.addBlock(world, 6, 23, 26, stairBlock, 4);
        this.addBlock(world, 6, 24, 24, lapisBlock, 8);
        this.addBlock(world, 6, 24, 26, lapisBlock, 8);
        this.addBlock(world, 6, 25, 24, stairBlock, 1);
        this.addBlock(world, 6, 25, 26, stairBlock, 1);
        this.addBlock(world, 7, 13, 25, mainBlock, 1);
        this.addBlock(world, 7, 22, 24, stairBlock, 4);
        this.addBlock(world, 7, 22, 26, stairBlock, 4);
        this.addBlock(world, 7, 23, 24, lapisBlock, 8);
        this.addBlock(world, 7, 23, 26, lapisBlock, 8);
        this.addBlock(world, 7, 24, 24, stairBlock, 1);
        this.addBlock(world, 7, 24, 26, stairBlock, 1);
        this.addBlock(world, 8, 10, 25, stairBlock, 4);
        this.addBlock(world, 8, 11, 25, mainBlock, 7);
        this.addBlock(world, 8, 12, 24, stairBlock, 4);
        this.addBlock(world, 8, 12, 25, mainBlock, 7);
        this.addBlock(world, 8, 12, 26, stairBlock, 4);
        this.addBlock(world, 8, 13, 24, mainBlock, 1);
        this.addBlock(world, 8, 13, 25, mainBlock, 1);
        this.addBlock(world, 8, 13, 26, mainBlock, 1);
        this.addBlock(world, 8, 14, 24, mainBlock, 1);
        this.addBlock(world, 8, 14, 25, stairBlock, 0);
        this.addBlock(world, 8, 14, 26, mainBlock, 1);
        this.addBlock(world, 8, 15, 24, mainBlock, 1);
        this.addBlock(world, 8, 15, 25, windowBlock, 0);
        this.addBlock(world, 8, 15, 26, mainBlock, 1);
        this.addBlock(world, 8, 16, 24, mainBlock, 1);
        this.addBlock(world, 8, 16, 25, windowBlock, 0);
        this.addBlock(world, 8, 16, 26, mainBlock, 1);
        this.addBlock(world, 8, 17, 24, mainBlock, 1);
        this.addBlock(world, 8, 17, 25, windowBlock, 0);
        this.addBlock(world, 8, 17, 26, mainBlock, 1);
        this.addBlock(world, 8, 18, 24, stairBlock, 0);
        this.addBlock(world, 8, 18, 25, stairBlock, 4);
        this.addBlock(world, 8, 18, 26, stairBlock, 0);
        this.addBlock(world, 8, 19, 25, stairBlock, 0);
        this.addBlock(world, 8, 21, 24, stairBlock, 4);
        this.addBlock(world, 8, 21, 26, stairBlock, 4);
        this.addBlock(world, 8, 22, 24, lapisBlock, 8);
        this.addBlock(world, 8, 22, 26, lapisBlock, 8);
        this.addBlock(world, 8, 23, 24, stairBlock, 1);
        this.addBlock(world, 8, 23, 26, stairBlock, 1);
        this.addBlock(world, 9, 8, 25, stairBlock, 4);
        this.addBlock(world, 9, 9, 24, slabBlock, 8);
        this.addBlock(world, 9, 9, 25, lapisBlock, 8);
        this.addBlock(world, 9, 9, 26, slabBlock, 8);
        this.addBlock(world, 9, 10, 24, mainBlock, 7);
        this.addBlock(world, 9, 10, 26, mainBlock, 7);
        this.addBlock(world, 9, 11, 24, mainBlock, 7);
        this.addBlock(world, 9, 11, 26, mainBlock, 7);
        this.addBlock(world, 9, 12, 23, stairBlock, 6);
        this.addBlock(world, 9, 12, 24, mainBlock, 7);
        this.addBlock(world, 9, 12, 26, mainBlock, 7);
        this.addBlock(world, 9, 12, 27, stairBlock, 7);
        this.addBlock(world, 9, 13, 23, mainBlock, 1);
        this.addBlock(world, 9, 13, 24, mainBlock, 1);
        this.addBlock(world, 9, 13, 25, mainBlock, 1);
        this.addBlock(world, 9, 13, 26, mainBlock, 1);
        this.addBlock(world, 9, 13, 27, mainBlock, 1);
        this.addBlock(world, 9, 14, 23, mainBlock, 1);
        this.addBlock(world, 9, 14, 27, mainBlock, 1);
        this.addBlock(world, 9, 15, 23, mainBlock, 1);
        this.addBlock(world, 9, 15, 27, mainBlock, 1);
        this.addBlock(world, 9, 16, 23, mainBlock, 1);
        this.addBlock(world, 9, 16, 27, mainBlock, 1);
        this.addBlock(world, 9, 17, 23, mainBlock, 1);
        this.addBlock(world, 9, 17, 27, mainBlock, 1);
        this.addBlock(world, 9, 18, 23, stairBlock, 2);
        this.addBlock(world, 9, 18, 24, stairBlock, 5);
        this.addBlock(world, 9, 18, 26, stairBlock, 5);
        this.addBlock(world, 9, 18, 27, stairBlock, 3);
        this.addBlock(world, 9, 19, 24, mainBlock, 7);
        this.addBlock(world, 9, 19, 25, mainBlock, 7);
        this.addBlock(world, 9, 19, 26, mainBlock, 7);
        this.addBlock(world, 9, 20, 24, stairBlock, 4);
        this.addBlock(world, 9, 20, 25, stairBlock, 0);
        this.addBlock(world, 9, 20, 26, stairBlock, 4);
        this.addBlock(world, 9, 21, 24, lapisBlock, 8);
        this.addBlock(world, 9, 21, 26, lapisBlock, 8);
        this.addBlock(world, 9, 22, 24, stairBlock, 1);
        this.addBlock(world, 9, 22, 26, stairBlock, 1);
        this.addBlock(world, 10, 4, 25, wallBlock, 0);
        this.addBlock(world, 10, 5, 25, wallBlock, 0);
        this.addBlock(world, 10, 6, 25, wallBlock, 0);
        this.addBlock(world, 10, 7, 25, wallBlock, 0);
        this.addBlock(world, 10, 8, 24, stairBlock, 6);
        this.addBlock(world, 10, 8, 25, lightBlock, 0);
        this.addBlock(world, 10, 8, 26, stairBlock, 7);
        this.addBlock(world, 10, 9, 24, lapisBlock, 8);
        this.addBlock(world, 10, 9, 26, lapisBlock, 8);
        this.addBlock(world, 10, 10, 23, stairBlock, 6);
        this.addBlock(world, 10, 10, 27, stairBlock, 7);
        this.addBlock(world, 10, 11, 23, mainBlock, 7);
        this.addBlock(world, 10, 11, 27, mainBlock, 7);
        this.addBlock(world, 10, 12, 23, mainBlock, 7);
        this.addBlock(world, 10, 12, 27, mainBlock, 7);
        this.addBlock(world, 10, 13, 21, mainBlock, 1);
        this.addBlock(world, 10, 13, 22, mainBlock, 1);
        this.addBlock(world, 10, 13, 23, mainBlock, 1);
        this.addBlock(world, 10, 13, 24, mainBlock, 1);
        this.addBlock(world, 10, 13, 26, mainBlock, 1);
        this.addBlock(world, 10, 13, 27, mainBlock, 1);
        this.addBlock(world, 10, 13, 28, mainBlock, 1);
        this.addBlock(world, 10, 13, 29, mainBlock, 1);
        this.addBlock(world, 10, 14, 21, cannonBlock, 0);
        this.addBlock(world, 10, 14, 23, stairBlock, 2);
        this.addBlock(world, 10, 14, 27, stairBlock, 3);
        this.addBlock(world, 10, 14, 29, cannonBlock, 0);
        this.addBlock(world, 10, 15, 23, windowBlock, 0);
        this.addBlock(world, 10, 15, 27, windowBlock, 0);
        this.addBlock(world, 10, 16, 23, windowBlock, 0);
        this.addBlock(world, 10, 16, 27, windowBlock, 0);
        this.addBlock(world, 10, 17, 23, windowBlock, 0);
        this.addBlock(world, 10, 17, 27, windowBlock, 0);
        this.addBlock(world, 10, 18, 23, mainBlock, 1);
        this.addBlock(world, 10, 18, 27, stairBlock, 7);
        this.addBlock(world, 10, 19, 23, stairBlock, 2);
        this.addBlock(world, 10, 19, 24, mainBlock, 7);
        this.addBlock(world, 10, 19, 25, wallBlock, 0);
        this.addBlock(world, 10, 19, 26, mainBlock, 7);
        this.addBlock(world, 10, 19, 27, stairBlock, 3);
        this.addBlock(world, 10, 20, 24, lapisBlock, 8);
        this.addBlock(world, 10, 20, 25, lightBlock, 0);
        this.addBlock(world, 10, 20, 26, lapisBlock, 8);
        this.addBlock(world, 10, 21, 24, stairBlock, 1);
        this.addBlock(world, 10, 21, 25, slabBlock, 0);
        this.addBlock(world, 10, 21, 26, stairBlock, 1);
        this.addBlock(world, 11, 8, 25, stairBlock, 5);
        this.addBlock(world, 11, 9, 24, slabBlock, 8);
        this.addBlock(world, 11, 9, 25, lapisBlock, 8);
        this.addBlock(world, 11, 9, 26, slabBlock, 8);
        this.addBlock(world, 11, 10, 24, mainBlock, 7);
        this.addBlock(world, 11, 10, 26, mainBlock, 7);
        this.addBlock(world, 11, 11, 24, mainBlock, 7);
        this.addBlock(world, 11, 11, 26, mainBlock, 7);
        this.addBlock(world, 11, 12, 23, stairBlock, 6);
        this.addBlock(world, 11, 12, 24, mainBlock, 7);
        this.addBlock(world, 11, 12, 26, mainBlock, 7);
        this.addBlock(world, 11, 12, 27, stairBlock, 7);
        this.addBlock(world, 11, 13, 23, mainBlock, 1);
        this.addBlock(world, 11, 13, 24, mainBlock, 1);
        this.addBlock(world, 11, 13, 25, mainBlock, 1);
        this.addBlock(world, 11, 13, 26, mainBlock, 1);
        this.addBlock(world, 11, 13, 27, mainBlock, 1);
        this.addBlock(world, 11, 14, 23, mainBlock, 1);
        this.addBlock(world, 11, 14, 27, mainBlock, 1);
        this.addBlock(world, 11, 15, 23, mainBlock, 1);
        this.addBlock(world, 11, 15, 27, mainBlock, 1);
        this.addBlock(world, 11, 16, 23, mainBlock, 1);
        this.addBlock(world, 11, 16, 27, mainBlock, 1);
        this.addBlock(world, 11, 17, 23, mainBlock, 1);
        this.addBlock(world, 11, 17, 27, mainBlock, 1);
        this.addBlock(world, 11, 18, 23, stairBlock, 2);
        this.addBlock(world, 11, 18, 24, stairBlock, 4);
        this.addBlock(world, 11, 18, 26, stairBlock, 4);
        this.addBlock(world, 11, 18, 27, stairBlock, 3);
        this.addBlock(world, 11, 19, 24, mainBlock, 7);
        this.addBlock(world, 11, 19, 25, mainBlock, 7);
        this.addBlock(world, 11, 19, 26, mainBlock, 7);
        this.addBlock(world, 11, 20, 24, stairBlock, 1);
        this.addBlock(world, 11, 20, 25, stairBlock, 1);
        this.addBlock(world, 11, 20, 26, stairBlock, 1);
        this.addBlock(world, 12, 10, 25, stairBlock, 5);
        this.addBlock(world, 12, 11, 25, mainBlock, 7);
        this.addBlock(world, 12, 12, 24, stairBlock, 5);
        this.addBlock(world, 12, 12, 25, mainBlock, 7);
        this.addBlock(world, 12, 12, 26, stairBlock, 5);
        this.addBlock(world, 12, 13, 24, mainBlock, 1);
        this.addBlock(world, 12, 13, 25, mainBlock, 1);
        this.addBlock(world, 12, 13, 26, mainBlock, 1);
        this.addBlock(world, 12, 14, 24, mainBlock, 1);
        this.addBlock(world, 12, 14, 26, mainBlock, 1);
        this.addBlock(world, 12, 15, 24, mainBlock, 1);
        this.addBlock(world, 12, 15, 26, mainBlock, 1);
        this.addBlock(world, 12, 16, 24, mainBlock, 1);
        this.addBlock(world, 12, 16, 26, mainBlock, 1);
        this.addBlock(world, 12, 17, 24, mainBlock, 1);
        this.addBlock(world, 12, 17, 26, mainBlock, 1);
        this.addBlock(world, 12, 18, 24, lapisBlock, 8);
        this.addBlock(world, 12, 18, 25, stairBlock, 5);
        this.addBlock(world, 12, 18, 26, lapisBlock, 8);
        this.addBlock(world, 12, 19, 24, stairBlock, 1);
        this.addBlock(world, 12, 19, 25, stairBlock, 1);
        this.addBlock(world, 12, 19, 26, stairBlock, 1);
        this.addBlock(world, 13, 12, 25, slabBlock, 8);
        this.addBlock(world, 13, 13, 24, stairBlock, 6);
        this.addBlock(world, 13, 13, 25, mainBlock, 1);
        this.addBlock(world, 13, 13, 26, stairBlock, 7);
        this.addBlock(world, 13, 14, 24, wallBlock, 0);
        this.addBlock(world, 13, 14, 26, wallBlock, 0);
        this.addBlock(world, 13, 16, 24, stairBlock, 4);
        this.addBlock(world, 13, 16, 26, stairBlock, 4);
        this.addBlock(world, 13, 17, 24, lapisBlock, 8);
        this.addBlock(world, 13, 17, 26, lapisBlock, 8);
        this.addBlock(world, 13, 18, 24, stairBlock, 1);
        this.addBlock(world, 13, 18, 26, stairBlock, 1);
        this.addBlock(world, 14, 12, 25, slabBlock, 8);
        this.addBlock(world, 14, 13, 24, stairBlock, 6);
        this.addBlock(world, 14, 13, 25, mainBlock, 1);
        this.addBlock(world, 14, 13, 26, stairBlock, 7);
        this.addBlock(world, 14, 14, 24, wallBlock, 0);
        this.addBlock(world, 14, 14, 26, wallBlock, 0);
        this.addBlock(world, 14, 15, 24, wallBlock, 0);
        this.addBlock(world, 14, 15, 26, wallBlock, 0);
        this.addBlock(world, 14, 16, 24, lapisBlock, 8);
        this.addBlock(world, 14, 16, 26, lapisBlock, 8);
        this.addBlock(world, 14, 17, 24, stairBlock, 1);
        this.addBlock(world, 14, 17, 26, stairBlock, 1);
        this.addBlock(world, 15, 12, 25, slabBlock, 8);
        this.addBlock(world, 15, 13, 24, stairBlock, 6);
        this.addBlock(world, 15, 13, 25, mainBlock, 1);
        this.addBlock(world, 15, 13, 26, stairBlock, 7);
        this.addBlock(world, 15, 14, 24, wallBlock, 0);
        this.addBlock(world, 15, 14, 26, wallBlock, 0);
        this.addBlock(world, 15, 15, 24, lapisBlock, 8);
        this.addBlock(world, 15, 15, 26, lapisBlock, 8);
        this.addBlock(world, 15, 16, 24, stairBlock, 1);
        this.addBlock(world, 15, 16, 26, stairBlock, 1);
        this.addBlock(world, 16, 12, 25, slabBlock, 8);
        this.addBlock(world, 16, 13, 24, stairBlock, 4);
        this.addBlock(world, 16, 13, 25, mainBlock, 1);
        this.addBlock(world, 16, 13, 26, stairBlock, 4);
        this.addBlock(world, 16, 14, 24, lapisBlock, 8);
        this.addBlock(world, 16, 14, 26, lapisBlock, 8);
        this.addBlock(world, 16, 15, 24, stairBlock, 1);
        this.addBlock(world, 16, 15, 26, stairBlock, 1);
        this.addBlock(world, 17, 12, 24, stairBlock, 4);
        this.addBlock(world, 17, 12, 25, slabBlock, 8);
        this.addBlock(world, 17, 12, 26, stairBlock, 4);
        this.addBlock(world, 17, 13, 24, mainBlock, 1);
        this.addBlock(world, 17, 13, 25, mainBlock, 1);
        this.addBlock(world, 17, 13, 26, mainBlock, 1);
        this.addBlock(world, 17, 14, 24, stairBlock, 1);
        this.addBlock(world, 17, 14, 26, stairBlock, 1);
        this.addBlock(world, 18, 11, 24, slabBlock, 8);
        this.addBlock(world, 18, 11, 26, slabBlock, 8);
        this.addBlock(world, 18, 12, 24, mainBlock, 1);
        this.addBlock(world, 18, 12, 25, slabBlock, 8);
        this.addBlock(world, 18, 12, 26, mainBlock, 1);
        this.addBlock(world, 18, 13, 23, stairBlock, 4);
        this.addBlock(world, 18, 13, 24, mainBlock, 1);
        this.addBlock(world, 18, 13, 25, mainBlock, 1);
        this.addBlock(world, 18, 13, 26, mainBlock, 1);
        this.addBlock(world, 18, 13, 27, stairBlock, 4);
        this.addBlock(world, 18, 14, 23, wallBlock, 0);
        this.addBlock(world, 18, 14, 27, wallBlock, 0);
        this.addBlock(world, 19, 12, 24, stairBlock, 5);
        this.addBlock(world, 19, 12, 25, slabBlock, 8);
        this.addBlock(world, 19, 12, 26, stairBlock, 5);
        this.addBlock(world, 19, 13, 23, mainBlock, 1);
        this.addBlock(world, 19, 13, 24, mainBlock, 1);
        this.addBlock(world, 19, 13, 25, mainBlock, 1);
        this.addBlock(world, 19, 13, 26, mainBlock, 1);
        this.addBlock(world, 19, 13, 27, mainBlock, 1);
        this.addBlock(world, 19, 14, 21, wallBlock, 0);
        this.addBlock(world, 19, 14, 22, wallBlock, 0);
        this.addBlock(world, 19, 14, 23, mainBlock, 1);
        this.addBlock(world, 19, 14, 27, mainBlock, 1);
        this.addBlock(world, 19, 14, 28, wallBlock, 0);
        this.addBlock(world, 19, 14, 29, wallBlock, 0);
        this.addBlock(world, 19, 15, 23, mainBlock, 1);
        this.addBlock(world, 19, 15, 27, mainBlock, 1);
        this.addBlock(world, 19, 16, 23, stairBlock, 2);
        this.addBlock(world, 19, 16, 24, stairBlock, 7);
        this.addBlock(world, 19, 16, 26, stairBlock, 6);
        this.addBlock(world, 19, 16, 27, stairBlock, 3);
        this.addBlock(world, 19, 17, 24, cannonBlock, 0);
        this.addBlock(world, 19, 17, 26, cannonBlock, 0);
        this.addBlock(world, 20, 12, 25, slabBlock, 8);
        this.addBlock(world, 20, 13, 22, mainBlock, 1);
        this.addBlock(world, 20, 13, 23, mainBlock, 1);
        this.addBlock(world, 20, 13, 24, mainBlock, 1);
        this.addBlock(world, 20, 13, 25, mainBlock, 1);
        this.addBlock(world, 20, 13, 26, mainBlock, 1);
        this.addBlock(world, 20, 13, 27, mainBlock, 1);
        this.addBlock(world, 20, 13, 28, mainBlock, 1);
        this.addBlock(world, 20, 14, 20, wallBlock, 0);
        this.addBlock(world, 20, 14, 21, wallBlock, 0);
        this.addBlock(world, 20, 14, 23, stairBlock, 1);
        this.addBlock(world, 20, 14, 27, stairBlock, 1);
        this.addBlock(world, 20, 14, 29, wallBlock, 0);
        this.addBlock(world, 20, 14, 30, wallBlock, 0);
        this.addBlock(world, 21, 12, 24, stairBlock, 4);
        this.addBlock(world, 21, 12, 25, slabBlock, 8);
        this.addBlock(world, 21, 12, 26, stairBlock, 4);
        this.addBlock(world, 21, 13, 10, mainBlock, 1);
        this.addBlock(world, 21, 13, 21, mainBlock, 1);
        this.addBlock(world, 21, 13, 22, mainBlock, 1);
        this.addBlock(world, 21, 13, 23, mainBlock, 1);
        this.addBlock(world, 21, 13, 24, mainBlock, 1);
        this.addBlock(world, 21, 13, 25, stairBlock, 1);
        this.addBlock(world, 21, 13, 26, mainBlock, 1);
        this.addBlock(world, 21, 13, 27, mainBlock, 1);
        this.addBlock(world, 21, 13, 28, mainBlock, 1);
        this.addBlock(world, 21, 13, 29, mainBlock, 1);
        this.addBlock(world, 21, 13, 40, mainBlock, 1);
        this.addBlock(world, 21, 14, 10, cannonBlock, 0);
        this.addBlock(world, 21, 14, 19, wallBlock, 0);
        this.addBlock(world, 21, 14, 20, wallBlock, 0);
        this.addBlock(world, 21, 14, 30, wallBlock, 0);
        this.addBlock(world, 21, 14, 31, wallBlock, 0);
        this.addBlock(world, 21, 14, 40, cannonBlock, 0);
        this.addBlock(world, 22, 12, 23, stairBlock, 4);
        this.addBlock(world, 22, 12, 24, mainBlock, 1);
        this.addBlock(world, 22, 12, 25, mainBlock, 1);
        this.addBlock(world, 22, 12, 26, mainBlock, 1);
        this.addBlock(world, 22, 12, 27, stairBlock, 4);
        this.addBlock(world, 22, 13, 10, mainBlock, 1);
        this.addBlock(world, 22, 13, 20, mainBlock, 1);
        this.addBlock(world, 22, 13, 21, mainBlock, 1);
        this.addBlock(world, 22, 13, 22, mainBlock, 1);
        this.addBlock(world, 22, 13, 23, mainBlock, 1);
        this.addBlock(world, 22, 13, 24, stairBlock, 3);
        this.addBlock(world, 22, 13, 25, accentBlock, 0);
        this.addBlock(world, 22, 13, 26, stairBlock, 2);
        this.addBlock(world, 22, 13, 27, mainBlock, 1);
        this.addBlock(world, 22, 13, 28, mainBlock, 1);
        this.addBlock(world, 22, 13, 29, mainBlock, 1);
        this.addBlock(world, 22, 13, 30, mainBlock, 1);
        this.addBlock(world, 22, 13, 40, mainBlock, 1);
        this.addBlock(world, 22, 14, 19, wallBlock, 0);
        this.addBlock(world, 22, 14, 31, wallBlock, 0);
        this.addBlock(world, 23, 8, 23, mainBlock, 1);
        this.addBlock(world, 23, 8, 24, stairBlock, 4);
        this.addBlock(world, 23, 8, 25, stairBlock, 4);
        this.addBlock(world, 23, 8, 26, stairBlock, 4);
        this.addBlock(world, 23, 8, 27, mainBlock, 1);
        this.addBlock(world, 23, 9, 23, wallBlock, 0);
        this.addBlock(world, 23, 9, 25, cannonBlock, 0);
        this.addBlock(world, 23, 9, 27, wallBlock, 0);
        this.addBlock(world, 23, 10, 10, stairBlock, 4);
        this.addBlock(world, 23, 10, 23, wallBlock, 0);
        this.addBlock(world, 23, 10, 27, wallBlock, 0);
        this.addBlock(world, 23, 10, 40, stairBlock, 4);
        this.addBlock(world, 23, 11, 10, mainBlock, 7);
        this.addBlock(world, 23, 11, 23, wallBlock, 0);
        this.addBlock(world, 23, 11, 27, wallBlock, 0);
        this.addBlock(world, 23, 11, 40, mainBlock, 7);
        this.addBlock(world, 23, 12, 9, stairBlock, 4);
        this.addBlock(world, 23, 12, 10, mainBlock, 7);
        this.addBlock(world, 23, 12, 11, stairBlock, 4);
        this.addBlock(world, 23, 12, 22, stairBlock, 6);
        this.addBlock(world, 23, 12, 23, mainBlock, 1);
        this.addBlock(world, 23, 12, 27, mainBlock, 1);
        this.addBlock(world, 23, 12, 28, stairBlock, 7);
        this.addBlock(world, 23, 12, 39, stairBlock, 4);
        this.addBlock(world, 23, 12, 40, mainBlock, 7);
        this.addBlock(world, 23, 12, 41, stairBlock, 4);
        this.addBlock(world, 23, 13, 9, mainBlock, 1);
        this.addBlock(world, 23, 13, 10, mainBlock, 1);
        this.addBlock(world, 23, 13, 11, mainBlock, 1);
        this.addBlock(world, 23, 13, 18, stairBlock, 6);
        this.addBlock(world, 23, 13, 19, mainBlock, 1);
        this.addBlock(world, 23, 13, 20, mainBlock, 1);
        this.addBlock(world, 23, 13, 21, mainBlock, 1);
        this.addBlock(world, 23, 13, 22, mainBlock, 1);
        this.addBlock(world, 23, 13, 23, mainBlock, 7);
        this.addBlock(world, 23, 13, 24, mainBlock, 1);
        this.addBlock(world, 23, 13, 25, stairBlock, 0);
        this.addBlock(world, 23, 13, 26, mainBlock, 1);
        this.addBlock(world, 23, 13, 27, mainBlock, 7);
        this.addBlock(world, 23, 13, 28, mainBlock, 1);
        this.addBlock(world, 23, 13, 29, mainBlock, 1);
        this.addBlock(world, 23, 13, 30, mainBlock, 1);
        this.addBlock(world, 23, 13, 31, mainBlock, 1);
        this.addBlock(world, 23, 13, 32, stairBlock, 7);
        this.addBlock(world, 23, 13, 39, mainBlock, 1);
        this.addBlock(world, 23, 13, 40, mainBlock, 1);
        this.addBlock(world, 23, 13, 41, mainBlock, 1);
        this.addBlock(world, 23, 14, 9, mainBlock, 1);
        this.addBlock(world, 23, 14, 10, stairBlock, 0);
        this.addBlock(world, 23, 14, 11, mainBlock, 1);
        this.addBlock(world, 23, 14, 18, wallBlock, 0);
        this.addBlock(world, 23, 14, 19, mainBlock, 1);
        this.addBlock(world, 23, 14, 20, stairBlock, 3);
        this.addBlock(world, 23, 14, 30, stairBlock, 2);
        this.addBlock(world, 23, 14, 31, mainBlock, 1);
        this.addBlock(world, 23, 14, 32, wallBlock, 0);
        this.addBlock(world, 23, 14, 39, mainBlock, 1);
        this.addBlock(world, 23, 14, 40, stairBlock, 0);
        this.addBlock(world, 23, 14, 41, mainBlock, 1);
        this.addBlock(world, 23, 15, 9, mainBlock, 1);
        this.addBlock(world, 23, 15, 10, windowBlock, 0);
        this.addBlock(world, 23, 15, 11, mainBlock, 1);
        this.addBlock(world, 23, 15, 19, mainBlock, 1);
        this.addBlock(world, 23, 15, 31, mainBlock, 1);
        this.addBlock(world, 23, 15, 39, mainBlock, 1);
        this.addBlock(world, 23, 15, 40, windowBlock, 0);
        this.addBlock(world, 23, 15, 41, mainBlock, 1);
        this.addBlock(world, 23, 16, 9, mainBlock, 1);
        this.addBlock(world, 23, 16, 10, windowBlock, 0);
        this.addBlock(world, 23, 16, 11, mainBlock, 1);
        this.addBlock(world, 23, 16, 19, stairBlock, 0);
        this.addBlock(world, 23, 16, 31, stairBlock, 0);
        this.addBlock(world, 23, 16, 39, mainBlock, 1);
        this.addBlock(world, 23, 16, 40, windowBlock, 0);
        this.addBlock(world, 23, 16, 41, mainBlock, 1);
        this.addBlock(world, 23, 17, 9, mainBlock, 1);
        this.addBlock(world, 23, 17, 10, windowBlock, 0);
        this.addBlock(world, 23, 17, 11, mainBlock, 1);
        this.addBlock(world, 23, 17, 39, mainBlock, 1);
        this.addBlock(world, 23, 17, 40, windowBlock, 0);
        this.addBlock(world, 23, 17, 41, mainBlock, 1);
        this.addBlock(world, 23, 18, 9, stairBlock, 0);
        this.addBlock(world, 23, 18, 10, stairBlock, 4);
        this.addBlock(world, 23, 18, 11, stairBlock, 0);
        this.addBlock(world, 23, 18, 39, stairBlock, 0);
        this.addBlock(world, 23, 18, 40, mainBlock, 1);
        this.addBlock(world, 23, 18, 41, stairBlock, 0);
        this.addBlock(world, 23, 19, 10, stairBlock, 0);
        this.addBlock(world, 23, 19, 40, stairBlock, 0);
        this.addBlock(world, 24, 1, 25, wallBlock, 0);
        this.addBlock(world, 24, 7, 24, stairBlock, 4);
        this.addBlock(world, 24, 7, 25, stairBlock, 4);
        this.addBlock(world, 24, 7, 26, stairBlock, 7);
        this.addBlock(world, 24, 8, 10, stairBlock, 4);
        this.addBlock(world, 24, 8, 23, stairBlock, 6);
        this.addBlock(world, 24, 8, 24, mainBlock, 1);
        this.addBlock(world, 24, 8, 25, mainBlock, 1);
        this.addBlock(world, 24, 8, 26, mainBlock, 1);
        this.addBlock(world, 24, 8, 27, stairBlock, 7);
        this.addBlock(world, 24, 8, 40, stairBlock, 4);
        this.addBlock(world, 24, 9, 9, slabBlock, 8);
        this.addBlock(world, 24, 9, 10, lapisBlock, 8);
        this.addBlock(world, 24, 9, 11, slabBlock, 8);
        this.addBlock(world, 24, 9, 39, slabBlock, 8);
        this.addBlock(world, 24, 9, 40, lapisBlock, 8);
        this.addBlock(world, 24, 9, 41, slabBlock, 8);
        this.addBlock(world, 24, 10, 9, mainBlock, 7);
        this.addBlock(world, 24, 10, 11, mainBlock, 7);
        this.addBlock(world, 24, 10, 39, mainBlock, 7);
        this.addBlock(world, 24, 10, 41, mainBlock, 7);
        this.addBlock(world, 24, 11, 9, mainBlock, 7);
        this.addBlock(world, 24, 11, 11, mainBlock, 7);
        this.addBlock(world, 24, 11, 18, slabBlock, 8);
        this.addBlock(world, 24, 11, 32, slabBlock, 8);
        this.addBlock(world, 24, 11, 39, mainBlock, 7);
        this.addBlock(world, 24, 11, 41, mainBlock, 7);
        this.addBlock(world, 24, 12, 8, stairBlock, 6);
        this.addBlock(world, 24, 12, 9, mainBlock, 7);
        this.addBlock(world, 24, 12, 11, mainBlock, 7);
        this.addBlock(world, 24, 12, 12, stairBlock, 7);
        this.addBlock(world, 24, 12, 17, stairBlock, 6);
        this.addBlock(world, 24, 12, 18, mainBlock, 1);
        this.addBlock(world, 24, 12, 19, stairBlock, 7);
        this.addBlock(world, 24, 12, 21, stairBlock, 6);
        this.addBlock(world, 24, 12, 22, mainBlock, 1);
        this.addBlock(world, 24, 12, 28, mainBlock, 1);
        this.addBlock(world, 24, 12, 29, stairBlock, 7);
        this.addBlock(world, 24, 12, 31, stairBlock, 6);
        this.addBlock(world, 24, 12, 32, mainBlock, 1);
        this.addBlock(world, 24, 12, 33, stairBlock, 7);
        this.addBlock(world, 24, 12, 38, stairBlock, 6);
        this.addBlock(world, 24, 12, 39, mainBlock, 7);
        this.addBlock(world, 24, 12, 41, mainBlock, 7);
        this.addBlock(world, 24, 12, 42, stairBlock, 7);
        this.addBlock(world, 24, 13, 8, mainBlock, 1);
        this.addBlock(world, 24, 13, 9, mainBlock, 1);
        this.addBlock(world, 24, 13, 10, mainBlock, 1);
        this.addBlock(world, 24, 13, 11, mainBlock, 1);
        this.addBlock(world, 24, 13, 12, mainBlock, 1);
        this.addBlock(world, 24, 13, 13, stairBlock, 4);
        this.addBlock(world, 24, 13, 14, stairBlock, 4);
        this.addBlock(world, 24, 13, 15, stairBlock, 4);
        this.addBlock(world, 24, 13, 16, stairBlock, 6);
        this.addBlock(world, 24, 13, 17, mainBlock, 1);
        this.addBlock(world, 24, 13, 18, mainBlock, 1);
        this.addBlock(world, 24, 13, 19, mainBlock, 1);
        this.addBlock(world, 24, 13, 20, mainBlock, 1);
        this.addBlock(world, 24, 13, 21, mainBlock, 1);
        this.addBlock(world, 24, 13, 22, stairBlock, 1);
        this.addBlock(world, 24, 13, 23, mainBlock, 1);
        this.addBlock(world, 24, 13, 24, mainBlock, 1);
        this.addBlock(world, 24, 13, 25, lapisBlock, 8);
        this.addBlock(world, 24, 13, 26, mainBlock, 1);
        this.addBlock(world, 24, 13, 27, mainBlock, 1);
        this.addBlock(world, 24, 13, 28, stairBlock, 1);
        this.addBlock(world, 24, 13, 29, mainBlock, 1);
        this.addBlock(world, 24, 13, 30, mainBlock, 1);
        this.addBlock(world, 24, 13, 31, mainBlock, 1);
        this.addBlock(world, 24, 13, 32, mainBlock, 1);
        this.addBlock(world, 24, 13, 33, mainBlock, 1);
        this.addBlock(world, 24, 13, 34, stairBlock, 7);
        this.addBlock(world, 24, 13, 35, stairBlock, 4);
        this.addBlock(world, 24, 13, 36, stairBlock, 4);
        this.addBlock(world, 24, 13, 37, stairBlock, 4);
        this.addBlock(world, 24, 13, 38, mainBlock, 1);
        this.addBlock(world, 24, 13, 39, mainBlock, 1);
        this.addBlock(world, 24, 13, 40, mainBlock, 1);
        this.addBlock(world, 24, 13, 41, mainBlock, 1);
        this.addBlock(world, 24, 13, 42, mainBlock, 1);
        this.addBlock(world, 24, 14, 8, mainBlock, 1);
        this.addBlock(world, 24, 14, 12, mainBlock, 1);
        this.addBlock(world, 24, 14, 13, wallBlock, 0);
        this.addBlock(world, 24, 14, 14, wallBlock, 0);
        this.addBlock(world, 24, 14, 15, wallBlock, 0);
        this.addBlock(world, 24, 14, 16, lapisBlock, 8);
        this.addBlock(world, 24, 14, 17, stairBlock, 3);
        this.addBlock(world, 24, 14, 24, wallBlock, 0);
        this.addBlock(world, 24, 14, 26, wallBlock, 0);
        this.addBlock(world, 24, 14, 33, stairBlock, 2);
        this.addBlock(world, 24, 14, 34, lapisBlock, 8);
        this.addBlock(world, 24, 14, 35, wallBlock, 0);
        this.addBlock(world, 24, 14, 36, wallBlock, 0);
        this.addBlock(world, 24, 14, 37, wallBlock, 0);
        this.addBlock(world, 24, 14, 38, mainBlock, 1);
        this.addBlock(world, 24, 14, 42, mainBlock, 1);
        this.addBlock(world, 24, 15, 8, mainBlock, 1);
        this.addBlock(world, 24, 15, 12, mainBlock, 1);
        this.addBlock(world, 24, 15, 14, wallBlock, 0);
        this.addBlock(world, 24, 15, 15, lapisBlock, 8);
        this.addBlock(world, 24, 15, 16, stairBlock, 3);
        this.addBlock(world, 24, 15, 24, wallBlock, 0);
        this.addBlock(world, 24, 15, 26, wallBlock, 0);
        this.addBlock(world, 24, 15, 34, stairBlock, 2);
        this.addBlock(world, 24, 15, 35, lapisBlock, 8);
        this.addBlock(world, 24, 15, 36, wallBlock, 0);
        this.addBlock(world, 24, 15, 38, mainBlock, 1);
        this.addBlock(world, 24, 15, 42, mainBlock, 1);
        this.addBlock(world, 24, 16, 8, mainBlock, 1);
        this.addBlock(world, 24, 16, 12, mainBlock, 1);
        this.addBlock(world, 24, 16, 13, stairBlock, 6);
        this.addBlock(world, 24, 16, 14, lapisBlock, 8);
        this.addBlock(world, 24, 16, 15, stairBlock, 3);
        this.addBlock(world, 24, 16, 19, stairBlock, 5);
        this.addBlock(world, 24, 16, 24, stairBlock, 0);
        this.addBlock(world, 24, 16, 25, stairBlock, 0);
        this.addBlock(world, 24, 16, 26, stairBlock, 0);
        this.addBlock(world, 24, 16, 31, stairBlock, 5);
        this.addBlock(world, 24, 16, 35, stairBlock, 2);
        this.addBlock(world, 24, 16, 36, lapisBlock, 8);
        this.addBlock(world, 24, 16, 37, stairBlock, 7);
        this.addBlock(world, 24, 16, 38, mainBlock, 1);
        this.addBlock(world, 24, 16, 42, mainBlock, 1);
        this.addBlock(world, 24, 17, 8, mainBlock, 1);
        this.addBlock(world, 24, 17, 12, mainBlock, 1);
        this.addBlock(world, 24, 17, 13, lapisBlock, 8);
        this.addBlock(world, 24, 17, 14, stairBlock, 3);
        this.addBlock(world, 24, 17, 19, cannonBlock, 0);
        this.addBlock(world, 24, 17, 31, cannonBlock, 0);
        this.addBlock(world, 24, 17, 36, stairBlock, 2);
        this.addBlock(world, 24, 17, 37, lapisBlock, 8);
        this.addBlock(world, 24, 17, 38, mainBlock, 1);
        this.addBlock(world, 24, 17, 42, mainBlock, 1);
        this.addBlock(world, 24, 18, 8, stairBlock, 2);
        this.addBlock(world, 24, 18, 9, stairBlock, 7);
        this.addBlock(world, 24, 18, 11, stairBlock, 6);
        this.addBlock(world, 24, 18, 12, lapisBlock, 8);
        this.addBlock(world, 24, 18, 13, stairBlock, 3);
        this.addBlock(world, 24, 18, 37, stairBlock, 2);
        this.addBlock(world, 24, 18, 38, lapisBlock, 8);
        this.addBlock(world, 24, 18, 39, stairBlock, 7);
        this.addBlock(world, 24, 18, 41, stairBlock, 6);
        this.addBlock(world, 24, 18, 42, stairBlock, 3);
        this.addBlock(world, 24, 19, 9, mainBlock, 7);
        this.addBlock(world, 24, 19, 10, mainBlock, 7);
        this.addBlock(world, 24, 19, 11, mainBlock, 7);
        this.addBlock(world, 24, 19, 12, stairBlock, 3);
        this.addBlock(world, 24, 19, 38, stairBlock, 2);
        this.addBlock(world, 24, 19, 39, mainBlock, 7);
        this.addBlock(world, 24, 19, 40, mainBlock, 7);
        this.addBlock(world, 24, 19, 41, mainBlock, 7);
        this.addBlock(world, 24, 20, 9, stairBlock, 6);
        this.addBlock(world, 24, 20, 10, lapisBlock, 8);
        this.addBlock(world, 24, 20, 11, stairBlock, 3);
        this.addBlock(world, 24, 20, 39, stairBlock, 2);
        this.addBlock(world, 24, 20, 40, lapisBlock, 8);
        this.addBlock(world, 24, 20, 41, stairBlock, 7);
        this.addBlock(world, 24, 21, 8, stairBlock, 6);
        this.addBlock(world, 24, 21, 9, lapisBlock, 8);
        this.addBlock(world, 24, 21, 10, stairBlock, 3);
        this.addBlock(world, 24, 21, 40, stairBlock, 2);
        this.addBlock(world, 24, 21, 41, lapisBlock, 8);
        this.addBlock(world, 24, 21, 42, stairBlock, 7);
        this.addBlock(world, 24, 22, 7, stairBlock, 6);
        this.addBlock(world, 24, 22, 8, lapisBlock, 8);
        this.addBlock(world, 24, 22, 9, stairBlock, 3);
        this.addBlock(world, 24, 22, 41, stairBlock, 2);
        this.addBlock(world, 24, 22, 42, lapisBlock, 8);
        this.addBlock(world, 24, 22, 43, stairBlock, 7);
        this.addBlock(world, 24, 23, 6, stairBlock, 6);
        this.addBlock(world, 24, 23, 7, lapisBlock, 8);
        this.addBlock(world, 24, 23, 8, stairBlock, 3);
        this.addBlock(world, 24, 23, 42, stairBlock, 2);
        this.addBlock(world, 24, 23, 43, lapisBlock, 8);
        this.addBlock(world, 24, 23, 44, stairBlock, 7);
        this.addBlock(world, 24, 24, 5, stairBlock, 6);
        this.addBlock(world, 24, 24, 6, lapisBlock, 8);
        this.addBlock(world, 24, 24, 7, stairBlock, 3);
        this.addBlock(world, 24, 24, 43, stairBlock, 2);
        this.addBlock(world, 24, 24, 44, lapisBlock, 8);
        this.addBlock(world, 24, 24, 45, stairBlock, 7);
        this.addBlock(world, 24, 25, 4, stairBlock, 6);
        this.addBlock(world, 24, 25, 5, lapisBlock, 8);
        this.addBlock(world, 24, 25, 6, stairBlock, 3);
        this.addBlock(world, 24, 25, 44, stairBlock, 2);
        this.addBlock(world, 24, 25, 45, lapisBlock, 8);
        this.addBlock(world, 24, 25, 46, stairBlock, 7);
        this.addBlock(world, 24, 26, 3, stairBlock, 6);
        this.addBlock(world, 24, 26, 4, lapisBlock, 8);
        this.addBlock(world, 24, 26, 5, stairBlock, 3);
        this.addBlock(world, 24, 26, 45, stairBlock, 2);
        this.addBlock(world, 24, 26, 46, lapisBlock, 8);
        this.addBlock(world, 24, 26, 47, stairBlock, 7);
        this.addBlock(world, 24, 27, 2, stairBlock, 6);
        this.addBlock(world, 24, 27, 3, lapisBlock, 8);
        this.addBlock(world, 24, 27, 4, stairBlock, 3);
        this.addBlock(world, 24, 27, 46, stairBlock, 2);
        this.addBlock(world, 24, 27, 47, lapisBlock, 8);
        this.addBlock(world, 24, 27, 48, stairBlock, 7);
        this.addBlock(world, 24, 28, 1, stairBlock, 6);
        this.addBlock(world, 24, 28, 2, lapisBlock, 8);
        this.addBlock(world, 24, 28, 3, stairBlock, 3);
        this.addBlock(world, 24, 28, 47, stairBlock, 2);
        this.addBlock(world, 24, 28, 48, lapisBlock, 8);
        this.addBlock(world, 24, 28, 49, stairBlock, 7);
        this.addBlock(world, 24, 29, 0, stairBlock, 6);
        this.addBlock(world, 24, 29, 1, lapisBlock, 8);
        this.addBlock(world, 24, 29, 2, stairBlock, 3);
        this.addBlock(world, 24, 29, 48, stairBlock, 2);
        this.addBlock(world, 24, 29, 49, lapisBlock, 8);
        this.addBlock(world, 24, 29, 50, stairBlock, 7);
        this.addBlock(world, 24, 30, 1, stairBlock, 3);
        this.addBlock(world, 24, 30, 49, stairBlock, 2);
        this.addBlock(world, 25, 0, 25, wallBlock, 0);
        this.addBlock(world, 25, 1, 24, wallBlock, 0);
        this.addBlock(world, 25, 1, 25, wallBlock, 0);
        this.addBlock(world, 25, 1, 26, wallBlock, 0);
        this.addBlock(world, 25, 2, 25, wallBlock, 0);
        this.addBlock(world, 25, 3, 25, wallBlock, 0);
        this.addBlock(world, 25, 4, 10, wallBlock, 0);
        this.addBlock(world, 25, 4, 25, wallBlock, 0);
        this.addBlock(world, 25, 4, 40, wallBlock, 0);
        this.addBlock(world, 25, 5, 10, wallBlock, 0);
        this.addBlock(world, 25, 5, 25, wallBlock, 0);
        this.addBlock(world, 25, 5, 40, wallBlock, 0);
        this.addBlock(world, 25, 6, 10, wallBlock, 0);
        this.addBlock(world, 25, 6, 25, wallBlock, 0);
        this.addBlock(world, 25, 6, 40, wallBlock, 0);
        this.addBlock(world, 25, 7, 10, wallBlock, 0);
        this.addBlock(world, 25, 7, 24, stairBlock, 6);
        this.addBlock(world, 25, 7, 25, lightBlock, 0);
        this.addBlock(world, 25, 7, 26, stairBlock, 7);
        this.addBlock(world, 25, 7, 40, wallBlock, 0);
        this.addBlock(world, 25, 8, 9, stairBlock, 6);
        this.addBlock(world, 25, 8, 10, lightBlock, 0);
        this.addBlock(world, 25, 8, 11, stairBlock, 7);
        this.addBlock(world, 25, 8, 23, stairBlock, 6);
        this.addBlock(world, 25, 8, 24, mainBlock, 1);
        this.addBlock(world, 25, 8, 25, mainBlock, 1);
        this.addBlock(world, 25, 8, 26, mainBlock, 1);
        this.addBlock(world, 25, 8, 27, stairBlock, 7);
        this.addBlock(world, 25, 8, 39, stairBlock, 6);
        this.addBlock(world, 25, 8, 40, lightBlock, 0);
        this.addBlock(world, 25, 8, 41, stairBlock, 7);
        this.addBlock(world, 25, 9, 9, lapisBlock, 8);
        this.addBlock(world, 25, 9, 11, lapisBlock, 8);
        this.addBlock(world, 25, 9, 23, cannonBlock, 0);
        this.addBlock(world, 25, 9, 25, mainBlock, 1);
        this.addBlock(world, 25, 9, 27, cannonBlock, 0);
        this.addBlock(world, 25, 9, 39, lapisBlock, 8);
        this.addBlock(world, 25, 9, 41, lapisBlock, 8);
        this.addBlock(world, 25, 10, 8, stairBlock, 6);
        this.addBlock(world, 25, 10, 12, stairBlock, 7);
        this.addBlock(world, 25, 10, 25, mainBlock, 1);
        this.addBlock(world, 25, 10, 38, stairBlock, 6);
        this.addBlock(world, 25, 10, 42, stairBlock, 7);
        this.addBlock(world, 25, 11, 8, mainBlock, 7);
        this.addBlock(world, 25, 11, 12, mainBlock, 7);
        this.addBlock(world, 25, 11, 25, mainBlock, 1);
        this.addBlock(world, 25, 11, 38, mainBlock, 7);
        this.addBlock(world, 25, 11, 42, mainBlock, 7);
        this.addBlock(world, 25, 12, 8, mainBlock, 7);
        this.addBlock(world, 25, 12, 12, mainBlock, 7);
        this.addBlock(world, 25, 12, 13, slabBlock, 8);
        this.addBlock(world, 25, 12, 14, slabBlock, 8);
        this.addBlock(world, 25, 12, 15, slabBlock, 8);
        this.addBlock(world, 25, 12, 16, slabBlock, 8);
        this.addBlock(world, 25, 12, 17, slabBlock, 8);
        this.addBlock(world, 25, 12, 18, slabBlock, 8);
        this.addBlock(world, 25, 12, 19, slabBlock, 8);
        this.addBlock(world, 25, 12, 20, slabBlock, 8);
        this.addBlock(world, 25, 12, 21, slabBlock, 8);
        this.addBlock(world, 25, 12, 22, mainBlock, 1);
        this.addBlock(world, 25, 12, 25, tntBlock, 0);
        this.addBlock(world, 25, 12, 28, mainBlock, 1);
        this.addBlock(world, 25, 12, 29, slabBlock, 8);
        this.addBlock(world, 25, 12, 30, slabBlock, 8);
        this.addBlock(world, 25, 12, 31, slabBlock, 8);
        this.addBlock(world, 25, 12, 32, slabBlock, 8);
        this.addBlock(world, 25, 12, 33, slabBlock, 8);
        this.addBlock(world, 25, 12, 34, slabBlock, 8);
        this.addBlock(world, 25, 12, 35, slabBlock, 8);
        this.addBlock(world, 25, 12, 36, slabBlock, 8);
        this.addBlock(world, 25, 12, 37, slabBlock, 8);
        this.addBlock(world, 25, 12, 38, mainBlock, 7);
        this.addBlock(world, 25, 12, 42, mainBlock, 7);
        this.addBlock(world, 25, 13, 6, mainBlock, 1);
        this.addBlock(world, 25, 13, 7, mainBlock, 1);
        this.addBlock(world, 25, 13, 8, mainBlock, 1);
        this.addBlock(world, 25, 13, 9, mainBlock, 1);
        this.addBlock(world, 25, 13, 11, mainBlock, 1);
        this.addBlock(world, 25, 13, 12, mainBlock, 1);
        this.addBlock(world, 25, 13, 13, mainBlock, 1);
        this.addBlock(world, 25, 13, 14, mainBlock, 1);
        this.addBlock(world, 25, 13, 15, mainBlock, 1);
        this.addBlock(world, 25, 13, 16, mainBlock, 1);
        this.addBlock(world, 25, 13, 17, mainBlock, 1);
        this.addBlock(world, 25, 13, 18, mainBlock, 1);
        this.addBlock(world, 25, 13, 19, mainBlock, 1);
        this.addBlock(world, 25, 13, 20, mainBlock, 1);
        this.addBlock(world, 25, 13, 21, stairBlock, 3);
        this.addBlock(world, 25, 13, 22, accentBlock, 0);
        this.addBlock(world, 25, 13, 23, stairBlock, 2);
        this.addBlock(world, 25, 13, 24, lapisBlock, 8);
        this.addBlock(world, 25, 13, 26, lapisBlock, 8);
        this.addBlock(world, 25, 13, 27, stairBlock, 3);
        this.addBlock(world, 25, 13, 28, accentBlock, 0);
        this.addBlock(world, 25, 13, 29, stairBlock, 2);
        this.addBlock(world, 25, 13, 30, mainBlock, 1);
        this.addBlock(world, 25, 13, 31, mainBlock, 1);
        this.addBlock(world, 25, 13, 32, mainBlock, 1);
        this.addBlock(world, 25, 13, 33, mainBlock, 1);
        this.addBlock(world, 25, 13, 34, mainBlock, 1);
        this.addBlock(world, 25, 13, 35, mainBlock, 1);
        this.addBlock(world, 25, 13, 36, mainBlock, 1);
        this.addBlock(world, 25, 13, 37, mainBlock, 1);
        this.addBlock(world, 25, 13, 38, mainBlock, 1);
        this.addBlock(world, 25, 13, 39, mainBlock, 1);
        this.addBlock(world, 25, 13, 41, mainBlock, 1);
        this.addBlock(world, 25, 13, 42, mainBlock, 1);
        this.addBlock(world, 25, 13, 43, mainBlock, 1);
        this.addBlock(world, 25, 13, 44, mainBlock, 1);
        this.addBlock(world, 25, 14, 6, cannonBlock, 0);
        this.addBlock(world, 25, 14, 8, stairBlock, 2);
        this.addBlock(world, 25, 14, 42, stairBlock, 3);
        this.addBlock(world, 25, 14, 44, cannonBlock, 0);
        this.addBlock(world, 25, 15, 8, windowBlock, 0);
        this.addBlock(world, 25, 15, 42, windowBlock, 0);
        this.addBlock(world, 25, 16, 8, windowBlock, 0);
        this.addBlock(world, 25, 16, 24, stairBlock, 2);
        this.addBlock(world, 25, 16, 25, lightBlock, 0);
        this.addBlock(world, 25, 16, 26, stairBlock, 3);
        this.addBlock(world, 25, 16, 42, windowBlock, 0);
        this.addBlock(world, 25, 17, 8, windowBlock, 0);
        this.addBlock(world, 25, 17, 25, slabBlock, 0);
        this.addBlock(world, 25, 17, 42, windowBlock, 0);
        this.addBlock(world, 25, 18, 8, stairBlock, 6);
        this.addBlock(world, 25, 18, 12, stairBlock, 7);
        this.addBlock(world, 25, 18, 38, stairBlock, 6);
        this.addBlock(world, 25, 18, 42, stairBlock, 7);
        this.addBlock(world, 25, 19, 8, stairBlock, 2);
        this.addBlock(world, 25, 19, 9, mainBlock, 7);
        this.addBlock(world, 25, 19, 10, wallBlock, 0);
        this.addBlock(world, 25, 19, 11, mainBlock, 7);
        this.addBlock(world, 25, 19, 12, stairBlock, 3);
        this.addBlock(world, 25, 19, 38, stairBlock, 2);
        this.addBlock(world, 25, 19, 39, mainBlock, 7);
        this.addBlock(world, 25, 19, 40, wallBlock, 0);
        this.addBlock(world, 25, 19, 41, mainBlock, 7);
        this.addBlock(world, 25, 19, 42, stairBlock, 3);
        this.addBlock(world, 25, 20, 9, stairBlock, 2);
        this.addBlock(world, 25, 20, 10, lightBlock, 0);
        this.addBlock(world, 25, 20, 11, stairBlock, 3);
        this.addBlock(world, 25, 20, 39, stairBlock, 2);
        this.addBlock(world, 25, 20, 40, lightBlock, 0);
        this.addBlock(world, 25, 20, 41, stairBlock, 3);
        this.addBlock(world, 25, 21, 10, slabBlock, 0);
        this.addBlock(world, 25, 21, 40, slabBlock, 0);
        this.addBlock(world, 26, 1, 25, wallBlock, 0);
        this.addBlock(world, 26, 7, 24, stairBlock, 6);
        this.addBlock(world, 26, 7, 25, stairBlock, 5);
        this.addBlock(world, 26, 7, 26, stairBlock, 7);
        this.addBlock(world, 26, 8, 10, stairBlock, 5);
        this.addBlock(world, 26, 8, 23, stairBlock, 6);
        this.addBlock(world, 26, 8, 24, mainBlock, 1);
        this.addBlock(world, 26, 8, 25, mainBlock, 1);
        this.addBlock(world, 26, 8, 26, mainBlock, 1);
        this.addBlock(world, 26, 8, 27, stairBlock, 7);
        this.addBlock(world, 26, 8, 40, stairBlock, 5);
        this.addBlock(world, 26, 9, 9, slabBlock, 8);
        this.addBlock(world, 26, 9, 10, lapisBlock, 8);
        this.addBlock(world, 26, 9, 11, slabBlock, 8);
        this.addBlock(world, 26, 9, 39, slabBlock, 8);
        this.addBlock(world, 26, 9, 40, lapisBlock, 8);
        this.addBlock(world, 26, 9, 41, slabBlock, 8);
        this.addBlock(world, 26, 10, 9, mainBlock, 7);
        this.addBlock(world, 26, 10, 11, mainBlock, 7);
        this.addBlock(world, 26, 10, 39, mainBlock, 7);
        this.addBlock(world, 26, 10, 41, mainBlock, 7);
        this.addBlock(world, 26, 11, 9, mainBlock, 7);
        this.addBlock(world, 26, 11, 11, mainBlock, 7);
        this.addBlock(world, 26, 11, 18, slabBlock, 8);
        this.addBlock(world, 26, 11, 32, slabBlock, 8);
        this.addBlock(world, 26, 11, 39, mainBlock, 7);
        this.addBlock(world, 26, 11, 41, mainBlock, 7);
        this.addBlock(world, 26, 12, 8, stairBlock, 6);
        this.addBlock(world, 26, 12, 9, mainBlock, 7);
        this.addBlock(world, 26, 12, 11, mainBlock, 7);
        this.addBlock(world, 26, 12, 12, stairBlock, 7);
        this.addBlock(world, 26, 12, 17, stairBlock, 6);
        this.addBlock(world, 26, 12, 18, mainBlock, 1);
        this.addBlock(world, 26, 12, 19, stairBlock, 7);
        this.addBlock(world, 26, 12, 21, stairBlock, 6);
        this.addBlock(world, 26, 12, 22, mainBlock, 1);
        this.addBlock(world, 26, 12, 28, mainBlock, 1);
        this.addBlock(world, 26, 12, 29, stairBlock, 7);
        this.addBlock(world, 26, 12, 31, stairBlock, 6);
        this.addBlock(world, 26, 12, 32, mainBlock, 1);
        this.addBlock(world, 26, 12, 33, stairBlock, 7);
        this.addBlock(world, 26, 12, 38, stairBlock, 6);
        this.addBlock(world, 26, 12, 39, mainBlock, 7);
        this.addBlock(world, 26, 12, 41, mainBlock, 7);
        this.addBlock(world, 26, 12, 42, stairBlock, 7);
        this.addBlock(world, 26, 13, 8, mainBlock, 1);
        this.addBlock(world, 26, 13, 9, mainBlock, 1);
        this.addBlock(world, 26, 13, 10, mainBlock, 1);
        this.addBlock(world, 26, 13, 11, mainBlock, 1);
        this.addBlock(world, 26, 13, 12, mainBlock, 1);
        this.addBlock(world, 26, 13, 13, stairBlock, 5);
        this.addBlock(world, 26, 13, 14, stairBlock, 5);
        this.addBlock(world, 26, 13, 15, stairBlock, 5);
        this.addBlock(world, 26, 13, 16, stairBlock, 6);
        this.addBlock(world, 26, 13, 17, mainBlock, 1);
        this.addBlock(world, 26, 13, 18, mainBlock, 1);
        this.addBlock(world, 26, 13, 19, mainBlock, 1);
        this.addBlock(world, 26, 13, 20, mainBlock, 1);
        this.addBlock(world, 26, 13, 21, mainBlock, 1);
        this.addBlock(world, 26, 13, 22, stairBlock, 0);
        this.addBlock(world, 26, 13, 23, mainBlock, 1);
        this.addBlock(world, 26, 13, 24, mainBlock, 1);
        this.addBlock(world, 26, 13, 25, lapisBlock, 8);
        this.addBlock(world, 26, 13, 26, mainBlock, 1);
        this.addBlock(world, 26, 13, 27, mainBlock, 1);
        this.addBlock(world, 26, 13, 28, stairBlock, 0);
        this.addBlock(world, 26, 13, 29, mainBlock, 1);
        this.addBlock(world, 26, 13, 30, mainBlock, 1);
        this.addBlock(world, 26, 13, 31, mainBlock, 1);
        this.addBlock(world, 26, 13, 32, mainBlock, 1);
        this.addBlock(world, 26, 13, 33, mainBlock, 1);
        this.addBlock(world, 26, 13, 34, stairBlock, 7);
        this.addBlock(world, 26, 13, 35, stairBlock, 5);
        this.addBlock(world, 26, 13, 36, stairBlock, 5);
        this.addBlock(world, 26, 13, 37, stairBlock, 5);
        this.addBlock(world, 26, 13, 38, mainBlock, 1);
        this.addBlock(world, 26, 13, 39, mainBlock, 1);
        this.addBlock(world, 26, 13, 40, mainBlock, 1);
        this.addBlock(world, 26, 13, 41, mainBlock, 1);
        this.addBlock(world, 26, 13, 42, mainBlock, 1);
        this.addBlock(world, 26, 14, 8, mainBlock, 1);
        this.addBlock(world, 26, 14, 12, mainBlock, 1);
        this.addBlock(world, 26, 14, 13, wallBlock, 0);
        this.addBlock(world, 26, 14, 14, wallBlock, 0);
        this.addBlock(world, 26, 14, 15, wallBlock, 0);
        this.addBlock(world, 26, 14, 16, lapisBlock, 8);
        this.addBlock(world, 26, 14, 17, stairBlock, 3);
        this.addBlock(world, 26, 14, 24, wallBlock, 0);
        this.addBlock(world, 26, 14, 26, wallBlock, 0);
        this.addBlock(world, 26, 14, 33, stairBlock, 2);
        this.addBlock(world, 26, 14, 34, lapisBlock, 8);
        this.addBlock(world, 26, 14, 35, wallBlock, 0);
        this.addBlock(world, 26, 14, 36, wallBlock, 0);
        this.addBlock(world, 26, 14, 37, wallBlock, 0);
        this.addBlock(world, 26, 14, 38, mainBlock, 1);
        this.addBlock(world, 26, 14, 42, mainBlock, 1);
        this.addBlock(world, 26, 15, 8, mainBlock, 1);
        this.addBlock(world, 26, 15, 12, mainBlock, 1);
        this.addBlock(world, 26, 15, 14, wallBlock, 0);
        this.addBlock(world, 26, 15, 15, lapisBlock, 8);
        this.addBlock(world, 26, 15, 16, stairBlock, 3);
        this.addBlock(world, 26, 15, 24, wallBlock, 0);
        this.addBlock(world, 26, 15, 26, wallBlock, 0);
        this.addBlock(world, 26, 15, 34, stairBlock, 2);
        this.addBlock(world, 26, 15, 35, lapisBlock, 8);
        this.addBlock(world, 26, 15, 36, wallBlock, 0);
        this.addBlock(world, 26, 15, 38, mainBlock, 1);
        this.addBlock(world, 26, 15, 42, mainBlock, 1);
        this.addBlock(world, 26, 16, 8, mainBlock, 1);
        this.addBlock(world, 26, 16, 12, mainBlock, 1);
        this.addBlock(world, 26, 16, 13, stairBlock, 6);
        this.addBlock(world, 26, 16, 14, lapisBlock, 8);
        this.addBlock(world, 26, 16, 15, stairBlock, 3);
        this.addBlock(world, 26, 16, 19, stairBlock, 4);
        this.addBlock(world, 26, 16, 24, stairBlock, 1);
        this.addBlock(world, 26, 16, 25, stairBlock, 1);
        this.addBlock(world, 26, 16, 26, stairBlock, 3);
        this.addBlock(world, 26, 16, 31, stairBlock, 4);
        this.addBlock(world, 26, 16, 35, stairBlock, 2);
        this.addBlock(world, 26, 16, 36, lapisBlock, 8);
        this.addBlock(world, 26, 16, 37, stairBlock, 7);
        this.addBlock(world, 26, 16, 38, mainBlock, 1);
        this.addBlock(world, 26, 16, 42, mainBlock, 1);
        this.addBlock(world, 26, 17, 8, mainBlock, 1);
        this.addBlock(world, 26, 17, 12, mainBlock, 1);
        this.addBlock(world, 26, 17, 13, lapisBlock, 8);
        this.addBlock(world, 26, 17, 14, stairBlock, 3);
        this.addBlock(world, 26, 17, 19, cannonBlock, 0);
        this.addBlock(world, 26, 17, 31, cannonBlock, 0);
        this.addBlock(world, 26, 17, 36, stairBlock, 2);
        this.addBlock(world, 26, 17, 37, lapisBlock, 8);
        this.addBlock(world, 26, 17, 38, mainBlock, 1);
        this.addBlock(world, 26, 17, 42, mainBlock, 1);
        this.addBlock(world, 26, 18, 8, stairBlock, 2);
        this.addBlock(world, 26, 18, 9, stairBlock, 7);
        this.addBlock(world, 26, 18, 11, stairBlock, 6);
        this.addBlock(world, 26, 18, 12, lapisBlock, 8);
        this.addBlock(world, 26, 18, 13, stairBlock, 3);
        this.addBlock(world, 26, 18, 37, stairBlock, 2);
        this.addBlock(world, 26, 18, 38, lapisBlock, 8);
        this.addBlock(world, 26, 18, 39, stairBlock, 7);
        this.addBlock(world, 26, 18, 41, stairBlock, 6);
        this.addBlock(world, 26, 18, 42, stairBlock, 3);
        this.addBlock(world, 26, 19, 9, mainBlock, 7);
        this.addBlock(world, 26, 19, 10, mainBlock, 7);
        this.addBlock(world, 26, 19, 11, mainBlock, 7);
        this.addBlock(world, 26, 19, 12, stairBlock, 3);
        this.addBlock(world, 26, 19, 38, stairBlock, 2);
        this.addBlock(world, 26, 19, 39, mainBlock, 7);
        this.addBlock(world, 26, 19, 40, mainBlock, 7);
        this.addBlock(world, 26, 19, 41, mainBlock, 7);
        this.addBlock(world, 26, 20, 9, stairBlock, 6);
        this.addBlock(world, 26, 20, 10, lapisBlock, 8);
        this.addBlock(world, 26, 20, 11, stairBlock, 3);
        this.addBlock(world, 26, 20, 39, stairBlock, 2);
        this.addBlock(world, 26, 20, 40, lapisBlock, 8);
        this.addBlock(world, 26, 20, 41, stairBlock, 7);
        this.addBlock(world, 26, 21, 8, stairBlock, 6);
        this.addBlock(world, 26, 21, 9, lapisBlock, 8);
        this.addBlock(world, 26, 21, 10, stairBlock, 3);
        this.addBlock(world, 26, 21, 40, stairBlock, 2);
        this.addBlock(world, 26, 21, 41, lapisBlock, 8);
        this.addBlock(world, 26, 21, 42, stairBlock, 7);
        this.addBlock(world, 26, 22, 7, stairBlock, 6);
        this.addBlock(world, 26, 22, 8, lapisBlock, 8);
        this.addBlock(world, 26, 22, 9, stairBlock, 3);
        this.addBlock(world, 26, 22, 41, stairBlock, 2);
        this.addBlock(world, 26, 22, 42, lapisBlock, 8);
        this.addBlock(world, 26, 22, 43, stairBlock, 7);
        this.addBlock(world, 26, 23, 6, stairBlock, 6);
        this.addBlock(world, 26, 23, 7, lapisBlock, 8);
        this.addBlock(world, 26, 23, 8, stairBlock, 3);
        this.addBlock(world, 26, 23, 42, stairBlock, 2);
        this.addBlock(world, 26, 23, 43, lapisBlock, 8);
        this.addBlock(world, 26, 23, 44, stairBlock, 7);
        this.addBlock(world, 26, 24, 5, stairBlock, 6);
        this.addBlock(world, 26, 24, 6, lapisBlock, 8);
        this.addBlock(world, 26, 24, 7, stairBlock, 3);
        this.addBlock(world, 26, 24, 43, stairBlock, 2);
        this.addBlock(world, 26, 24, 44, lapisBlock, 8);
        this.addBlock(world, 26, 24, 45, stairBlock, 7);
        this.addBlock(world, 26, 25, 4, stairBlock, 6);
        this.addBlock(world, 26, 25, 5, lapisBlock, 8);
        this.addBlock(world, 26, 25, 6, stairBlock, 3);
        this.addBlock(world, 26, 25, 44, stairBlock, 2);
        this.addBlock(world, 26, 25, 45, lapisBlock, 8);
        this.addBlock(world, 26, 25, 46, stairBlock, 7);
        this.addBlock(world, 26, 26, 3, stairBlock, 6);
        this.addBlock(world, 26, 26, 4, lapisBlock, 8);
        this.addBlock(world, 26, 26, 5, stairBlock, 3);
        this.addBlock(world, 26, 26, 45, stairBlock, 2);
        this.addBlock(world, 26, 26, 46, lapisBlock, 8);
        this.addBlock(world, 26, 26, 47, stairBlock, 7);
        this.addBlock(world, 26, 27, 2, stairBlock, 6);
        this.addBlock(world, 26, 27, 3, lapisBlock, 8);
        this.addBlock(world, 26, 27, 4, stairBlock, 3);
        this.addBlock(world, 26, 27, 46, stairBlock, 2);
        this.addBlock(world, 26, 27, 47, lapisBlock, 8);
        this.addBlock(world, 26, 27, 48, stairBlock, 7);
        this.addBlock(world, 26, 28, 1, stairBlock, 6);
        this.addBlock(world, 26, 28, 2, lapisBlock, 8);
        this.addBlock(world, 26, 28, 3, stairBlock, 3);
        this.addBlock(world, 26, 28, 47, stairBlock, 2);
        this.addBlock(world, 26, 28, 48, lapisBlock, 8);
        this.addBlock(world, 26, 28, 49, stairBlock, 7);
        this.addBlock(world, 26, 29, 0, stairBlock, 6);
        this.addBlock(world, 26, 29, 1, lapisBlock, 8);
        this.addBlock(world, 26, 29, 2, stairBlock, 3);
        this.addBlock(world, 26, 29, 48, stairBlock, 2);
        this.addBlock(world, 26, 29, 49, lapisBlock, 8);
        this.addBlock(world, 26, 29, 50, stairBlock, 7);
        this.addBlock(world, 26, 30, 1, stairBlock, 3);
        this.addBlock(world, 26, 30, 49, stairBlock, 2);
        this.addBlock(world, 27, 8, 23, mainBlock, 1);
        this.addBlock(world, 27, 8, 24, stairBlock, 5);
        this.addBlock(world, 27, 8, 25, stairBlock, 5);
        this.addBlock(world, 27, 8, 26, stairBlock, 5);
        this.addBlock(world, 27, 8, 27, mainBlock, 1);
        this.addBlock(world, 27, 9, 23, wallBlock, 0);
        this.addBlock(world, 27, 9, 25, cannonBlock, 0);
        this.addBlock(world, 27, 9, 27, wallBlock, 0);
        this.addBlock(world, 27, 10, 10, stairBlock, 5);
        this.addBlock(world, 27, 10, 23, wallBlock, 0);
        this.addBlock(world, 27, 10, 27, wallBlock, 0);
        this.addBlock(world, 27, 10, 40, stairBlock, 5);
        this.addBlock(world, 27, 11, 10, mainBlock, 7);
        this.addBlock(world, 27, 11, 23, wallBlock, 0);
        this.addBlock(world, 27, 11, 27, wallBlock, 0);
        this.addBlock(world, 27, 11, 40, mainBlock, 7);
        this.addBlock(world, 27, 12, 9, stairBlock, 5);
        this.addBlock(world, 27, 12, 10, mainBlock, 7);
        this.addBlock(world, 27, 12, 11, stairBlock, 5);
        this.addBlock(world, 27, 12, 22, stairBlock, 6);
        this.addBlock(world, 27, 12, 23, mainBlock, 1);
        this.addBlock(world, 27, 12, 27, mainBlock, 1);
        this.addBlock(world, 27, 12, 28, stairBlock, 7);
        this.addBlock(world, 27, 12, 39, stairBlock, 5);
        this.addBlock(world, 27, 12, 40, mainBlock, 7);
        this.addBlock(world, 27, 12, 41, stairBlock, 5);
        this.addBlock(world, 27, 13, 9, mainBlock, 1);
        this.addBlock(world, 27, 13, 10, mainBlock, 1);
        this.addBlock(world, 27, 13, 11, mainBlock, 1);
        this.addBlock(world, 27, 13, 18, stairBlock, 6);
        this.addBlock(world, 27, 13, 19, mainBlock, 1);
        this.addBlock(world, 27, 13, 20, mainBlock, 1);
        this.addBlock(world, 27, 13, 21, mainBlock, 1);
        this.addBlock(world, 27, 13, 22, mainBlock, 1);
        this.addBlock(world, 27, 13, 23, mainBlock, 7);
        this.addBlock(world, 27, 13, 24, mainBlock, 1);
        this.addBlock(world, 27, 13, 25, stairBlock, 1);
        this.addBlock(world, 27, 13, 26, mainBlock, 1);
        this.addBlock(world, 27, 13, 27, mainBlock, 7);
        this.addBlock(world, 27, 13, 28, mainBlock, 1);
        this.addBlock(world, 27, 13, 29, mainBlock, 1);
        this.addBlock(world, 27, 13, 30, mainBlock, 1);
        this.addBlock(world, 27, 13, 31, mainBlock, 1);
        this.addBlock(world, 27, 13, 32, stairBlock, 7);
        this.addBlock(world, 27, 13, 39, mainBlock, 1);
        this.addBlock(world, 27, 13, 40, mainBlock, 1);
        this.addBlock(world, 27, 13, 41, mainBlock, 1);
        this.addBlock(world, 27, 14, 9, mainBlock, 1);
        this.addBlock(world, 27, 14, 10, stairBlock, 1);
        this.addBlock(world, 27, 14, 11, mainBlock, 1);
        this.addBlock(world, 27, 14, 18, wallBlock, 0);
        this.addBlock(world, 27, 14, 19, mainBlock, 1);
        this.addBlock(world, 27, 14, 20, stairBlock, 3);
        this.addBlock(world, 27, 14, 30, stairBlock, 2);
        this.addBlock(world, 27, 14, 31, mainBlock, 1);
        this.addBlock(world, 27, 14, 32, wallBlock, 0);
        this.addBlock(world, 27, 14, 39, mainBlock, 1);
        this.addBlock(world, 27, 14, 40, stairBlock, 1);
        this.addBlock(world, 27, 14, 41, mainBlock, 1);
        this.addBlock(world, 27, 15, 9, mainBlock, 1);
        this.addBlock(world, 27, 15, 10, windowBlock, 0);
        this.addBlock(world, 27, 15, 11, mainBlock, 1);
        this.addBlock(world, 27, 15, 19, mainBlock, 1);
        this.addBlock(world, 27, 15, 31, mainBlock, 1);
        this.addBlock(world, 27, 15, 39, mainBlock, 1);
        this.addBlock(world, 27, 15, 40, windowBlock, 0);
        this.addBlock(world, 27, 15, 41, mainBlock, 1);
        this.addBlock(world, 27, 16, 9, mainBlock, 1);
        this.addBlock(world, 27, 16, 10, windowBlock, 0);
        this.addBlock(world, 27, 16, 11, mainBlock, 1);
        this.addBlock(world, 27, 16, 19, stairBlock, 1);
        this.addBlock(world, 27, 16, 31, stairBlock, 1);
        this.addBlock(world, 27, 16, 39, mainBlock, 1);
        this.addBlock(world, 27, 16, 40, windowBlock, 0);
        this.addBlock(world, 27, 16, 41, mainBlock, 1);
        this.addBlock(world, 27, 17, 9, mainBlock, 1);
        this.addBlock(world, 27, 17, 10, windowBlock, 0);
        this.addBlock(world, 27, 17, 11, mainBlock, 1);
        this.addBlock(world, 27, 17, 39, mainBlock, 1);
        this.addBlock(world, 27, 17, 40, windowBlock, 0);
        this.addBlock(world, 27, 17, 41, mainBlock, 1);
        this.addBlock(world, 27, 18, 9, stairBlock, 1);
        this.addBlock(world, 27, 18, 10, mainBlock, 1);
        this.addBlock(world, 27, 18, 11, stairBlock, 1);
        this.addBlock(world, 27, 18, 39, stairBlock, 1);
        this.addBlock(world, 27, 18, 40, stairBlock, 5);
        this.addBlock(world, 27, 18, 41, stairBlock, 1);
        this.addBlock(world, 27, 19, 10, stairBlock, 1);
        this.addBlock(world, 27, 19, 40, stairBlock, 1);
        this.addBlock(world, 28, 12, 23, stairBlock, 5);
        this.addBlock(world, 28, 12, 24, mainBlock, 1);
        this.addBlock(world, 28, 12, 25, mainBlock, 1);
        this.addBlock(world, 28, 12, 26, mainBlock, 1);
        this.addBlock(world, 28, 12, 27, stairBlock, 5);
        this.addBlock(world, 28, 13, 10, mainBlock, 1);
        this.addBlock(world, 28, 13, 20, mainBlock, 1);
        this.addBlock(world, 28, 13, 21, mainBlock, 1);
        this.addBlock(world, 28, 13, 22, mainBlock, 1);
        this.addBlock(world, 28, 13, 23, mainBlock, 1);
        this.addBlock(world, 28, 13, 24, stairBlock, 3);
        this.addBlock(world, 28, 13, 25, accentBlock, 0);
        this.addBlock(world, 28, 13, 26, stairBlock, 2);
        this.addBlock(world, 28, 13, 27, mainBlock, 1);
        this.addBlock(world, 28, 13, 28, mainBlock, 1);
        this.addBlock(world, 28, 13, 29, mainBlock, 1);
        this.addBlock(world, 28, 13, 30, mainBlock, 1);
        this.addBlock(world, 28, 13, 40, mainBlock, 1);
        this.addBlock(world, 28, 14, 19, wallBlock, 0);
        this.addBlock(world, 28, 14, 31, wallBlock, 0);
        this.addBlock(world, 29, 12, 24, stairBlock, 5);
        this.addBlock(world, 29, 12, 25, slabBlock, 8);
        this.addBlock(world, 29, 12, 26, stairBlock, 5);
        this.addBlock(world, 29, 13, 10, mainBlock, 1);
        this.addBlock(world, 29, 13, 21, mainBlock, 1);
        this.addBlock(world, 29, 13, 22, mainBlock, 1);
        this.addBlock(world, 29, 13, 23, mainBlock, 1);
        this.addBlock(world, 29, 13, 24, mainBlock, 1);
        this.addBlock(world, 29, 13, 25, stairBlock, 0);
        this.addBlock(world, 29, 13, 26, mainBlock, 1);
        this.addBlock(world, 29, 13, 27, mainBlock, 1);
        this.addBlock(world, 29, 13, 28, mainBlock, 1);
        this.addBlock(world, 29, 13, 29, mainBlock, 1);
        this.addBlock(world, 29, 13, 40, mainBlock, 1);
        this.addBlock(world, 29, 14, 10, cannonBlock, 0);
        this.addBlock(world, 29, 14, 19, wallBlock, 0);
        this.addBlock(world, 29, 14, 20, wallBlock, 0);
        this.addBlock(world, 29, 14, 30, wallBlock, 0);
        this.addBlock(world, 29, 14, 31, wallBlock, 0);
        this.addBlock(world, 29, 14, 40, cannonBlock, 0);
        this.addBlock(world, 30, 12, 25, slabBlock, 8);
        this.addBlock(world, 30, 13, 22, mainBlock, 1);
        this.addBlock(world, 30, 13, 23, mainBlock, 1);
        this.addBlock(world, 30, 13, 24, mainBlock, 1);
        this.addBlock(world, 30, 13, 25, mainBlock, 1);
        this.addBlock(world, 30, 13, 26, mainBlock, 1);
        this.addBlock(world, 30, 13, 27, mainBlock, 1);
        this.addBlock(world, 30, 13, 28, mainBlock, 1);
        this.addBlock(world, 30, 14, 20, wallBlock, 0);
        this.addBlock(world, 30, 14, 21, wallBlock, 0);
        this.addBlock(world, 30, 14, 23, stairBlock, 0);
        this.addBlock(world, 30, 14, 27, stairBlock, 0);
        this.addBlock(world, 30, 14, 29, wallBlock, 0);
        this.addBlock(world, 30, 14, 30, wallBlock, 0);
        this.addBlock(world, 31, 12, 24, stairBlock, 4);
        this.addBlock(world, 31, 12, 25, slabBlock, 8);
        this.addBlock(world, 31, 12, 26, stairBlock, 4);
        this.addBlock(world, 31, 13, 23, mainBlock, 1);
        this.addBlock(world, 31, 13, 24, mainBlock, 1);
        this.addBlock(world, 31, 13, 25, mainBlock, 1);
        this.addBlock(world, 31, 13, 26, mainBlock, 1);
        this.addBlock(world, 31, 13, 27, mainBlock, 1);
        this.addBlock(world, 31, 14, 21, wallBlock, 0);
        this.addBlock(world, 31, 14, 22, wallBlock, 0);
        this.addBlock(world, 31, 14, 23, mainBlock, 1);
        this.addBlock(world, 31, 14, 27, mainBlock, 1);
        this.addBlock(world, 31, 14, 28, wallBlock, 0);
        this.addBlock(world, 31, 14, 29, wallBlock, 0);
        this.addBlock(world, 31, 15, 23, mainBlock, 1);
        this.addBlock(world, 31, 15, 27, mainBlock, 1);
        this.addBlock(world, 31, 16, 23, stairBlock, 2);
        this.addBlock(world, 31, 16, 24, stairBlock, 7);
        this.addBlock(world, 31, 16, 26, stairBlock, 6);
        this.addBlock(world, 31, 16, 27, stairBlock, 3);
        this.addBlock(world, 31, 17, 24, cannonBlock, 0);
        this.addBlock(world, 31, 17, 26, cannonBlock, 0);
        this.addBlock(world, 32, 11, 24, slabBlock, 8);
        this.addBlock(world, 32, 11, 26, slabBlock, 8);
        this.addBlock(world, 32, 12, 24, mainBlock, 1);
        this.addBlock(world, 32, 12, 25, slabBlock, 8);
        this.addBlock(world, 32, 12, 26, mainBlock, 1);
        this.addBlock(world, 32, 13, 23, stairBlock, 5);
        this.addBlock(world, 32, 13, 24, mainBlock, 1);
        this.addBlock(world, 32, 13, 25, mainBlock, 1);
        this.addBlock(world, 32, 13, 26, mainBlock, 1);
        this.addBlock(world, 32, 13, 27, stairBlock, 5);
        this.addBlock(world, 32, 14, 23, wallBlock, 0);
        this.addBlock(world, 32, 14, 27, wallBlock, 0);
        this.addBlock(world, 33, 12, 24, stairBlock, 5);
        this.addBlock(world, 33, 12, 25, slabBlock, 8);
        this.addBlock(world, 33, 12, 26, stairBlock, 5);
        this.addBlock(world, 33, 13, 24, mainBlock, 1);
        this.addBlock(world, 33, 13, 25, mainBlock, 1);
        this.addBlock(world, 33, 13, 26, mainBlock, 1);
        this.addBlock(world, 33, 14, 24, stairBlock, 0);
        this.addBlock(world, 33, 14, 26, stairBlock, 0);
        this.addBlock(world, 34, 12, 25, slabBlock, 8);
        this.addBlock(world, 34, 13, 24, stairBlock, 5);
        this.addBlock(world, 34, 13, 25, mainBlock, 1);
        this.addBlock(world, 34, 13, 26, stairBlock, 5);
        this.addBlock(world, 34, 14, 24, lapisBlock, 8);
        this.addBlock(world, 34, 14, 26, lapisBlock, 8);
        this.addBlock(world, 34, 15, 24, stairBlock, 0);
        this.addBlock(world, 34, 15, 26, stairBlock, 0);
        this.addBlock(world, 35, 12, 25, slabBlock, 8);
        this.addBlock(world, 35, 13, 24, stairBlock, 6);
        this.addBlock(world, 35, 13, 25, mainBlock, 1);
        this.addBlock(world, 35, 13, 26, stairBlock, 7);
        this.addBlock(world, 35, 14, 24, wallBlock, 0);
        this.addBlock(world, 35, 14, 26, wallBlock, 0);
        this.addBlock(world, 35, 15, 24, lapisBlock, 8);
        this.addBlock(world, 35, 15, 26, lapisBlock, 8);
        this.addBlock(world, 35, 16, 24, stairBlock, 0);
        this.addBlock(world, 35, 16, 26, stairBlock, 0);
        this.addBlock(world, 36, 12, 25, slabBlock, 8);
        this.addBlock(world, 36, 13, 24, stairBlock, 6);
        this.addBlock(world, 36, 13, 25, mainBlock, 1);
        this.addBlock(world, 36, 13, 26, stairBlock, 7);
        this.addBlock(world, 36, 14, 24, wallBlock, 0);
        this.addBlock(world, 36, 14, 26, wallBlock, 0);
        this.addBlock(world, 36, 15, 24, wallBlock, 0);
        this.addBlock(world, 36, 15, 26, wallBlock, 0);
        this.addBlock(world, 36, 16, 24, lapisBlock, 8);
        this.addBlock(world, 36, 16, 26, lapisBlock, 8);
        this.addBlock(world, 36, 17, 24, stairBlock, 0);
        this.addBlock(world, 36, 17, 26, stairBlock, 0);
        this.addBlock(world, 37, 12, 25, slabBlock, 8);
        this.addBlock(world, 37, 13, 24, stairBlock, 6);
        this.addBlock(world, 37, 13, 25, mainBlock, 1);
        this.addBlock(world, 37, 13, 26, stairBlock, 7);
        this.addBlock(world, 37, 14, 24, wallBlock, 0);
        this.addBlock(world, 37, 14, 26, wallBlock, 0);
        this.addBlock(world, 37, 16, 24, stairBlock, 5);
        this.addBlock(world, 37, 16, 26, stairBlock, 5);
        this.addBlock(world, 37, 17, 24, lapisBlock, 8);
        this.addBlock(world, 37, 17, 26, lapisBlock, 8);
        this.addBlock(world, 37, 18, 24, stairBlock, 0);
        this.addBlock(world, 37, 18, 26, stairBlock, 0);
        this.addBlock(world, 38, 10, 25, stairBlock, 4);
        this.addBlock(world, 38, 11, 25, mainBlock, 7);
        this.addBlock(world, 38, 12, 24, stairBlock, 4);
        this.addBlock(world, 38, 12, 25, mainBlock, 7);
        this.addBlock(world, 38, 12, 26, stairBlock, 4);
        this.addBlock(world, 38, 13, 24, mainBlock, 1);
        this.addBlock(world, 38, 13, 25, mainBlock, 1);
        this.addBlock(world, 38, 13, 26, mainBlock, 1);
        this.addBlock(world, 38, 14, 24, mainBlock, 1);
        this.addBlock(world, 38, 14, 26, mainBlock, 1);
        this.addBlock(world, 38, 15, 24, mainBlock, 1);
        this.addBlock(world, 38, 15, 26, mainBlock, 1);
        this.addBlock(world, 38, 16, 24, mainBlock, 1);
        this.addBlock(world, 38, 16, 26, mainBlock, 1);
        this.addBlock(world, 38, 17, 24, mainBlock, 1);
        this.addBlock(world, 38, 17, 26, mainBlock, 1);
        this.addBlock(world, 38, 18, 24, lapisBlock, 8);
        this.addBlock(world, 38, 18, 25, stairBlock, 4);
        this.addBlock(world, 38, 18, 26, lapisBlock, 8);
        this.addBlock(world, 38, 19, 24, stairBlock, 0);
        this.addBlock(world, 38, 19, 25, stairBlock, 0);
        this.addBlock(world, 38, 19, 26, stairBlock, 0);
        this.addBlock(world, 39, 8, 25, stairBlock, 4);
        this.addBlock(world, 39, 9, 24, slabBlock, 8);
        this.addBlock(world, 39, 9, 25, lapisBlock, 8);
        this.addBlock(world, 39, 9, 26, slabBlock, 8);
        this.addBlock(world, 39, 10, 24, mainBlock, 7);
        this.addBlock(world, 39, 10, 26, mainBlock, 7);
        this.addBlock(world, 39, 11, 24, mainBlock, 7);
        this.addBlock(world, 39, 11, 26, mainBlock, 7);
        this.addBlock(world, 39, 12, 23, stairBlock, 6);
        this.addBlock(world, 39, 12, 24, mainBlock, 7);
        this.addBlock(world, 39, 12, 26, mainBlock, 7);
        this.addBlock(world, 39, 12, 27, stairBlock, 7);
        this.addBlock(world, 39, 13, 23, mainBlock, 1);
        this.addBlock(world, 39, 13, 24, mainBlock, 1);
        this.addBlock(world, 39, 13, 25, mainBlock, 1);
        this.addBlock(world, 39, 13, 26, mainBlock, 1);
        this.addBlock(world, 39, 13, 27, mainBlock, 1);
        this.addBlock(world, 39, 14, 23, mainBlock, 1);
        this.addBlock(world, 39, 14, 27, mainBlock, 1);
        this.addBlock(world, 39, 15, 23, mainBlock, 1);
        this.addBlock(world, 39, 15, 27, mainBlock, 1);
        this.addBlock(world, 39, 16, 23, mainBlock, 1);
        this.addBlock(world, 39, 16, 27, mainBlock, 1);
        this.addBlock(world, 39, 17, 23, mainBlock, 1);
        this.addBlock(world, 39, 17, 27, mainBlock, 1);
        this.addBlock(world, 39, 18, 23, stairBlock, 2);
        this.addBlock(world, 39, 18, 24, stairBlock, 5);
        this.addBlock(world, 39, 18, 26, stairBlock, 5);
        this.addBlock(world, 39, 18, 27, stairBlock, 3);
        this.addBlock(world, 39, 19, 24, mainBlock, 7);
        this.addBlock(world, 39, 19, 25, mainBlock, 7);
        this.addBlock(world, 39, 19, 26, mainBlock, 7);
        this.addBlock(world, 39, 20, 24, stairBlock, 0);
        this.addBlock(world, 39, 20, 25, stairBlock, 0);
        this.addBlock(world, 39, 20, 26, stairBlock, 0);
        this.addBlock(world, 40, 4, 25, wallBlock, 0);
        this.addBlock(world, 40, 5, 25, wallBlock, 0);
        this.addBlock(world, 40, 6, 25, wallBlock, 0);
        this.addBlock(world, 40, 7, 25, wallBlock, 0);
        this.addBlock(world, 40, 8, 24, stairBlock, 6);
        this.addBlock(world, 40, 8, 25, lightBlock, 0);
        this.addBlock(world, 40, 8, 26, stairBlock, 7);
        this.addBlock(world, 40, 9, 24, lapisBlock, 8);
        this.addBlock(world, 40, 9, 26, lapisBlock, 8);
        this.addBlock(world, 40, 10, 23, stairBlock, 6);
        this.addBlock(world, 40, 10, 27, stairBlock, 7);
        this.addBlock(world, 40, 11, 23, mainBlock, 7);
        this.addBlock(world, 40, 11, 27, mainBlock, 7);
        this.addBlock(world, 40, 12, 23, mainBlock, 7);
        this.addBlock(world, 40, 12, 27, mainBlock, 7);
        this.addBlock(world, 40, 13, 21, mainBlock, 1);
        this.addBlock(world, 40, 13, 22, mainBlock, 1);
        this.addBlock(world, 40, 13, 23, mainBlock, 1);
        this.addBlock(world, 40, 13, 24, mainBlock, 1);
        this.addBlock(world, 40, 13, 26, mainBlock, 1);
        this.addBlock(world, 40, 13, 27, mainBlock, 1);
        this.addBlock(world, 40, 13, 28, mainBlock, 1);
        this.addBlock(world, 40, 13, 29, mainBlock, 1);
        this.addBlock(world, 40, 14, 21, cannonBlock, 0);
        this.addBlock(world, 40, 14, 23, stairBlock, 2);
        this.addBlock(world, 40, 14, 27, stairBlock, 3);
        this.addBlock(world, 40, 14, 29, cannonBlock, 0);
        this.addBlock(world, 40, 15, 23, windowBlock, 0);
        this.addBlock(world, 40, 15, 27, windowBlock, 0);
        this.addBlock(world, 40, 16, 23, windowBlock, 0);
        this.addBlock(world, 40, 16, 27, windowBlock, 0);
        this.addBlock(world, 40, 17, 23, windowBlock, 0);
        this.addBlock(world, 40, 17, 27, windowBlock, 0);
        this.addBlock(world, 40, 18, 23, stairBlock, 6);
        this.addBlock(world, 40, 18, 27, mainBlock, 1);
        this.addBlock(world, 40, 19, 23, stairBlock, 2);
        this.addBlock(world, 40, 19, 24, mainBlock, 7);
        this.addBlock(world, 40, 19, 25, wallBlock, 0);
        this.addBlock(world, 40, 19, 26, mainBlock, 7);
        this.addBlock(world, 40, 19, 27, stairBlock, 3);
        this.addBlock(world, 40, 20, 24, lapisBlock, 8);
        this.addBlock(world, 40, 20, 25, lightBlock, 0);
        this.addBlock(world, 40, 20, 26, lapisBlock, 8);
        this.addBlock(world, 40, 21, 24, stairBlock, 0);
        this.addBlock(world, 40, 21, 25, slabBlock, 0);
        this.addBlock(world, 40, 21, 26, stairBlock, 0);
        this.addBlock(world, 41, 8, 25, stairBlock, 5);
        this.addBlock(world, 41, 9, 24, slabBlock, 8);
        this.addBlock(world, 41, 9, 25, lapisBlock, 8);
        this.addBlock(world, 41, 9, 26, slabBlock, 8);
        this.addBlock(world, 41, 10, 24, mainBlock, 7);
        this.addBlock(world, 41, 10, 26, mainBlock, 7);
        this.addBlock(world, 41, 11, 24, mainBlock, 7);
        this.addBlock(world, 41, 11, 26, mainBlock, 7);
        this.addBlock(world, 41, 12, 23, stairBlock, 6);
        this.addBlock(world, 41, 12, 24, mainBlock, 7);
        this.addBlock(world, 41, 12, 26, mainBlock, 7);
        this.addBlock(world, 41, 12, 27, stairBlock, 7);
        this.addBlock(world, 41, 13, 23, mainBlock, 1);
        this.addBlock(world, 41, 13, 24, mainBlock, 1);
        this.addBlock(world, 41, 13, 25, mainBlock, 1);
        this.addBlock(world, 41, 13, 26, mainBlock, 1);
        this.addBlock(world, 41, 13, 27, mainBlock, 1);
        this.addBlock(world, 41, 14, 23, mainBlock, 1);
        this.addBlock(world, 41, 14, 27, mainBlock, 1);
        this.addBlock(world, 41, 15, 23, mainBlock, 1);
        this.addBlock(world, 41, 15, 27, mainBlock, 1);
        this.addBlock(world, 41, 16, 23, mainBlock, 1);
        this.addBlock(world, 41, 16, 27, mainBlock, 1);
        this.addBlock(world, 41, 17, 23, mainBlock, 1);
        this.addBlock(world, 41, 17, 27, mainBlock, 1);
        this.addBlock(world, 41, 18, 23, stairBlock, 2);
        this.addBlock(world, 41, 18, 24, stairBlock, 4);
        this.addBlock(world, 41, 18, 26, stairBlock, 4);
        this.addBlock(world, 41, 18, 27, stairBlock, 3);
        this.addBlock(world, 41, 19, 24, mainBlock, 7);
        this.addBlock(world, 41, 19, 25, mainBlock, 7);
        this.addBlock(world, 41, 19, 26, mainBlock, 7);
        this.addBlock(world, 41, 20, 24, stairBlock, 5);
        this.addBlock(world, 41, 20, 25, stairBlock, 1);
        this.addBlock(world, 41, 20, 26, stairBlock, 5);
        this.addBlock(world, 41, 21, 24, lapisBlock, 8);
        this.addBlock(world, 41, 21, 26, lapisBlock, 8);
        this.addBlock(world, 41, 22, 24, stairBlock, 0);
        this.addBlock(world, 41, 22, 26, stairBlock, 0);
        this.addBlock(world, 42, 10, 25, stairBlock, 5);
        this.addBlock(world, 42, 11, 25, mainBlock, 7);
        this.addBlock(world, 42, 12, 24, stairBlock, 5);
        this.addBlock(world, 42, 12, 25, mainBlock, 7);
        this.addBlock(world, 42, 12, 26, stairBlock, 5);
        this.addBlock(world, 42, 13, 24, mainBlock, 1);
        this.addBlock(world, 42, 13, 25, mainBlock, 1);
        this.addBlock(world, 42, 13, 26, mainBlock, 1);
        this.addBlock(world, 42, 14, 24, mainBlock, 1);
        this.addBlock(world, 42, 14, 25, stairBlock, 1);
        this.addBlock(world, 42, 14, 26, mainBlock, 1);
        this.addBlock(world, 42, 15, 24, mainBlock, 1);
        this.addBlock(world, 42, 15, 25, windowBlock, 0);
        this.addBlock(world, 42, 15, 26, mainBlock, 1);
        this.addBlock(world, 42, 16, 24, mainBlock, 1);
        this.addBlock(world, 42, 16, 25, windowBlock, 0);
        this.addBlock(world, 42, 16, 26, mainBlock, 1);
        this.addBlock(world, 42, 17, 24, mainBlock, 1);
        this.addBlock(world, 42, 17, 25, windowBlock, 0);
        this.addBlock(world, 42, 17, 26, mainBlock, 1);
        this.addBlock(world, 42, 18, 24, stairBlock, 1);
        this.addBlock(world, 42, 18, 25, stairBlock, 5);
        this.addBlock(world, 42, 18, 26, stairBlock, 1);
        this.addBlock(world, 42, 19, 25, stairBlock, 1);
        this.addBlock(world, 42, 21, 24, stairBlock, 5);
        this.addBlock(world, 42, 21, 26, stairBlock, 5);
        this.addBlock(world, 42, 22, 24, lapisBlock, 8);
        this.addBlock(world, 42, 22, 26, lapisBlock, 8);
        this.addBlock(world, 42, 23, 24, stairBlock, 0);
        this.addBlock(world, 42, 23, 26, stairBlock, 0);
        this.addBlock(world, 43, 13, 25, mainBlock, 1);
        this.addBlock(world, 43, 22, 24, stairBlock, 5);
        this.addBlock(world, 43, 22, 26, stairBlock, 5);
        this.addBlock(world, 43, 23, 24, lapisBlock, 8);
        this.addBlock(world, 43, 23, 26, lapisBlock, 8);
        this.addBlock(world, 43, 24, 24, stairBlock, 0);
        this.addBlock(world, 43, 24, 26, stairBlock, 0);
        this.addBlock(world, 44, 13, 25, mainBlock, 1);
        this.addBlock(world, 44, 14, 25, cannonBlock, 0);
        this.addBlock(world, 44, 23, 24, stairBlock, 5);
        this.addBlock(world, 44, 23, 26, stairBlock, 5);
        this.addBlock(world, 44, 24, 24, lapisBlock, 8);
        this.addBlock(world, 44, 24, 26, lapisBlock, 8);
        this.addBlock(world, 44, 25, 24, stairBlock, 0);
        this.addBlock(world, 44, 25, 26, stairBlock, 0);
        this.addBlock(world, 45, 24, 24, stairBlock, 5);
        this.addBlock(world, 45, 24, 26, stairBlock, 5);
        this.addBlock(world, 45, 25, 24, lapisBlock, 8);
        this.addBlock(world, 45, 25, 26, lapisBlock, 8);
        this.addBlock(world, 45, 26, 24, stairBlock, 0);
        this.addBlock(world, 45, 26, 26, stairBlock, 0);
        this.addBlock(world, 46, 25, 24, stairBlock, 5);
        this.addBlock(world, 46, 25, 26, stairBlock, 5);
        this.addBlock(world, 46, 26, 24, lapisBlock, 8);
        this.addBlock(world, 46, 26, 26, lapisBlock, 8);
        this.addBlock(world, 46, 27, 24, stairBlock, 0);
        this.addBlock(world, 46, 27, 26, stairBlock, 0);
        this.addBlock(world, 47, 26, 24, stairBlock, 5);
        this.addBlock(world, 47, 26, 26, stairBlock, 5);
        this.addBlock(world, 47, 27, 24, lapisBlock, 8);
        this.addBlock(world, 47, 27, 26, lapisBlock, 8);
        this.addBlock(world, 47, 28, 24, stairBlock, 0);
        this.addBlock(world, 47, 28, 26, stairBlock, 0);
        this.addBlock(world, 48, 27, 24, stairBlock, 5);
        this.addBlock(world, 48, 27, 26, stairBlock, 5);
        this.addBlock(world, 48, 28, 24, lapisBlock, 8);
        this.addBlock(world, 48, 28, 26, lapisBlock, 8);
        this.addBlock(world, 48, 29, 24, stairBlock, 0);
        this.addBlock(world, 48, 29, 26, stairBlock, 0);
        this.addBlock(world, 49, 28, 24, stairBlock, 5);
        this.addBlock(world, 49, 28, 26, stairBlock, 5);
        this.addBlock(world, 49, 29, 24, lapisBlock, 8);
        this.addBlock(world, 49, 29, 26, lapisBlock, 8);
        this.addBlock(world, 49, 30, 24, stairBlock, 0);
        this.addBlock(world, 49, 30, 26, stairBlock, 0);
        this.addBlock(world, 50, 29, 24, stairBlock, 5);
        this.addBlock(world, 50, 29, 26, stairBlock, 5);
        this.addBlock(world, 24, 9, 25, ladderBlock, 4);
        this.addBlock(world, 24, 10, 25, ladderBlock, 4);
        this.addBlock(world, 24, 11, 25, ladderBlock, 4);
        this.addBlock(world, 25, 9, 24, ladderBlock, 2);
        this.addBlock(world, 25, 9, 26, ladderBlock, 3);
        this.addBlock(world, 25, 10, 24, ladderBlock, 2);
        this.addBlock(world, 25, 10, 26, ladderBlock, 3);
        this.addBlock(world, 25, 11, 24, ladderBlock, 2);
        this.addBlock(world, 25, 11, 26, ladderBlock, 3);
        this.addBlock(world, 26, 9, 25, ladderBlock, 5);
        this.addBlock(world, 26, 10, 25, ladderBlock, 5);
        this.addBlock(world, 26, 11, 25, ladderBlock, 5);
        Class<EntityUnderworldSilverfish> e = EntityUnderworldSilverfish.class;
        this.addSpawner(world, 10, 13, 25, e);
        this.addSpawner(world, 25, 13, 10, e);
        this.addSpawner(world, 25, 13, 25, e);
        this.addSpawner(world, 25, 13, 40, e);
        this.addSpawner(world, 40, 13, 25, e);
        this.lootChests.setChestPlaced(0, this.generateStructureChestContents(world, box, rand, 10, 14, 25, 5, 0));
        this.lootChests.setChestPlaced(1, this.generateStructureChestContents(world, box, rand, 25, 14, 10, 3, 1));
        this.lootChests.setChestPlaced(2, this.generateStructureChestContents(world, box, rand, 25, 14, 25, 4, 2));
        this.lootChests.setChestPlaced(3, this.generateStructureChestContents(world, box, rand, 25, 14, 40, 2, 3));
        this.lootChests.setChestPlaced(4, this.generateStructureChestContents(world, box, rand, 40, 14, 25, 4, 4));
        return true;
    }
}

