/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.items;

import cpw.mods.ironchest.common.blocks.shulker.IronShulkerBoxType;
import cpw.mods.ironchest.common.items.shulker.ItemShulkerBoxChanger;
import net.minecraft.item.Item;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum ShulkerBoxChangerType {
    IRON_GOLD(IronShulkerBoxType.IRON, IronShulkerBoxType.GOLD, "iron_gold_shulker_upgrade"),
    GOLD_DIAMOND(IronShulkerBoxType.GOLD, IronShulkerBoxType.DIAMOND, "gold_diamond_shulker_upgrade"),
    COPPER_SILVER(IronShulkerBoxType.COPPER, IronShulkerBoxType.SILVER, "copper_silver_shulker_upgrade"),
    SILVER_GOLD(IronShulkerBoxType.SILVER, IronShulkerBoxType.GOLD, "silver_gold_shulker_upgrade"),
    COPPER_IRON(IronShulkerBoxType.COPPER, IronShulkerBoxType.IRON, "copper_iron_shulker_upgrade"),
    DIAMOND_CRYSTAL(IronShulkerBoxType.DIAMOND, IronShulkerBoxType.CRYSTAL, "diamond_crystal_shulker_upgrade"),
    VANILLA_IRON(IronShulkerBoxType.VANILLA, IronShulkerBoxType.IRON, "vanilla_iron_shulker_upgrade"),
    VANILLA_COPPER(IronShulkerBoxType.VANILLA, IronShulkerBoxType.COPPER, "vanilla_copper_shulker_upgrade"),
    DIAMOND_OBSIDIAN(IronShulkerBoxType.DIAMOND, IronShulkerBoxType.OBSIDIAN, "diamond_obsidian_shulker_upgrade");

    public static final ShulkerBoxChangerType[] VALUES;
    public final IronShulkerBoxType source;
    public final IronShulkerBoxType target;
    public final String itemName;
    public ItemShulkerBoxChanger item;

    private ShulkerBoxChangerType(IronShulkerBoxType source, IronShulkerBoxType target, String itemName) {
        this.source = source;
        this.target = target;
        this.itemName = itemName;
    }

    public boolean canUpgrade(IronShulkerBoxType from) {
        return from == this.source;
    }

    public ItemShulkerBoxChanger buildItem(IForgeRegistry<Item> itemRegistry) {
        this.item = new ItemShulkerBoxChanger(this);
        this.item.setRegistryName(this.itemName);
        itemRegistry.register((IForgeRegistryEntry)this.item);
        return this.item;
    }

    public static void buildItems(IForgeRegistry<Item> itemRegistry) {
        for (ShulkerBoxChangerType type : VALUES) {
            type.buildItem(itemRegistry);
        }
    }

    static {
        VALUES = ShulkerBoxChangerType.values();
    }
}

