/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block.upgrade;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.IConveyorContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.TextGuiComponent;
import com.buuz135.industrial.gui.component.TextureGuiComponent;
import com.buuz135.industrial.gui.component.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.proxy.block.Cuboid;
import com.buuz135.industrial.proxy.block.tile.TileEntityConveyor;
import com.buuz135.industrial.proxy.network.ConveyorSplittingSyncEntityMessage;
import com.buuz135.industrial.utils.MovementUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ConveyorSplittingUpgrade
extends ConveyorUpgrade {
    public static Cuboid NORTH = new Cuboid(0.295, 0.1, -0.08000000000000002, 0.6950000000000001, 0.16, 0.31999999999999995, EnumFacing.NORTH.func_176745_a(), false);
    public static Cuboid SOUTH = new Cuboid(0.295, 0.1, 0.6799999999999999, 0.6950000000000001, 0.16, 1.08, EnumFacing.SOUTH.func_176745_a(), false);
    public static Cuboid WEST = new Cuboid(-0.08, 0.1, 0.3, 0.32, 0.16, 0.7, EnumFacing.WEST.func_176745_a(), false);
    public static Cuboid EAST = new Cuboid(0.67, 0.1, 0.3, 1.07, 0.16, 0.7, EnumFacing.EAST.func_176745_a(), false);
    public List<Integer> handlingEntities = new ArrayList<Integer>();
    private EnumFacing nextFacing;
    private int ratio;
    private int currentRatio;

    public ConveyorSplittingUpgrade(IConveyorContainer container, ConveyorUpgradeFactory factory, EnumFacing side) {
        super(container, factory, side);
        this.nextFacing = side;
        this.ratio = 1;
        this.currentRatio = 1;
    }

    @Override
    public void handleEntity(Entity entity) {
        super.handleEntity(entity);
        if (!this.getWorld().field_72995_K && !this.getContainer().getEntityFilter().contains(entity.func_145782_y()) && this.nextFacing == this.getSide()) {
            this.handlingEntities.add(entity.func_145782_y());
            this.getContainer().getEntityFilter().add(entity.func_145782_y());
            IndustrialForegoing.NETWORK.sendToAllAround((IMessage)new ConveyorSplittingSyncEntityMessage(this.getPos(), entity.func_145782_y(), this.getSide()), new NetworkRegistry.TargetPoint(this.getWorld().field_73011_w.getDimension(), (double)this.getPos().func_177958_n(), (double)this.getPos().func_177956_o(), (double)this.getPos().func_177952_p(), 64.0));
            this.findNextUpgradeAndUpdate();
        }
        if (this.handlingEntities.contains(entity.func_145782_y())) {
            MovementUtils.handleConveyorMovement(entity, this.getSide(), this.getPos(), ((TileEntityConveyor)this.getContainer()).getType());
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.handlingEntities.isEmpty()) {
            return;
        }
        AxisAlignedBB box = this.getWorld().func_180495_p(this.getPos()).func_185890_d((IBlockAccess)this.getWorld(), this.getPos()).func_186670_a(this.getPos()).func_186662_g(0.04);
        for (Integer integer : new ArrayList<Integer>(this.handlingEntities)) {
            Entity entity = this.getWorld().func_73045_a(integer.intValue());
            if (entity == null || box.func_72326_a(entity.func_174813_aQ())) continue;
            this.handlingEntities.remove(integer);
            this.getContainer().getEntityFilter().remove(integer);
        }
    }

    @Override
    public void onUpgradeRemoved() {
        super.onUpgradeRemoved();
        if (this.nextFacing == this.getSide()) {
            this.findNextUpgradeAndUpdate();
        }
    }

    public void findNextUpgradeAndUpdate() {
        int y;
        --this.currentRatio;
        if (this.currentRatio > 0) {
            this.getContainer().requestSync();
            return;
        }
        this.currentRatio = this.ratio;
        EnumFacing facing = this.nextFacing.func_176746_e();
        ConveyorUpgrade conveyorUpgrade = ((TileEntityConveyor)this.getContainer()).getUpgradeMap().get(facing);
        for (y = 0; !(conveyorUpgrade instanceof ConveyorSplittingUpgrade) && y < 10; ++y) {
            facing = facing.func_176746_e();
            conveyorUpgrade = ((TileEntityConveyor)this.getContainer()).getUpgradeMap().get(facing);
        }
        if (y >= 10) {
            facing = this.getSide();
        }
        TileEntityConveyor entityConveyor = (TileEntityConveyor)this.getContainer();
        for (EnumFacing enumFacing : entityConveyor.getUpgradeMap().keySet()) {
            ConveyorUpgrade upgrade = entityConveyor.getUpgradeMap().get(enumFacing);
            if (!(upgrade instanceof ConveyorSplittingUpgrade)) continue;
            ((ConveyorSplittingUpgrade)upgrade).setNextFacing(facing);
        }
        this.getContainer().requestSync();
    }

    @Override
    public Cuboid getBoundingBox() {
        switch (this.getSide()) {
            default: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: 
        }
        return EAST;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT() == null ? new NBTTagCompound() : super.serializeNBT();
        compound.func_74778_a("NextFacing", this.nextFacing.func_176610_l());
        compound.func_74768_a("Ratio", this.ratio);
        compound.func_74768_a("CurrentRatio", this.currentRatio);
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.nextFacing = EnumFacing.func_176739_a((String)nbt.func_74779_i("NextFacing"));
        this.ratio = nbt.func_74762_e("Ratio");
        this.currentRatio = nbt.func_74762_e("CurrentRatio");
    }

    public EnumFacing getNextFacing() {
        return this.nextFacing;
    }

    public void setNextFacing(EnumFacing nextFacing) {
        this.nextFacing = nextFacing;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TextureGuiComponent(20, 26, 16, 16, res, 40, 234, "splitting_ratio"));
        componentList.add(new TextGuiComponent(40, 31){

            @Override
            public String getText() {
                return TextFormatting.DARK_GRAY + (ConveyorSplittingUpgrade.this.ratio < 10 ? " " : "") + ConveyorSplittingUpgrade.this.ratio;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(0, 60, 26, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 104, new String[]{"increase"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(1, 76, 26, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 16, 104, new String[]{"decrease"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
    }

    @Override
    public void handleButtonInteraction(int buttonId, NBTTagCompound compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId == 0 && this.ratio <= 64) {
            ++this.ratio;
            this.currentRatio = this.ratio;
            this.getContainer().requestSync();
        }
        if (buttonId == 1 && this.ratio > 1) {
            --this.ratio;
            this.currentRatio = this.ratio;
            this.getContainer().requestSync();
        }
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("splitting");
        }

        @Override
        public ConveyorUpgrade create(IConveyorContainer container, EnumFacing face) {
            return new ConveyorSplittingUpgrade(container, this, face);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(EnumFacing upgradeSide, EnumFacing conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_splitting_" + upgradeSide.func_176610_l().toLowerCase());
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_splitting_upgrade");
        }
    }
}

