/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.entity.ai.EntityAIBlockRiderIdleTasks;
import fi.dy.masa.enderutilities.entity.ai.EntityAIControlledByPlayerUsingHarness;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemMobHarness
extends ItemEnderUtilities {
    public ItemMobHarness(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77978_p() == null || !this.hasTarget(stack)) {
            return super.func_77653_i(stack);
        }
        String target = stack.func_77978_p().func_74779_i("TargetName");
        return super.func_77653_i(stack) + " " + TextFormatting.GREEN + target + TextFormatting.RESET + TextFormatting.WHITE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult rayTraceResult;
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af() && (rayTraceResult = this.func_77621_a(world, player, true)) != null && rayTraceResult.field_72313_a != RayTraceResult.Type.ENTITY && player.field_70125_A > 80.0f) {
            this.clearData(stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static void addAITask(Entity entity, boolean replaceOld) {
        Entity bottom = EntityUtils.getBottomEntity(entity);
        List<Entity> entities = EntityUtils.getAllEntitiesInStack(entity);
        for (Entity entityTmp : entities) {
            if (!(entityTmp instanceof EntityLiving)) continue;
            EntityLiving living = (EntityLiving)entityTmp;
            living.func_70661_as().func_75499_g();
            EntityUtils.addAITaskAfterTasks(living, new EntityAIBlockRiderIdleTasks(living), replaceOld, new Class[]{EntityAISwimming.class, EntityAIPanic.class});
        }
        if (bottom instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)bottom;
            EntityUtils.addAITaskAfterTasks(living, new EntityAIControlledByPlayerUsingHarness(living, 0.3f), replaceOld, new Class[]{EntityAISwimming.class, EntityAIPanic.class});
        }
    }

    public boolean handleInteraction(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.func_70093_af()) {
            player.func_184205_a(entity, true);
            ItemMobHarness.addAITask(entity, true);
            return true;
        }
        if (this.hasTarget(stack)) {
            this.mountTarget(stack, player.func_130014_f_(), player, entity);
        } else if (player.field_70125_A < -80.0f && player.func_184207_aI()) {
            player.func_184226_ay();
        } else if (entity.func_184218_aH()) {
            entity.func_184210_p();
        } else {
            this.storeTarget(stack, entity);
        }
        return true;
    }

    public boolean hasTarget(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Mode", 1)) {
            return false;
        }
        byte mode = nbt.func_74771_c("Mode");
        return mode >= 1 && mode <= 2 && nbt.func_150297_b("TargetUUIDMost", 4) && nbt.func_150297_b("TargetUUIDLeast", 4) && nbt.func_150297_b("TargetName", 8);
    }

    public ItemStack storeTarget(ItemStack stack, Entity entity) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, null, true);
        byte mode = (byte)(entity instanceof EntityPlayer ? 2 : 1);
        nbt.func_74778_a("TargetName", entity.func_70005_c_());
        nbt.func_74772_a("TargetUUIDMost", entity.func_110124_au().getMostSignificantBits());
        nbt.func_74772_a("TargetUUIDLeast", entity.func_110124_au().getLeastSignificantBits());
        nbt.func_74774_a("Mode", mode);
        return stack;
    }

    private boolean mountTarget(ItemStack stack, World world, EntityPlayer player, Entity targetEntity) {
        if (stack.func_77978_p() == null || targetEntity == null) {
            return false;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        byte mode = nbt.func_74771_c("Mode");
        UUID storedUUID = new UUID(nbt.func_74763_f("TargetUUIDMost"), nbt.func_74763_f("TargetUUIDLeast"));
        Object storedEntity = null;
        double r = 64.0;
        if (storedUUID.equals(targetEntity.func_110124_au())) {
            EntityUtils.unmountFirstRider((Entity)player);
            targetEntity.func_184205_a((Entity)player, true);
            this.clearData(stack);
            return true;
        }
        if (mode == 1) {
            List entities = world.func_72839_b((Entity)player, new AxisAlignedBB(player.field_70165_t - r, player.field_70163_u - r, player.field_70161_v - r, player.field_70165_t + r, player.field_70163_u + r, player.field_70161_v + r));
            storedEntity = EntityUtils.findEntityByUUID(entities, storedUUID);
        } else if (mode == 2) {
            storedEntity = world.func_152378_a(storedUUID);
        }
        if (storedEntity != null && storedEntity.field_71093_bK == player.field_71093_bK) {
            if (!EntityUtils.doesEntityStackContainEntity((Entity)storedEntity, targetEntity)) {
                storedEntity.func_184205_a(targetEntity, true);
                this.clearData(stack);
                return true;
            }
        } else if (storedEntity == null && !world.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.mobharness.targetnotfoundoroutofrange", new Object[0]), true);
        }
        return false;
    }

    public boolean clearData(ItemStack stack) {
        stack.func_77982_d(null);
        return true;
    }

    @Override
    public void addTooltipLines(ItemStack stack, EntityPlayer player, List<String> list, boolean verbose) {
        if (stack.func_77978_p() == null || !this.hasTarget(stack)) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.notlinked", (Object[])new Object[0]));
            return;
        }
        String target = stack.func_77978_p().func_74779_i("TargetName");
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.linked", (Object[])new Object[0]) + ": " + TextFormatting.GREEN + target + TextFormatting.RESET + TextFormatting.GRAY);
    }

    @Override
    protected void addItemOverrides() {
        this.func_185043_a(new ResourceLocation("enderutilities", "linked"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return ItemMobHarness.this.hasTarget(stack) ? 1.0f : 0.0f;
            }
        });
    }
}

