/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.wrapper;

import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerCraftResult;
import javax.annotation.Nonnull;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InventoryCraftingEnderUtilities
extends InventoryCrafting {
    private final int inventoryWidth;
    private final int inventoryHeight;
    private final ItemHandlerCraftResult craftResult;
    protected final IItemHandlerModifiable craftMatrix;
    protected final EntityPlayer player;

    public InventoryCraftingEnderUtilities(int width, int height, IItemHandlerModifiable craftMatrix, ItemHandlerCraftResult resultInventory, EntityPlayer player, Container container) {
        super(container, 0, 0);
        this.inventoryWidth = width;
        this.inventoryHeight = height;
        this.craftMatrix = craftMatrix;
        this.craftResult = resultInventory;
        this.player = player;
    }

    public int func_174923_h() {
        return this.inventoryHeight;
    }

    public int func_174922_i() {
        return this.inventoryWidth;
    }

    public int func_70302_i_() {
        return this.craftMatrix.getSlots();
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= this.func_70302_i_() ? ItemStack.field_190927_a : this.craftMatrix.getStackInSlot(slot);
    }

    public boolean func_191420_l() {
        int invSize = this.craftMatrix.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            if (this.func_70301_a(slot).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70463_b(int row, int column) {
        if (row >= 0 && row < this.inventoryWidth && column >= 0 && column <= this.inventoryHeight) {
            return this.func_70301_a(row + column * this.inventoryWidth);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int slot) {
        return this.craftMatrix.extractItem(slot, Integer.MAX_VALUE, false);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.craftMatrix.extractItem(slot, amount, false);
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.craftMatrix.setStackInSlot(slot, stack);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return this.craftMatrix.getSlotLimit(0);
    }

    public void func_174888_l() {
        for (int slot = 0; slot < this.craftMatrix.getSlots(); ++slot) {
            this.craftMatrix.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.updateCraftingOutput();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    private void setCraftResult(@Nonnull ItemStack stack) {
        this.craftResult.setStackInSlot(0, stack);
    }

    protected void updateCraftingOutput() {
        World world = this.player.func_130014_f_();
        if (!world.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)this.player;
            ItemStack stack = ItemStack.field_190927_a;
            IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)this, (World)world);
            if (recipe != null && (recipe.func_192399_d() || !world.func_82736_K().func_82766_b("doLimitedCrafting") || player.func_192037_E().func_193830_f(recipe))) {
                this.craftResult.setRecipe(recipe);
                stack = recipe.func_77572_b((InventoryCrafting)this);
            }
            this.setCraftResult(stack);
        }
    }

    public void func_194018_a(RecipeItemHelper recipeItemHelper) {
        int invSize = this.craftMatrix.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            recipeItemHelper.func_194112_a(this.craftMatrix.getStackInSlot(slot));
        }
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }
}

