/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.item.block.ItemBlockStorage;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityMSU;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.TileUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMSU
extends BlockEnderUtilitiesInventory {
    public static final PropertyEnum<EnumStorageType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumStorageType.class);

    public BlockMSU(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)CREATIVE, (Comparable)Boolean.valueOf(false)).func_177226_a(TYPE, (Comparable)((Object)EnumStorageType.MASSIVE_STORAGE_UNIT)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CREATIVE, TYPE});
    }

    @Override
    protected String[] generateUnlocalizedNames() {
        return new String[]{"msu_0", "msu_1"};
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockStorage(this);
    }

    @Override
    protected TileEntityEnderUtilities createTileEntityInstance(World worldIn, IBlockState state) {
        TileEntityMSU te = new TileEntityMSU();
        te.setStorageTier(((EnumStorageType)((Object)state.func_177229_b(TYPE))).getMeta());
        return te;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            this.func_176208_a(world, pos, state, player);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess worldIn, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getDroppedItemWithNBT(worldIn, pos, state, false));
        return items;
    }

    protected ItemStack getDroppedItemWithNBT(IBlockAccess worldIn, BlockPos pos, IBlockState state, boolean addNBTLore) {
        Random rand = worldIn instanceof World ? ((World)worldIn).field_73012_v : RANDOM;
        ItemStack stack = new ItemStack(this.func_180660_a(state, rand, 0), 1, ((EnumStorageType)((Object)state.func_177229_b(TYPE))).getMeta());
        TileEntityMSU te = BlockMSU.getTileEntitySafely(worldIn, pos, TileEntityMSU.class);
        if (te != null && InventoryUtils.getFirstNonEmptySlot(te.getBaseItemHandler()) != -1) {
            return TileUtils.storeTileEntityInStackWithCachedInventory(stack, te, addNBTLore, 9);
        }
        return stack;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175666_e(pos, (Block)this);
        worldIn.func_175713_t(pos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumStorageType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumStorageType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    @Deprecated
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntityMSU te = BlockMSU.getTileEntitySafely((IBlockAccess)world, pos, TileEntityMSU.class);
        if (te != null && te.isCreative()) {
            return -1.0f;
        }
        return super.func_176195_g(state, world, pos);
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityMSU te = BlockMSU.getTileEntitySafely(world, pos, TileEntityMSU.class);
        if (te != null) {
            state = state.func_177226_a((IProperty)CREATIVE, (Comparable)Boolean.valueOf(te.isCreative()));
        }
        return state;
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return state;
    }

    @Override
    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < EnumStorageType.values().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, EnumStorageType.values()[i].getMeta()));
        }
    }

    public static enum EnumStorageType implements IStringSerializable
    {
        MASSIVE_STORAGE_UNIT(0, "msu_0"),
        MASSIVE_STORAGE_BUNDLE(1, "msu_1");

        private final String name;
        private final int meta;

        private EnumStorageType(int meta, String nameBase) {
            this.meta = meta;
            this.name = nameBase;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumStorageType fromMeta(int meta) {
            return EnumStorageType.values()[meta % EnumStorageType.values().length];
        }
    }
}

