/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.parttype;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.materialsystem.MaterialUser;
import com.teamacronymcoders.base.materialsystem.blocks.BlockMaterialFluid;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.materialsystem.parttype.PartDataPiece;
import com.teamacronymcoders.base.materialsystem.parttype.PartType;
import com.teamacronymcoders.base.registrysystem.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidPartType
extends PartType {
    public FluidPartType() {
        super("fluid", FluidPartType.createFluidDataPieces());
    }

    private static List<PartDataPiece> createFluidDataPieces() {
        ArrayList fluidDataPieces = Lists.newArrayList();
        fluidDataPieces.add(new PartDataPiece("temperature"));
        fluidDataPieces.add(new PartDataPiece("density"));
        fluidDataPieces.add(new PartDataPiece("viscosity"));
        fluidDataPieces.add(new PartDataPiece("vaporize"));
        fluidDataPieces.add(new PartDataPiece("luminosity"));
        return fluidDataPieces;
    }

    @Override
    public void setup(@Nonnull MaterialPart materialPart, @Nonnull MaterialUser materialUser) {
        BlockMaterialFluid materialFluid = new BlockMaterialFluid(materialPart);
        materialPart.getMaterialUser().getMod().getRegistryHolder().getRegistry(BlockRegistry.class, "BLOCK").register((Block)materialFluid);
    }

    @Override
    public ItemStack getItemStack(MaterialPart materialPart) {
        FluidStack fluidStack = FluidRegistry.getFluidStack((String)materialPart.getMaterial().getUnlocalizedName(), (int)1000);
        ItemStack filledBucket = ItemStack.field_190927_a;
        if (fluidStack != null) {
            filledBucket = FluidUtil.getFilledBucket((FluidStack)fluidStack);
        }
        return filledBucket;
    }
}

